unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBase3P, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Data: TDBase3Plus;
    BQuit: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Prev: TBitBtn;
    Next: TBitBtn;
    Label10: TLabel;
    Edit10: TEdit;
    BWrite: TBitBtn;
    BNew: TBitBtn;
    Label11: TLabel;
    Label12: TLabel;
    TotalRecs: TEdit;
    Label13: TLabel;
    Label14: TLabel;
    Current: TEdit;
    Bevel1: TBevel;
    Bevel2: TBevel;
    procedure BQuitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PrevClick(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure BWriteClick(Sender: TObject);
    procedure BNewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BQuitClick(Sender: TObject);
begin
  close;
end;

procedure UpdateFields;
begin
  with form1 do
    begin
      edit1.text:=data.rec[1];
      edit2.text:=data.rec[2];
      edit3.text:=data.rec[3];
      edit4.text:=data.rec[4];
      edit5.text:=data.rec[5];
      edit6.text:=data.rec[6];
      edit7.text:=data.rec[7];
      edit8.text:=data.rec[8];
      edit9.text:=data.rec[9];
      edit10.text:=data.rec[10];

      current.text:=intToStr(data.cRecord);
      totalRecs.text:=intToStr(data.about.numRecs);
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i,j : integer;
  s   : string;

begin
  Data.open;
  UpdateFields;
end;

procedure TForm1.PrevClick(Sender: TObject);
begin
  if data.cRecord>0 then
    begin
      data.seek(data.cRecord-1);
      UpdateFields;
    end
  else
    MessageBeep($ffff);
end;

procedure TForm1.NextClick(Sender: TObject);
begin
  if data.cRecord<data.about.numRecs-1 then
    begin
      data.GotoNext;
      UpdateFields;
    end
  else
    MessageBeep($ffff);
end;

procedure TForm1.BWriteClick(Sender: TObject);
begin
  with form1 do
    begin
      data.rec[1]:=edit1.text;
      data.rec[2]:=edit2.text;
      data.rec[3]:=edit3.text;
      data.rec[4]:=edit4.text;
      data.rec[5]:=edit5.text;
      data.rec[6]:=edit6.text;
      data.rec[7]:=edit7.text;
      data.rec[8]:=edit8.text;
      data.rec[9]:=edit9.text;
      data.rec[10]:=edit10.text;
    end;

  data.write(data.cRecord);
end;

procedure TForm1.BNewClick(Sender: TObject);
begin
  data.NewRecord;
  UpdateFields;
end;

end.
