unit Dbdateed;

{ Data-Aware DateEdit Component.
  Based upon TDateEdit.
  The sub-classing technic used here is not very efficient cause
  the original component was not designed to allow such a new use.
  The main problem comes with the calender button that is a second
  component inside the TdateEdit that calls the popup form.
  By subclassing there's no mechanism let by TDateEdit to control
  the click outside the button. So it is always possible to click
  and to get the popup even ig the dataset is not in edit mode and
  even if the datasource AutoEdit is false.
  I modified a little the original component to control the ReadOnly flag
  to avoid the popup call. That works now but I'd like to do the same
  for the AutoEdit flag. I think it's possible by modifying the
  original component but, at this time, I found this way not "objectically
  correct"... Perhaps I missed something and the subclassing method
  can be used to control this behavior, if someone has an idea...
  Olivier Dahan, CIS 100531,163
  }


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Dateedit, db, dbtables;

type
  TDBDateEdit = class(TDateEdit)
  private
    { Dclarations private }
    Fres : TnotifyEvent;
    FdataLink : TFieldDataLink;
    Procedure DataChange(sender:Tobject);
    function getDataField: String;
    Function GetDataSource : TDataSource;
    Procedure SetDataField(const value:String);
    Procedure SetDataSource(value : TDataSource);
    Procedure UpdateData(Sender:Tobject);
    Procedure CMExit(var message:TCMExit); message CM_EXIT;

  protected
    { Dclarations protected }
    Procedure MouseDown(Button:TmouseButton;Shift:TshiftState;
                        X,Y: Integer); Override;
    Procedure KeyDown(Var Key:Word;Shift:TShiftState); override;
    procedure Change; override;
    Procedure BClick(sender:ToBject);
  public
    { Dclarations public }
    Constructor Create(AOwner:Tcomponent); override;
    Destructor Destroy; override;
  published
    { Dclarations published }
    Property DataField : string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Div2', [TDBDateEdit]);
end;

Constructor TDBDateEdit.Create(AOwner : Tcomponent);
begin
inherited create(AOwner);
FdataLink:= TfieldDataLink.Create;
Fdatalink.OnDataChange := DataChange;
FdataLink.OnUpdateData := UpdateData;
Fres:=Fbutton.Onclick;
Fbutton.OnClick:=BClick;
end;

Procedure TDBDateEdit.BClick(Sender:TObject);
begin
If FDataLink.Edit then Fres(Sender) else messagebeep(mb_iconexclamation);
end;

Destructor TDBDateEdit.Destroy;
begin
Fdatalink.Free;
Inherited destroy;
end;

Procedure TDBDateEdit.DataChange(sender:tobject);
begin
If FdataLink.Field = nil then Text:=''
   Else Text:=Fdatalink.Field.AsString;
end;

Function TDBDateEdit.GetDataField : String;
begin
 result := FdataLink.FieldName;
end;

Function TDBDateEdit.GetDataSource : TDataSource;
begin
 Result := FdataLink.DataSource;
end;

Procedure TDBDateEdit.SetDataField(const value : string);
begin
 FdataLink.FieldName:=Value;
end;

procedure TDBDateEdit.SetDataSource(value : TDataSource);
begin
 FdataLink.DataSource:=Value;
end;

Procedure TDBDateEdit.UpdateData(Sender: TObject);
begin
if Fdatalink.edit then FdataLink.Field.AsString:=Text
                  else Text:=Fdatalink.Field.AsString;
end;

Procedure TDBDateEdit.MouseDown(Button:TmouseButton;Shift:TshiftState;
                        X,Y: Integer);
var MyMouseMove : TmouseEvent;
begin
If Not ReadOnly and Fdatalink.Edit then
   Inherited MouseDown(Button, shift, X, Y)
   else
   Begin
    MyMouseMove := OnMouseDown;
    if Assigned(MyMousemove) then MyMouseMove(self,button,shift,x,y);
   end;
end;

Procedure TDBDateEdit.KeyDown(Var Key:Word;Shift:TShiftState);
var MyKeyDown : TKeyEvent;
begin
If Not ReadOnly and (key in [vk_up,vk_down,vk_left,vk_right,vk_end,
                    vk_home,vk_prior,vk_next]) and Fdatalink.Edit
                    then inherited KeyDown(Key,Shift)
                    else
                    begin
                     MyKeyDown := OnKeyDOwn;
                     If Assigned(MyKeyDown) then MyKeyDOwn(Self, key, shift);
                    end;
end;

Procedure TDBDateEdit.Change;
begin
 FdataLink.Modified;
 Inherited Change;
end;

Procedure TDBDateEdit.CMEXIT(Var message:TCMEXIT);
begin
 try
  FdataLink.UpdateRecord;
 except
  setfocus;
  raise;
 end;
 inherited;
end;

end.
