unit Elastic;

(*********************************************
TElasticPanel -> TPanel

Dynamically resizes child control when resized.

PROPERTIES:

ElasticHorizontal - Turn horizontal resizing on or off.

ElasticVertical - Turn vertical resizing on or off.
*********************************************)
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TElasticPanel = class( TPanel )
  private
     FHorz, FVert: boolean;
     nOldWidth, nOldHeight: integer;
     bResized: boolean;
  protected
     procedure WMSize( var message: TWMSize ); message WM_SIZE;
  public
     constructor Create( AOwner: TComponent ); override;
  published
     property ElasticHorizontal: boolean read FHorz write FHorz default TRUE;
     property ElasticVertical: boolean read FVert write FVert default TRUE;
  end;

procedure Register;

implementation

constructor TElasticPanel.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  FHorz := TRUE;
  FVert := TRUE;
  nOldWidth := Width;
  nOldHeight := Height;
  bResized := FALSE;
  Align := alClient;
end;

procedure TElasticPanel.WMSize( var message: TWMSize );
var
  bResize: boolean;
  xRatio: real;
  i: integer;
  ctl: TWinControl;
begin
  if not ( csDesigning in ComponentState ) then
     begin
        if bResized then
           begin
              if FHorz then
                 begin
                    xRatio := Width / nOldWidth;
                    for i := 0 to ControlCount - 1 do
                       begin
                          ctl := TWinControl( Controls[i] );
                          ctl.Left := Round( ctl.Left * xRatio );
                          ctl.Width := Round( ctl.Width * xRatio );
                       end;
                 end;
              if FVert then
                 begin
                    xRatio := Height / nOldHeight;
                    for i := 0 to ControlCount - 1 do
                       begin
                          ctl := TWinControl( Controls[i] );
                          ctl.Top := Round( ctl.Top * xRatio );
                          ctl.Height := Round( ctl.Height * xRatio );
                       end;
                 end;
           end;
        bResized := TRUE;
        nOldWidth := Width;
        nOldHeight := Height;
     end;
end;

procedure Register;
begin
  RegisterComponents('Additional', [TElasticPanel]);
end;

end.
