{
 Designer: Craig Ward, 100554.2072@compuserve.com
 Date:     20/11/95

 Function: Example of using the TAppException component

 Notes:    This project won't compile unless the TAppException component has
           been added to your VCL. Furthermore, please remember to point the
           component to a valid text-file.
*******************************************************************************}
unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Appex, Buttons;

type
  TForm1 = class(TForm)
    AppException1: TAppException;
    Button1: TButton;
    Edit1: TEdit;
    Button2: TButton;
    SpeedButton1: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 {set the properties of the component}
 appException1.ErrorLog := 'c:\windows\errorlog.txt';
 appException1.UserName := 'CRAIG WARD';
 {set the application's exception handling}
 application.OnException := appException1.WriteException;
end;

{first exception - conversion error}
procedure TForm1.Button1Click(Sender: TObject);
var
 i: integer;
begin
 i := StrToInt(edit1.text);
end;

{second exception - divide by zero}
procedure TForm1.Button2Click(Sender: TObject);
var
 b: byte;
begin
 b := 0;
 b := 1 div b;
end;

{view error-log}
procedure TForm1.SpeedButton1Click(Sender: TObject);
var
 p: pChar;
begin
 try
  p := StrAlloc(256);
  StrPCopy(p, ('c:\windows\notepad.exe '+appException1.errorLog));
  WinExec(p, SW_SHOWNORMAL);
 finally
  StrDispose(p);
 end;
end;

end.
