unit Aaplayr1;

{ Demo program for flic player component }
{ 14th October 1995 }

{ ------------------------------------------------------------------------- }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Spin, Menus, FlicPlyr, Gauges,
  AAPlayr2, MMSystem, MPlayer;

const
   SYSTEM_PATH_LENGTH = 144;
   USER_PATH_LENGTH = 255;

type
  TForm1 = class(TForm)
    FlicPlayer1: TFlicPlayer;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    MemLoad: TMenuItem;
    Gauge1: TGauge;
    Timer1: TTimer;
    Bevel3: TBevel;
    OpenDialog2: TOpenDialog;
    N2: TMenuItem;
    LoopPlay: TMenuItem;
    N3: TMenuItem;
    Exitprogram1: TMenuItem;
    AnimGroupBox: TGroupBox;
    Label3: TLabel;
    WidthValue: TEdit;
    HeightValue: TEdit;
    FramesLabel: TLabel;
    FramesValue: TEdit;
    SpeedValue: TEdit;
    Anim2GroupBox: TGroupBox;
    Label5: TLabel;
    SpeedEdit: TSpinEdit;
    XEdit: TEdit;
    YEdit: TEdit;
    PauseSpinEdit: TSpinEdit;
    Label2: TLabel;
    Label6: TLabel;
    FramePanel: TPanel;
    LoopPanel: TPanel;
    Label4: TLabel;
    OrgXEdit: TEdit;
    OrgYEdit: TEdit;
    Label1: TLabel;
    WidthEdit: TEdit;
    HeightEdit: TEdit;
    TransInGroup: TRadioGroup;
    TransOutGroup: TRadioGroup;
    TimeInSpinEdit: TSpinEdit;
    TimeOutSpinEdit: TSpinEdit;
    NotifyGroupBox: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    OpenDialog3: TOpenDialog;
    NotifyCancelButton: TButton;
    SoundGroupBox: TGroupBox;
    Label7: TLabel;
    SoundEdit: TSpinEdit;
    Sound1: TMenuItem;
    Associate1: TMenuItem;
    SoundLooping1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedEditChange(Sender: TObject);
    procedure OpenFlicFile(AFilename: string);
    procedure FlicPlayer1Click(Sender: TObject; Button: TMPBtnType;
              var DoDefault: Boolean);
    procedure Open1Click(Sender: TObject);
    procedure XEditChange(Sender: TObject);
    procedure YEditChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Associate1Click(Sender: TObject);
{    procedure Setlooping1Click(Sender: TObject);}
    procedure NotifyCheckBoxClick(Sender: TObject);
    procedure MemLoadClick(Sender: TObject);
    procedure LoopPlayClick(Sender: TObject);
    procedure TransInGroupClick(Sender: TObject);
    procedure TransOutGroupClick(Sender: TObject);
    procedure TimeInSpinEditChange(Sender: TObject);
    procedure TimeOutSpinEditChange(Sender: TObject);
    procedure PauseSpinEditChange(Sender: TObject);
    procedure WidthEditChange(Sender: TObject);
    procedure HeightEditChange(Sender: TObject);
    procedure NotifyCancelButtonClick(Sender: TObject);
    procedure SoundEditChange(Sender: TObject);
    procedure Exitprogram1Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure SoundButtonClick(Sender: TObject);
    procedure SoundLooping1Click(Sender: TObject);
  private
    { Private declarations }
    SoundLoops: integer;
    SoundPtrs: array[1..10] of PChar;
    SoundFlags: array[1..10] of Boolean;
  public
    { Public declarations }
   protected
    { Protected declarations }
    procedure WndProc(var Message: TMessage); override;
  end;

var
  Form1: TForm1;
  { The following two are needed because trying to access the message
      numbers in the flic player component in a form's WndProc
      causes a GPF when WndProc is called during form (and hence
      flic player) creation: }
   NotifyMessageNum: word;
   StopMessageNum: word;

{ ------------------------------------------------------------------------- }
implementation

{$R *.DFM}

{ ------------------------------------------------------------------------- }
procedure TForm1.FormCreate(Sender: TObject);

var
   tempp: integer;

begin
   SoundEdit.Enabled := FALSE;
   SoundGroupBox.Enabled := FALSE;

   for tempp := 1 to 10 do
      begin
      GetMem(SoundPtrs[tempp], SYSTEM_PATH_LENGTH);
      end;

   for tempp := 1 to 10 do
      begin
      SoundFlags[tempp] := FALSE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.FormDestroy(Sender: TObject);

var
   tempp: integer;

begin

   for tempp := 1 to 10 do
      begin
      FreeMem(SoundPtrs[tempp], SYSTEM_PATH_LENGTH);
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Open1Click(Sender: TObject);

begin

     if OpenDialog1.Execute then
        OpenFlicFile(OpenDialog1.Filename)

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.OpenFlicFile(AFilename: string);

var
   tempstr: string[12];

begin
   Form2.Enabled := TRUE;
   { If these are in Form1's constructor, causes GPF }
   NotifyMessageNum := FlicPlayer1.NotifyMessageNum;
   StopMessageNum := FlicPlayer1.StopMessageNum;

   with FlicPlayer1 do
      begin
      FileName := AFileName;
      Display := Form2.Panel1;
{      AutoEnable := FALSE;}
      Open;
      CallbackHandle := Form1.handle; { This must follow Open }
      str(FlicWidth, tempstr);
      WidthValue.Text := tempstr;
      str(FlicHeight, tempstr);
      HeightValue.Text := tempstr;
      str(FlicFrames, tempstr);
      FramesValue.Text := tempstr;
      str(DesignSpeed, tempstr);
      SpeedValue.Text := tempstr;
      SpeedEdit.Value := Speed;
      SpeedEdit.Enabled := TRUE;
      XEdit.Enabled := TRUE;
      YEdit.Enabled := TRUE;
      OrgXEdit.Enabled := TRUE;
      str(OrgX, tempstr);
      OrgXEdit.Text := tempstr;
      OrgYEdit.Enabled := TRUE;
      str(OrgY, tempstr);
      OrgYEdit.Text := tempstr;
      WidthEdit.Enabled := TRUE;
      str(FlicWidth, tempstr);
      WidthEdit.Text := tempstr;
      HeightEdit.Enabled := TRUE;
      str(FlicHeight, tempstr);
      HeightEdit.Text := tempstr;
      Gauge1.progress := 1;
      FramePanel.Caption := '1';
      LoopPanel.Caption := '1';
      Gauge1.maxvalue := FlicFrames;
      TransInGroup.ItemIndex := integer(TransitionIn);
      TransInGroup.Enabled := TRUE;
      TransOutGroup.ItemIndex := integer(TransitionOut);
      TransOutGroup.Enabled := TRUE;
      TimeInSpinEdit.Value := TimeIn;
      TimeOutSpinEdit.Value := TimeOut;
      TimeInSpinEdit.Enabled := TRUE;
      TimeOutSpinEdit.Enabled := TRUE;
      PauseSpinEdit.Value := PauseTime;
      PauseSpinEdit.Enabled := TRUE;
      SoundLoops := 0;
      Associate1.enabled := TRUE;
      SoundLooping1.enabled := TRUE;
      LoopPlay.Enabled := TRUE;           { turn on play looping menu }
      X := 4;                             { to let the panel border show }
      Y := 4;
      PlayLoops := FlicFrames;            { play animation once }
      end;

   Form2.ClientWidth := FlicPlayer1.FlicWidth + 24;
   Form2.ClientHeight := FlicPlayer1.FlicHeight + 24;
   Form2.Panel1.Width := FlicPlayer1.FlicWidth + 8;
   Form2.Panel1.Height := FlicPlayer1.FlicHeight + 8;
   Form2.Caption := ExtractFilename(AFilename);
   Form2.Visible := TRUE;
   Form2.Panel1.Visible := TRUE;
   CheckBox1.Enabled := TRUE;
   CheckBox2.Enabled := TRUE;
   CheckBox3.Enabled := TRUE;
   CheckBox4.Enabled := TRUE;
   CheckBox5.Enabled := TRUE;
   CheckBox6.Enabled := TRUE;
   CheckBox7.Enabled := TRUE;
   CheckBox8.Enabled := TRUE;
   CheckBox9.Enabled := TRUE;
   CheckBox10.Enabled := TRUE;
   Associate1.Enabled := TRUE;      { turn on sound association button }
   SoundLooping1.enabled := TRUE;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.FlicPlayer1Click(Sender: TObject; Button: TMPBtnType;
                                 var DoDefault: Boolean);
var
   tempstr: string[12];
   tempp: integer;

begin
   DoDefault := FALSE;

   with FlicPlayer1 do
      begin
      case Button of
         btPlay:
         begin
         Play;
         CheckBox1.Enabled := FALSE;
         CheckBox2.Enabled := FALSE;
         CheckBox3.Enabled := FALSE;
         CheckBox4.Enabled := FALSE;
         CheckBox5.Enabled := FALSE;
         CheckBox6.Enabled := FALSE;
         CheckBox7.Enabled := FALSE;
         CheckBox8.Enabled := FALSE;
         CheckBox9.Enabled := FALSE;
         CheckBox10.Enabled := FALSE;
         Timer1.Enabled := TRUE;
{         EnabledButtons := [btPause,btStop];}
         end;

         btPause:
         begin
         Pause;
         if SoundFlags[1] = FALSE then
            CheckBox1.Enabled := TRUE;
         if SoundFlags[2] = FALSE then
            CheckBox2.Enabled := TRUE;
         if SoundFlags[3] = FALSE then
            CheckBox3.Enabled := TRUE;
         if SoundFlags[4] = FALSE then
            CheckBox4.Enabled := TRUE;
         if SoundFlags[5] = FALSE then
            CheckBox5.Enabled := TRUE;
         if SoundFlags[6] = FALSE then
            CheckBox6.Enabled := TRUE;
         if SoundFlags[7] = FALSE then
            CheckBox7.Enabled := TRUE;
         if SoundFlags[8] = FALSE then
            CheckBox8.Enabled := TRUE;
         if SoundFlags[9] = FALSE then
            CheckBox9.Enabled := TRUE;
         if SoundFlags[10] = FALSE then
            CheckBox10.Enabled := TRUE;
         Timer1.Enabled := FALSE;
{         EnabledButtons := [btPlay,btNext,btPrev,btStep,btBack,btEject];}
         Gauge1.progress := CurrentFrame;
         str(CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         end;

         btStop:
         begin
         Stop;
         if SoundFlags[1] = FALSE then
            CheckBox1.Enabled := TRUE;
         if SoundFlags[2] = FALSE then
            CheckBox2.Enabled := TRUE;
         if SoundFlags[3] = FALSE then
            CheckBox3.Enabled := TRUE;
         if SoundFlags[4] = FALSE then
            CheckBox4.Enabled := TRUE;
         if SoundFlags[5] = FALSE then
            CheckBox5.Enabled := TRUE;
         if SoundFlags[6] = FALSE then
            CheckBox6.Enabled := TRUE;
         if SoundFlags[7] = FALSE then
            CheckBox7.Enabled := TRUE;
         if SoundFlags[8] = FALSE then
            CheckBox8.Enabled := TRUE;
         if SoundFlags[9] = FALSE then
            CheckBox9.Enabled := TRUE;
         if SoundFlags[10] = FALSE then
            CheckBox10.Enabled := TRUE;
         Timer1.Enabled := FALSE;
{         EnabledButtons := [btPlay,btEject];}
         Gauge1.progress := CurrentFrame;
         str(CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         end;

         btStep:
         begin
         Step;
         str(CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := CurrentFrame;
         end;

         btBack:
         begin
         Back;
         str(CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := CurrentFrame;
         end;

         btNext:
         begin
         Next;
         str(CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := CurrentFrame;
         end;

         btPrev:
         begin
         Previous;
         str(CurrentFrame, tempstr);
         FramePanel.Caption := tempstr;
         str(CurrentLoop, tempstr);
         LoopPanel.Caption := tempstr;
         Gauge1.progress := CurrentFrame;
         end;

         btEject:
         begin
         Eject;
         Form2.Caption := '';
         EnabledButtons := [];
         WidthValue.Text := '';
         HeightValue.Text := '';
         FramesValue.Text := '';
         SpeedValue.Text := '';
         SpeedEdit.Value := 0;
         XEdit.Text := '4';
         YEdit.Text := '4';
         OrgXEdit.Text := '0';
         OrgYEdit.Text := '0';
         WidthEdit.Text := '';
         HeightEdit.Text := '';
         SpeedEdit.Enabled := FALSE;
         XEdit.Enabled := FALSE;
         YEdit.Enabled := FALSE;
         OrgXEdit.Enabled := FALSE;
         OrgYEdit.Enabled := FALSE;
         WidthEdit.Enabled := FALSE;
         HeightEdit.Enabled := FALSE;
         TransInGroup.ItemIndex := -1;
         TransInGroup.Enabled := FALSE;
         TransOutGroup.ItemIndex := -1;
         TransOutGroup.Enabled := FALSE;
         TimeInSpinEdit.Value := 500;
         TimeOutSpinEdit.Value := 500;
         TimeInSpinEdit.Enabled := FALSE;
         TimeOutSpinEdit.Enabled := FALSE;
         PauseSpinEdit.Value := 0;
         PauseSpinEdit.Enabled := FALSE;
         Gauge1.Progress := 0;
         FramePanel.Caption := '';
         LoopPanel.Caption := '';
         Timer1.Enabled := FALSE;
         Form2.Enabled := FALSE;
         Form2.Visible := FALSE;
         SoundLooping1.enabled := FALSE;
         Associate1.Enabled := FALSE;     { disable associate sound menu }
         LoopPlay.Checked := FALSE;       { turn off play looping menu }
         LoopPlay.Enabled := FALSE;       { turn off play looping menu }
         SoundEdit.Enabled := FALSE;
         SoundEdit.Text := '0';
         SoundLoops := 0;
         CheckBox1.Checked := FALSE;
         CheckBox2.Checked := FALSE;
         CheckBox3.Checked := FALSE;
         CheckBox4.Checked := FALSE;
         CheckBox5.Checked := FALSE;
         CheckBox6.Checked := FALSE;
         CheckBox7.Checked := FALSE;
         CheckBox8.Checked := FALSE;
         CheckBox9.Checked := FALSE;
         CheckBox10.Checked := FALSE;
         CheckBox1.Enabled := FALSE;
         CheckBox2.Enabled := FALSE;
         CheckBox3.Enabled := FALSE;
         CheckBox4.Enabled := FALSE;
         CheckBox5.Enabled := FALSE;
         CheckBox6.Enabled := FALSE;
         CheckBox7.Enabled := FALSE;
         CheckBox8.Enabled := FALSE;
         CheckBox9.Enabled := FALSE;
         CheckBox10.Enabled := FALSE;

         for tempp := 1 to 10 do
            begin
            SoundFlags[tempp] := FALSE;
            end;

         end;

      end;

   end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Timer1Timer(Sender: TObject);

var
   templong: longint;
   tempstr: string[8];

begin

   with FlicPlayer1 do
      begin
      Gauge1.progress := CurrentFrame;
      str(CurrentFrame, tempstr);
      Form1.FramePanel.Caption := tempstr;
      str(CurrentLoop, tempstr);
      Form1.LoopPanel.Caption := tempstr;
      end;

end;

{ ------------------------------------------------------------------------- }
{ ------------------------------------------------------------------------- }
procedure TForm1.SpeedEditChange(Sender: TObject);

begin
   FlicPlayer1.Speed := SpeedEdit.Value;
end;


{ ------------------------------------------------------------------------- }
procedure TForm1.Associate1Click(Sender: TObject);

begin

   if OpenDialog2.Execute then
      begin
      FlicPlayer1.Sound := OpenDialog2.Filename;
      Form2.Caption := ExtractFilename(FlicPlayer1.Filename) + ' + ' +
                                    ExtractFilename(OpenDialog2.Filename);
      SoundEdit.Enabled := TRUE;
      SoundGroupBox.Enabled := TRUE;
      end;

end;


{ ------------------------------------------------------------------------- }
procedure TForm1.XEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin

   if Sender = XEdit then
      begin
      val(XEdit.Text, temp2, temp);

      if (temp = 0) and (temp2 > -1) then
         begin
         FlicPlayer1.X := temp2;
         end;

      end;

   if Sender = OrgXEdit then
      begin
      val(OrgXEdit.Text, temp2, temp);

      if (temp = 0) and (temp2 > -1) then
         begin
         FlicPlayer1.OrgX := temp2;
         end;

      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.YEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin

   if Sender = YEdit then
      begin
      val(YEdit.Text, temp2, temp);

      if (temp = 0) and (temp2 > -1) then
         begin
         FlicPlayer1.Y := temp2;
         end;

      end;

   if Sender = OrgYEdit then
      begin
      val(OrgYEdit.Text, temp2, temp);

      if (temp = 0) and (temp2 > -1) then
         begin
         FlicPlayer1.OrgY := temp2;
         end;

      end;

end;


{ ------------------------------------------------------------------------- }
{procedure TForm1.Setlooping1Click(Sender: TObject);

begin
   Setlooping1.Checked := not Setlooping1.Checked;
   FlicPlayer1.SoundLooping := not FlicPlayer1.SoundLooping;
end;


}
{ ------------------------------------------------------------------------- }
procedure TForm1.NotifyCheckBoxClick(Sender: TObject);

var
   temp, temp2: integer;
   retcode: boolean;

begin
   val(TCheckBox(Sender).Caption, temp2, temp);

   if ((SoundFlags[temp2] = FALSE) and (FlicPlayer1.FlicLoaded = TRUE)) then
      begin

      if OpenDialog3.Execute then
         begin

         with FlicPlayer1 do
            Notify(CurrentLoop, CurrentFrame, temp2);

         SoundPtrs[temp2] := StrPLCopy(SoundPtrs[temp2], OpenDialog3.Filename,
                                                      SYSTEM_PATH_LENGTH);
         TCheckBox(Sender).Enabled := FALSE;
         SoundFlags[temp2] := TRUE;
         end
      else
         begin
         TCheckBox(Sender).Checked := FALSE;   { user cancelled }
         end;

      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.MemLoadClick(Sender: TObject);

begin
   MemLoad.Checked := not MemLoad.Checked;
   FlicPlayer1.LoadToMemory := not FlicPlayer1.LoadToMemory;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.LoopPlayClick(Sender: TObject);

begin

   if LoopPlay.Checked = TRUE then
      begin
      FlicPlayer1.PlayLoops := FlicPlayer1.FlicFrames;
      LoopPlay.Checked := FALSE;
      end
   else
      begin
      FlicPlayer1.PlayLoops := 0;
      LoopPlay.Checked := TRUE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.TransInGroupClick(Sender: TObject);

begin

   if (TransInGroup.ItemIndex > -1) and (TransInGroup.ItemIndex < 3) then
      begin
      FlicPlayer1.TransitionIn := AATransition(TransInGroup.ItemIndex);
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.TransOutGroupClick(Sender: TObject);

begin

   if (TransOutGroup.ItemIndex > -1) and (TransOutGroup.ItemIndex < 3) then
      begin
      FlicPlayer1.TransitionOut := AATransition(TransOutGroup.ItemIndex);
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.TimeInSpinEditChange(Sender: TObject);

begin
   FlicPlayer1.TimeIn := TimeInSpinEdit.Value;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.TimeOutSpinEditChange(Sender: TObject);

begin
   FlicPlayer1.TimeOut := TimeOutSpinEdit.Value;
end;



{ ------------------------------------------------------------------------- }
procedure TForm1.PauseSpinEditChange(Sender: TObject);

begin
   FlicPlayer1.PauseTime := PauseSpinEdit.Value;
end;


{ ------------------------------------------------------------------------- }
procedure TForm1.WidthEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin
   val(WidthEdit.Text, temp2, temp);

   if (temp = 0) and (temp2 > 0) then
      begin
      FlicPlayer1.CX := temp2;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.HeightEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin
   val(HeightEdit.Text, temp2, temp);

   if (temp = 0) and (temp2 > 0) then
      begin
      FlicPlayer1.CY := temp2;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.NotifyCancelButtonClick(Sender: TObject);

var
   tempp: integer;

begin

   if (FlicPlayer1.FlicLoaded = TRUE) then
      begin
      FlicPlayer1.CancelAll;
      CheckBox1.Enabled := FALSE;
      CheckBox2.Enabled := FALSE;
      CheckBox3.Enabled := FALSE;
      CheckBox4.Enabled := FALSE;
      CheckBox5.Enabled := FALSE;
      CheckBox6.Enabled := FALSE;
      CheckBox7.Enabled := FALSE;
      CheckBox8.Enabled := FALSE;
      CheckBox9.Enabled := FALSE;
      CheckBox10.Enabled := FALSE;
      CheckBox1.Checked := FALSE;
      CheckBox2.Checked := FALSE;
      CheckBox3.Checked := FALSE;
      CheckBox4.Checked := FALSE;
      CheckBox5.Checked := FALSE;
      CheckBox6.Checked := FALSE;
      CheckBox7.Checked := FALSE;
      CheckBox8.Checked := FALSE;
      CheckBox9.Checked := FALSE;
      CheckBox10.Checked := FALSE;
      CheckBox1.Enabled := TRUE;
      CheckBox2.Enabled := TRUE;
      CheckBox3.Enabled := TRUE;
      CheckBox4.Enabled := TRUE;
      CheckBox5.Enabled := TRUE;
      CheckBox6.Enabled := TRUE;
      CheckBox7.Enabled := TRUE;
      CheckBox8.Enabled := TRUE;
      CheckBox9.Enabled := TRUE;
      CheckBox10.Enabled := TRUE;
      end;

   for tempp := 1 to 10 do
      begin
      SoundFlags[tempp] := FALSE;
      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.SoundEditChange(Sender: TObject);

var
   temp, temp2: integer;

begin
   val(SoundEdit.Text, temp2, temp);

   if ((temp = 0) and (temp2 > 0)) then
      begin
      FlicPlayer1.SoundLoops := temp2;
      end;
      
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Exitprogram1Click(Sender: TObject);

begin
   Application.Terminate;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.Help2Click(Sender: TObject);

var
   tempb: bool;

begin
   tempb := WinHelp(Form1.handle, 'flicplyr.hlp', HELP_CONTENTS, 0);
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.WndProc(var Message: TMessage);

var
   retcode: boolean;

begin

   with Message do
      begin

      if Msg = NotifyMessageNum then
         begin

         if (lParam > 0) and (lParam < 11) then
            begin
            retcode := sndPlaySound(SoundPtrs[lParam], SND_ASYNC + SND_NODEFAULT);
            end;

         end
      else
         begin

         if Msg = StopMessageNum then
            begin
            FlicPlayer1.EnabledButtons := [btPlay,btEject,btNext,btPrev,btBack,btStep];
            if SoundFlags[1] = FALSE then
               CheckBox1.Enabled := TRUE;
            if SoundFlags[2] = FALSE then
               CheckBox2.Enabled := TRUE;
            if SoundFlags[3] = FALSE then
               CheckBox3.Enabled := TRUE;
            if SoundFlags[4] = FALSE then
               CheckBox4.Enabled := TRUE;
            if SoundFlags[5] = FALSE then
               CheckBox5.Enabled := TRUE;
            if SoundFlags[6] = FALSE then
               CheckBox6.Enabled := TRUE;
            if SoundFlags[7] = FALSE then
               CheckBox7.Enabled := TRUE;
            if SoundFlags[8] = FALSE then
               CheckBox8.Enabled := TRUE;
            if SoundFlags[9] = FALSE then
               CheckBox9.Enabled := TRUE;
            if SoundFlags[10] = FALSE then
               CheckBox10.Enabled := TRUE;
           end
         else
            begin
            inherited WndProc(Message);
            end;

         end;

      end;

end;

{ ------------------------------------------------------------------------- }
procedure TForm1.SoundButtonClick(Sender: TObject);
begin
;
end;

{ ------------------------------------------------------------------------- }
procedure TForm1.SoundLooping1Click(Sender: TObject);
begin
   FlicPlayer1.SoundLooping := not FlicPlayer1.SoundLooping;
   SoundLooping1.checked := not SoundLooping1.checked;
end;

{ ------------------------------------------------------------------------- }
end.
{ ------------------------------------------------------------------------- }

