{ This component lists all the screen fonts on an owner draw combobox
  with a small bitmap indicates whether the font is true type or not.
  By Hardy Yau, CIS 102144,712. No Copyright. No Fee. No Guarantee. Enjoy!}
(*  Special thanks to Xavier Pacheco for answering my questions. *)

unit Fontcomb;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus;

type
  TFontComboBox = class(TCustomComboBox)
  private
    { Private declarations }
    FBitmap: TBitmap;
    FCanvas: TControlCanvas;
    function  IsTrueType(Index: Integer): Boolean;
    procedure DrawTT(Background: TColor);
  protected
    { Protected declarations }
    procedure CreateWnd; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure   DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
  published
    { Published declarations }
    property Color;
    property Ctl3D;
    property DragMode;
    property DragCursor;
    property DropDownCount;
    property Enabled;
    property ParentColor;
    property ParentCtl3D;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDropDown;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TFontComboBox]);
end;

constructor TFontComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Font.Name := 'MS Sans Serif';
  Font.Size := 8;
  Font.Style := Font.Style - [fsBold];
  Sorted := True;
  Style := csOwnerDrawFixed;
  ItemHeight := 16;
  {Create a bitmap for drawing}
  FBitmap := TBitmap.Create;
  FBitmap.Height := 12;
  FBitmap.Width := 12;
  {Create a Canvas for checking True Type property}
  FCanvas := TControlCanvas.Create;
  FCanvas.Control := Self;
end;

destructor TFontComboBox.Destroy;
begin
  FBitmap.Free;
  FCanvas.Free;
  inherited Destroy;
end;

procedure TFontComboBox.CreateWnd;
begin
  inherited CreateWnd;
  Items.Assign(Screen.Fonts);
  ItemIndex := 0;
end;

procedure TFontComboBox.DrawItem(Index: Integer; Rect: TRect;
  State: TOwnerDrawState);
begin
  { Rect.Left = 3 means drawing on the Static portion of the ComboBox }
  with Canvas do begin
    FillRect(Rect);
    if IsTrueType(Index) and (Rect.Left <> 3) then begin
       DrawTT(Brush.Color);
       Draw(Rect.Left+2, Rect.Top+2, FBitmap);
    end;
    if (Rect.Left <> 3) then
       TextOut(Rect.Left+16, Rect.Top, Items[Index])
    else
       TextOut(Rect.Left, Rect.Top, Items[Index])
  end;
end;

function TFontComboBox.IsTrueType(Index: Integer): Boolean;
var
  Metrics: TTextMetric;
  lf: TLogFont;
  oldFont, newFont: HFont;
begin
  with lf do begin
    lfHeight := 10;
    lfWidth := 10;
    lfEscapement := 0;
    lfWeight := FW_REGULAR;
    lfItalic := 0;
    lfUnderline := 0;
    lfStrikeOut := 0;
    lfCharSet := DEFAULT_CHARSET;
    lfOutPrecision := OUT_DEFAULT_PRECIS;
    lfClipPrecision := CLIP_DEFAULT_PRECIS;
    lfQuality := DEFAULT_QUALITY;
    lfPitchAndFamily := DEFAULT_PITCH or FF_DONTCARE;
    StrPCopy(lfFaceName, Items[Index]);
  end;
  newFont := CreateFontIndirect(lf);
  oldFont := SelectObject(FCanvas.Handle, newFont);
  GetTextMetrics(FCanvas.Handle, Metrics);
  Result := (Metrics.tmPitchAndFamily and TMPF_TRUETYPE) <> 0;
  SelectObject(FCanvas.Handle, oldFont);
  DeleteObject(newFont);
end;

procedure TFontComboBox.DrawTT(Background: TColor);
  procedure DrawT(OrgX, OrgY: Integer; Color: TColor);
  begin
   with FBitmap.Canvas do begin
     Brush.Style := bsSolid;
     Pen.Color := Color;
     MoveTo(OrgX,OrgY);
     LineTo(OrgX+7,OrgY);
     LineTo(OrgX+7,OrgY+3);
     MoveTo(OrgX,OrgY);
     LineTo(OrgX,OrgY+3);
     MoveTo(OrgX+1,OrgY);
     LineTo(OrgX+1,OrgY+1);
     MoveTo(OrgX+6,OrgY);
     LineTo(OrgX+6,OrgY+1);
     MoveTo(OrgX+3,OrgY);
     LineTo(OrgX+3,OrgY+8);
     MoveTo(OrgX+4,OrgY);
     LineTo(OrgX+4,OrgY+8);
     MoveTo(OrgX+1,OrgY+8);
     LineTo(OrgX+6,OrgY+8);
   end;
  end;
begin
  with FBitmap.Canvas do begin
    Brush.Style := bsClear;
    Brush.Color := background;
    FillRect(Rect(0,0,12,12));
    DrawT(0,0,clGray);
    DrawT(4,3,clBlack);
  end;
end;

end.
