{ccGraphicButton - A sort-of 'Shareware' VCL for Borland's Delphi

Version 1.0a - 8/11/95
  - Corrected palette problems not noticed originally due to using a 16bit
    colour driver.
  - GBUTTON2 is virtually finished, and handles much much more.

This VCL lets you create and use 'transparent buttons' and 'graphic
buttons'.

The code contained within this file is copyright Casey Charlton 1995.

You may use this code in it's entirety, without modification (including
this header), in any non-commercial project. In this case this VCL is Freeware.

Should you wish to either a) modify the code, or b) use this component,
or any modified (or descendant) version of it, then this VCL becomes
Shareware. As such I ask only that you send as much as you think that
this VCL is worth to you (a good guide would be to work out how long it
would take you to write and debug a similar component ).

Those registering will recieve version 2 (and will have a say as to what
they want in version 2) when it becomes available, and will recieve any,
and all, updates I make until then.

To arrange payment contact me at :  casey@larouss.demon.co.uk

While I fully appreciate that you may just copy segments of this code,
I might remind you that it took me many hours to write (and many more
to debug), and therefore it will be on your conscience. I have not
attempted to limit your use of this VCL in any way, so it's up to you.


I look forward to receiving large sums of money ;-)                  }


unit Gbutton;

interface

uses
  SysUtils, StdCtrls, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TccGraphicButton = class(TGraphicControl)
  private
    FButtonPicture : TBitmap;
    FButtonMask : TBitmap;
    FNumberOfButtons : Integer;
    FCurrentButton : Integer;
    FTransparent : Boolean;
    FPaletteBitmap : TBitmap;
    procedure SetButtonPicture(Value : TBitmap);
    procedure SetButtonMask(Value : TBitmap);
    procedure SetNumberOfButtons(Value : Integer);
    procedure SetCurrentButton(Value : Integer);
    procedure SetTransparent(Value : Boolean);
    procedure SetPalette(Value : TBitmap);
  protected
    procedure Paint; override;
    function GetPalette: HPALETTE; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Visible;
    property ButtonPicture : TBitmap read  FButtonPicture
                                     write SetButtonPicture;
    property ButtonMask    : TBitmap read  FButtonMask
                                     write SetButtonMask;
    property NumberOfButtons : Integer read  FNumberOfButtons
                                     write SetNumberOfButtons;
    property CurrentButton  : Integer read  FCurrentButton
                                     write SetCurrentButton;
    property Transparent   : Boolean read  FTransparent
                                     write SetTransparent;
    property PaletteBitmap : TBitmap read FPaletteBitmap
                                     write SetPalette;
    property OnClick;
    property OnDblClick;
    property OnMouseDown;
    property OnMouseUp;
    property OnMouseMove;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
  end;

procedure Register;

implementation

constructor TccGraphicButton.Create(AOwner : TComponent);
begin
     inherited Create(AOwner);
     FButtonPicture := TBitmap.Create;
     FButtonMask := TBitmap.Create;
     FPaletteBitmap := TBitmap.Create;
     Width := 30;
     Height := 30;
     FCurrentButton := 1;
     FNumberOfButtons := 1;
     Invalidate;
end;

destructor TccGraphicButton.Destroy;
begin
     FButtonPicture.Free;
     FButtonMask.Free;
     FPaletteBitmap.Free;
     inherited Destroy;
end;

procedure TccGraphicButton.SetButtonPicture(Value : TBitmap);
begin
     FButtonPicture.Assign(Value);
     Height := FButtonPicture.Height;
     if FNumberOfButtons = 0
     then Width := FButtonPicture.Width
     else Width := FButtonPicture.Width div FNumberOfButtons;
     if Height = 0 then Height := 30;
     if Width = 0 then Width :=30;
     Invalidate;
end;

procedure TccGraphicButton.SetButtonMask(Value : TBitmap);
begin
     FButtonMask.Assign(Value);
     Invalidate;
end;

procedure TccGraphicButton.SetPalette(Value : TBitmap);
begin
     FPaletteBitmap.Assign(Value);
     Invalidate;
end;

procedure TccGraphicButton.SetNumberOfButtons(Value : Integer);
begin
     if (Value <> FNumberOfButtons) and (Value > 0) then
     begin
          FNumberOfButtons := Value;
          if FNumberOfButtons = 0
          then Width := FButtonPicture.Width
          else Width := FButtonPicture.Width div FNumberOfButtons;
          Invalidate;
     end;
end;

procedure TccGraphicButton.SetCurrentButton(Value : Integer);
begin
     if  (Value <> FCurrentButton) and (Value <= FNumberOfButtons)
     and (Value > 0) then
     begin
          FCurrentButton := Value;
          Invalidate;
     end;
end;

procedure TccGraphicButton.SetTransparent(Value : Boolean);
begin
     if Value <> FTransparent then
     begin
          FTransparent := Value;
          Invalidate;
     end;
end;

procedure TccGraphicButton.Paint;
var
   SrcRect,DestRect : TRect;
   TmpLeft, TmpRight : Integer;
begin
   if (FButtonPicture.Height > 0) and (Visible) then
      begin
      if (Transparent) and (FButtonMask.Height > 0) then
        begin
         TmpLeft  := ((FCurrentButton - 1) * Width);
         TmpRight := TmpLeft + Width;
         DestRect := Rect(0, 0, Width, Height);
         SrcRect := Rect(TmpLeft, 0, TmpRight, Height);
         Canvas.CopyMode := cmSrcAnd;
         Canvas.CopyRect(DestRect, ButtonMask.Canvas, SrcRect);
         Canvas.CopyMode := cmSrcPaint;
         Canvas.CopyRect(DestRect, ButtonPicture.Canvas, SrcRect);
        end
      else
        begin
         TmpLeft  := ((FCurrentButton - 1) * Width);
         TmpRight := TmpLeft + Width;
         SrcRect := Rect(TmpLeft, 0, TmpRight, Height);
         DestRect := Rect(0, 0, Width, Height);
         Canvas.CopyMode := cmSrcCopy;
         Canvas.CopyRect(DestRect, ButtonPicture.Canvas, SrcRect);
        end;
      end;

   if csDesigning in ComponentState then
      begin
           Canvas.Pen.Style := psDash;
           Canvas.Brush.Style := bsClear;
           Canvas.Rectangle(0, 0, Width, Height);
      end;
end;

{Set palettes properly - use Palette property if assigned,
 else use ButtonPicture property}
function TccGraphicButton.GetPalette: HPALETTE;
begin
  if Assigned(FPaletteBitmap) then
     Result := FPaletteBitmap.Palette
  else
    if Assigned(FButtonPicture) then
       Result := FButtonPicture.Palette
end;

procedure Register;
begin
  RegisterComponents('Samples', [TccGraphicButton]);
end;

end.
