unit Hltdemo;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, CDK_Comp, HltGrid, ExtCtrls;

type
	TCDKHighlightGridDemoForm = class(TForm)
		Panel1: TPanel;
		Panel2: TPanel;
		CDKHighlightGrid1: TCDKHighlightGrid;
		StyleComboBox: TComboBox;
		Label1: TLabel;
		Memo1: TMemo;
    Label2: TLabel;
		procedure CDKHighlightGrid1Click(Sender: TObject);
		procedure StyleComboBoxChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure CDKHighlightGrid1StyleRequest(Sender: TObject; styleID: Byte;
			selected: Boolean; var horizontalAlignment: TAlignment;
			var verticalAlignment: TVAlignment; aCanvas: TCanvas);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	CDKHighlightGridDemoForm: TCDKHighlightGridDemoForm;

implementation

{$R *.DFM}

Const
	STYLE_None = 0;
	STYLE_Header = 1;
	STYLE_PartNum = 2;
	STYLE_Description = 3;
	STYLE_Quantity = 4;
	STYLE_Price = 5;
	STYLE_Total = 6;

procedure TCDKHighlightGridDemoForm.CDKHighlightGrid1Click(Sender: TObject);
begin
	With CDKHighlightGrid1 Do
		StyleComboBox.ItemIndex := Styles[Col, Row];
end;

procedure TCDKHighlightGridDemoForm.StyleComboBoxChange(Sender: TObject);
var
	rowNdx,
	colNdx: LongInt;
begin
	With CDKHighlightGrid1 Do
		For rowNdx := Selection.Top to Selection.Bottom Do
			For colNdx := Selection.Left to Selection.Right Do
				Styles[colNdx, rowNdx] := StyleComboBox.ItemIndex;
end;

procedure TCDKHighlightGridDemoForm.FormCreate(Sender: TObject);
var
	rowNdx,
	colNdx: LongInt;
begin
	StyleComboBox.ItemIndex := 0;
	With CDKHighlightGrid1 Do		{ Fill cells with data. }
		Begin
			Cells[0, 0] := 'Part#';
			Cells[1, 0] := 'Description';
			Cells[2, 0] := 'Quantity';
			Cells[3, 0] := 'Price';
			Cells[4, 0] := 'Total';

			For colNdx := 0 to ColCount - 1 Do		{ Set the styles for each header cell. }
				Styles[colNdx, 0] := STYLE_Header;

			Cells[0, 1] := '4531';
			Cells[1, 1] := 'ACME Giant Slingshot';
			Cells[2, 1] := '1';
			Cells[3, 1] := '$149.00';
			Cells[4, 1] := '$149.00';

			Cells[0, 2] := '4378';
			Cells[1, 2] := 'ACME Catapult Kit';
			Cells[2, 2] := '2';
			Cells[3, 2] := '$49.00';
			Cells[4, 2] := '$98.00';

			Cells[0, 3] := '3419';
			Cells[1, 3] := 'ACME Rocket Skates (pair)';
			Cells[2, 3] := '1';
			Cells[3, 3] := '$89.00';
			Cells[4, 3] := '$89.00';

			Cells[0, 4] := '4378';
			Cells[1, 4] := 'ACME Giant Boulders';
			Cells[2, 4] := '3';
			Cells[3, 4] := '$79.00';
			Cells[4, 4] := '$237.00';

			Cells[0, 5] := '3419';
			Cells[1, 5] := 'ACME Parachutes (used)';
			Cells[2, 5] := '1';
			Cells[3, 5] := '$13.00';
			Cells[4, 5] := '$13.00';

			For colNdx := 0 to ColCount - 1 Do		{ Set the styles for the rest of the grid. }
				For rowNdx := 1 to 5 Do		{ Set the styles for each column. }
					Styles[colNdx, rowNdx] := colNdx + 2;
		End;
end;		{ FormCreate }

procedure TCDKHighlightGridDemoForm.CDKHighlightGrid1StyleRequest(Sender: TObject; 
					styleID: Byte; selected: Boolean;
					var horizontalAlignment: TAlignment; var verticalAlignment: TVAlignment;
					aCanvas: TCanvas);
	{ horizontalAlignment defaults to taLeftJustify. 
		verticalAlignment defaults to tavTop. 
		If selected is True then the cell is highlighted. }
begin
	With aCanvas Do
		Begin
			{ This is where you define your styles. 
				Note: They don't need to be hard coded like this. 
				You can give users complete control, or even change 
				styles at run-time. }
			Case styleID Of
				STYLE_Header:
					Begin
						horizontalAlignment := 	taCenter;
						verticalAlignment := tavCenter;		{ ...or tavTop or tavBottom. } 
						Font.Name := 'Arial';
						Font.Style := [fsBold];
						Font.Size := 16;
						If not selected Then
							Begin
								Font.Color := clNavy;
								Brush.Color := clBtnFace;
							End;
					End;
				STYLE_PartNum:
					Begin
						verticalAlignment := tavBottom;		{ ...or tavTop or tavCenter. } 
						horizontalAlignment := taRightJustify;
						Font.Name := 'Arial';
						Font.Style := [fsBold];
						Font.Size := 12;
						If not selected Then
							Font.Color := clMaroon;
					End;
				STYLE_Description:
					Begin
						Font.Name := 'Times New Roman';
						verticalAlignment := tavBottom;		{ ...or tavTop or tavCenter. } 
						Font.Style := [fsItalic];
						Font.Size := 10;
						If not selected Then
							Font.Color := clBlue;
					End;
				STYLE_Quantity:
					Begin
						horizontalAlignment := taCenter;
						verticalAlignment := tavBottom;		{ ...or tavTop or tavCenter. } 
						Font.Name := 'Arial';
						Font.Size := 12;
						If not selected Then
							Font.Color := clRed;
					End;
				STYLE_Price:
					Begin
						horizontalAlignment := taRightJustify;
						verticalAlignment := tavBottom;		{ ...or tavTop or tavCenter. } 
						Font.Name := 'Arial';
						Font.Size := 12;
						If not selected Then
							Begin
								Font.Color := clPurple;
								Brush.Color := clYellow;
							End;
					End;
				STYLE_Total:
					Begin
						horizontalAlignment := taRightJustify;
						verticalAlignment := tavBottom;		{ ...or tavTop or tavCenter. } 
						Font.Name := 'Arial';
						Font.Size := 12;
						Font.Style := [fsBold];
						If not selected Then
							Begin
								Font.Color := clGreen;
								Brush.Color := clLime;
							End;
					End;
			End;		{ case }
		End;
end;

end.
 