unit David;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VBXCtrl, Hotmap, Pict, StdCtrls, ExtCtrls;

type
  TfmDavid = class(TForm)
    HotMap1: THotMap;
    BiPict1: TBiPict;
    RadioGroup1: TRadioGroup;
    Memo1: TMemo;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure HotMap1RegionMouseDown(Sender: TObject;
      var RegionNum: Single; var Button: Integer);
    procedure HotMap1RegionMouseUp(Sender: TObject; var RegionNum: Single;
      var Button: Integer);
    procedure Button1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmDavid: TfmDavid;

implementation

{$R *.DFM}

procedure TfmDavid.FormCreate(Sender: TObject);
	var DtFl: TVBString;
begin
	    Memo1.Text := 'This portion of the demo shows additional features of the HotMap VBX. ';
    	Memo1.Text := Memo1.Text + 'Click anywhere on the face of this kid. Pick the region with the mouse, ';
	    Memo1.Text := Memo1.Text + 'while button is pushed drag the mouse and release button on the different region. ';
    	Memo1.Text := Memo1.Text + 'Now look at ''Mouse Down Event'' and ''Mouse Up Event'' ListBoxes. ';
	    Memo1.Text := Memo1.Text + 'Resize the form.  HotMap supports true 256 colors stretch.';

        DtFl	:= 'DAVID.HMD';
        HotMap1.DataFile := DtFl;
		HotMap1.Action := 4;
{        DtFl	:= 'DAVID.BMP';
        HotMap1.BmpName := DtFl;
}
		Edit1.Text := IntToStr(HotMap1.NumOfRgns);
end;

procedure TfmDavid.FormShow(Sender: TObject);
begin
     	RadioGroup1.ItemIndex := 3;
        HotMap1.FillType := 3;
        HotMap1.MouseCursor := BiPict1.Picture;
        HotMap1.MouseHotX := 0;
        HotMap1.MouseHotY := 11;
end;

procedure TfmDavid.HotMap1RegionMouseDown(Sender: TObject;
  var RegionNum: Single; var Button: Integer);
  var Rn:	Integer;
begin
    Rn := Round(RegionNum);

    if(Rn > 0) then
    begin
		ListBox1.Items.Add(HotMap1.RegionString[Rn - 1]);
	    Edit2.Text := IntToStr(Rn);
    	Edit3.Text := HotMap1.RegionString[Rn - 1];
    end;
end;

procedure TfmDavid.HotMap1RegionMouseUp(Sender: TObject;
  var RegionNum: Single; var Button: Integer);
  var Rn:	Integer;
begin
    Rn := Round(RegionNum);
    if(Rn > 0) then
		ListBox2.Items.Add(HotMap1.RegionString[Rn - 1]);
end;

procedure TfmDavid.Button1Click(Sender: TObject);
begin
	ListBox1.Clear;
	ListBox2.Clear;
end;

procedure TfmDavid.RadioGroup1Click(Sender: TObject);
begin
	HotMap1.FillType := RadioGroup1.ItemIndex;
end;

end.
