unit Frusamap;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VBXCtrl, Hotmap, StdCtrls, ExtCtrls, ColorGrd, Pict;

type
  TUsaMap = class(TForm)
    HotMap1: THotMap;
    Memo1: TMemo;
    ComboBox1: TComboBox;
    ListBox1: TListBox;
    GroupBox1: TGroupBox;
    RgnColor: TColorGrid;
    Label3: TEdit;
    Label1: TEdit;
    Button1: TButton;
    Text2: TEdit;
    BiPict1: TBiPict;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    RadioGroup1: TRadioGroup;
    Edit1: TEdit;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Click(Sender: TObject);
    procedure HotMap1RegionMouseDown(Sender: TObject;
      var RegionNum: Single; var Button: Integer);
    procedure HotMap1RegionMouseOver(Sender: TObject;
      var RegionNum: Single);
    procedure Button1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RgnColorClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
     OffsetX: Integer;
     OffsetY: Integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  UsaMap: TUsaMap;

implementation

{$R *.DFM}

procedure TUsaMap.FormCreate(Sender: TObject);
	var 	DtFl: 	TVBString;
        	n:	Integer;
begin
    	Memo1.Text := 'Use USA map to learn about HotMap custom control. ';
	    Memo1.Text := Memo1.Text + 'Click anywhere on USA map. Choose a new Fill Style. ';
    	Memo1.Text := Memo1.Text + 'Select any state from ''Show State'' combobox. Try to resize the form. ';
	    Memo1.Text := Memo1.Text + 'Switch ''Color'' CheckBox and choose any color. ';
    	Memo1.Text := Memo1.Text + 'Switch ''Drag'' CheckBox and try to drag any region.';

        DtFl	:= 'USAMAP.HMD';
        HotMap1.DataFile := DtFl;
		HotMap1.Action := 4;
{        DtFl	:= 'USAMAP.BMP';
        HotMap1.BmpName := DtFl;
 }
		Edit1.Text := IntToStr(HotMap1.NumOfRgns);

    	For n := 0 To (HotMap1.NumOfRgns - 1) Do
         	ComboBox1.Items.Add(HotMap1.RegionString[n]);
end;

procedure TUsaMap.ComboBox1Click(Sender: TObject);
    var n:	Integer;
begin
    For n := 0 To (HotMap1.NumOfRgns - 1) Do
    begin
      If ComboBox1.Text = HotMap1.RegionString[n] Then
      begin
        HotMap1.CurrentRgn := (n + 1);
        HotMap1.Action := 1;
        Exit;
      end;
    end;
end;

procedure TUsaMap.HotMap1RegionMouseDown(Sender: TObject;
  var RegionNum: Single; var Button: Integer);
  var Rn:	Integer;
begin

    Rn := Round(RegionNum);
    Label3.Text := IntToStr(Rn);
    Case Rn of
        0:
            Label1.Text := '';
        else
            Label1.Text := HotMap1.RegionString[Rn - 1];
            ListBox1.Items.Add(HotMap1.RegionString[Rn - 1]);

            {If was clicked in CA then chang the cursor
            If HotMap1.RegionString(RegionNum - 1) = "CA" Then
                HotMap1.MouseCursor = Picture1;
            Else
                HotMap1.MouseCursor = Picture2;}
    end;

end;

procedure TUsaMap.HotMap1RegionMouseOver(Sender: TObject;
  var RegionNum: Single);
begin
    Text2.Text := HotMap1.RegionString[Round(RegionNum) - 1];
end;

procedure TUsaMap.Button1Click(Sender: TObject);
begin
	ListBox1.Clear
end;

procedure TUsaMap.RadioGroup1Click(Sender: TObject);
begin
	HotMap1.FillType := RadioGroup1.ItemIndex;
end;

procedure TUsaMap.CheckBox2Click(Sender: TObject);
begin
	HotMap1.DragAllowed := CheckBox2.Checked;
end;

procedure TUsaMap.CheckBox1Click(Sender: TObject);
begin
    HotMap1.ColorMode := CheckBox1.Checked;
    GroupBox1.Visible := CheckBox1.Checked;
end;

procedure TUsaMap.Button2Click(Sender: TObject);
	var n:	Integer;
begin
    For n := 0 To (HotMap1.NumOfRgns - 1) Do
        HotMap1.RegionColor[n] := RGB(Random(255), Random(255), Random(255));
{        HotMap1.RegionColor[n] := Random($FFFFFF + 1);
	HotMap1.RegionColor[n] := Color(Random(256);}

end;

procedure TUsaMap.RgnColorClick(Sender: TObject);
  var I, Code: Integer;
begin
  Val(Label3.Text, I, Code);
  if I > 0 then
  	HotMap1.RegionColor[I - 1]  := RgnColor.ForegroundColor;
end;

procedure TUsaMap.FormResize(Sender: TObject);
begin
    If self.WindowState <> wsMinimized Then
        {Do not let user to make to small picture, to avoid loosing scaling}
        If ((self.Width - OffsetX) > 50) And ((self.Height - OffsetY) > 50) Then
        begin
            HotMap1.Width := self.Width - OffsetX;
            HotMap1.Height := self.Height - OffsetY;
	end;
end;

procedure TUsaMap.FormShow(Sender: TObject);
begin
        HotMap1.FillType := 3;
     	RadioGroup1.ItemIndex := 3;
        HotMap1.MouseCursor := BiPict1.Picture;
        HotMap1.MouseHotX := 19;
        HotMap1.MouseHotY := 0;
	    OffsetX := (self.Width - HotMap1.Width);
    	OffsetY := (self.Height - HotMap1.Height);
end;

end.
