unit Demomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, ExtCtrls, Spin, IconCtls;

type
  TForm1 = class(TForm)
    OpenDialog: TOpenDialog;
    GroupBox3: TGroupBox;
    GroupBox2: TGroupBox;
    UseCaching: TCheckBox;
    UseAutoDisable: TCheckBox;
    edIconFile: TEdit;
    ProgManBtn: TButton;
    MorIconsBtn: TButton;
    BrowseBtn: TButton;
    lblNumIcons: TLabel;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    icbIcons: TIconComboBox;
    spDropCount: TSpinEdit;
    Label2: TLabel;
    ScrollBox1: TScrollBox;
    ilbIcons: TIconListBox;
    Label3: TLabel;
    spListWidth: TSpinEdit;
    Label4: TLabel;
    spListHeight: TSpinEdit;
    procedure Button1Click(Sender: TObject);
    procedure ProgManBtnClick(Sender: TObject);
    procedure MorIconsBtnClick(Sender: TObject);
    procedure BrowseBtnClick(Sender: TObject);
    procedure edIconFileChange(Sender: TObject);
    procedure UseCachingClick(Sender: TObject);
    procedure UseAutoDisableClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure spDropCountChange(Sender: TObject);
    procedure spListWidthChange(Sender: TObject);
    procedure spListHeightChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ProgManBtnClick(Sender: TObject);
var
  Buff: array[0..140] of char;
begin
  GetWindowsDirectory(Buff, SizeOf(Buff)-1);
  edIconFile.Text := StrPas(Buff)+'\PROGMAN.EXE';
end;

procedure TForm1.MorIconsBtnClick(Sender: TObject);
var
  Buff: array[0..140] of char;
begin
  GetWindowsDirectory(Buff, SizeOf(Buff)-1);
  edIconFile.Text := StrPas(Buff)+'\MORICONS.DLL';
end;

procedure TForm1.BrowseBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    edIconFile.Text := OpenDialog.FileName;
end;

procedure TForm1.edIconFileChange(Sender: TObject);
begin
  icbIcons.FileName := edIconFile.Text;
  ilbIcons.FileName := edIconFile.Text;
  if icbIcons.NumberOfIcons = -1 then begin
    lblNumIcons.Font.Color := clRed;
    lblNumIcons.Caption := 'Invalid File'
  end else begin
    lblNumIcons.Font.Color := clBtnFace;
    lblNumIcons.Caption := IntToStr(icbIcons.NumberOfIcons) + ' Icons';
  end;
end;

procedure TForm1.UseCachingClick(Sender: TObject);
begin
  icbIcons.EnableCaching := UseCaching.Checked;
  ilbIcons.EnableCaching := UseCaching.Checked;
end;

procedure TForm1.UseAutoDisableClick(Sender: TObject);
begin
  icbIcons.AutoDisable := UseAutoDisable.Checked;
  ilbIcons.AutoDisable := UseAutoDisable.Checked;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ProgManBtn.Click;
  { Anyone know how to embed CRs into hint text at design time???? }
  UseCaching.Hint := 'Turn caching off and load'#13 +
                     'a new file with many icons.'#13 +
                     'Notice the pause while it'#13 +
                     'loads all icons?';
  UseAutoDisable.Hint := 'While enabled, try typing a'#13 +
                         'filename in the edit control.'#13 +
                         'Notice the combo will enable'#13 +
                         'and disable itself according'#13 +
                         'to the existence of the file.';
  spDropCount.Hint  := 'Change the number of icons'#13 +
                       'that are displayed in the'#13 +
                       'ComboBox when "dropped down."';
end;

procedure TForm1.spDropCountChange(Sender: TObject);
begin
  icbIcons.DropDownCount := spDropCount.Value;
end;

procedure TForm1.spListWidthChange(Sender: TObject);
begin
  ilbIcons.XIcons := spListWidth.Value;
end;

procedure TForm1.spListHeightChange(Sender: TObject);
begin
  ilbIcons.YIcons := spListHeight.Value;
end;

end.
