#ifndef IMAGELIB_H
#define IMAGELIB_H

#if defined (JPG_DLL)
#  define _JPGCLASS _export
#else
#  define _JPGCLASS
#endif

#if defined __cplusplus
# define _C "C"
#else
# define _C
#endif

#include <windows.h>
#include <windowsx.h>

extern _C int _JPGCLASS _pascal readjpgfile(const char *filename, int resolution,
										 int scale, int dither, int password,
										 unsigned int * hddb, unsigned int * hpal,
										 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal writejpegfile(const char *filename, int quality,
												 int smooth, int password,
												 unsigned int hddb, unsigned int hpal,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal readgiffile(const char *filename, int resolution,
										  int dither, int password, unsigned int * hddb,
										  unsigned int * hpal, short (* pf)(int),
										  short errormode);

extern _C int _JPGCLASS _pascal readpcxfile(const char *filename, int resolution,
										  int dither, int password, unsigned int * hddb,
										  unsigned int * hpal, short (* pf)(int),
										  short errormode);

extern _C int _JPGCLASS _pascal fileinfo(const char *filename, char * filetype,
												  int *width, int *height, int *bitspixel,
												  int *planes, int *numcolors,
												  char * compression, short errormode);

extern _C int _JPGCLASS _pascal readjpgstream(void * inbuffer, long size,
					int resolution, int scale, int dither, int password,
					unsigned int * hddb, unsigned int * hpal, short (* pf)(int),
					short errormode);

extern _C int _JPGCLASS _pascal readpcxstream(void * inbuffer, long size,
                                    int resolution, int dither,
												int password, unsigned int * hddb,
												unsigned int * hpal, short (* pf)(int),
												short errormode);

extern _C int _JPGCLASS _pascal readgifstream(void * inbuffer, long size,
												int resolution, int dither,
												int password, unsigned int * hddb,
												unsigned int * hpal, short (* pf)(int),
												short errormode);

extern _C int _JPGCLASS _pascal writejpegstream(void * inbuffer, long * size,
												 int quality, int smooth, int password,
												 unsigned int hddb, unsigned int hpal,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal streaminfo(void * inbuffer, long size,  char * filetype,
													 int *width, int *height, int *bitspixel,
													 int *planes, int *numcolors,
													 char * compression, short errormode);


extern _C int _JPGCLASS _pascal readbmpstream(void * inbuffer, long size,
										  int resolution, int dither, int password,
										  unsigned int * hddb, unsigned int * hpal,
										  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal writebmpstream(void * inbuffer, long * size,
											  int resolution, int password, unsigned int hddb,
											  unsigned int hpal, short (* pf)(int),
											  short errormode);

extern _C int _JPGCLASS _pascal readbmpfile(const char * filename, int resolution,
													  int dither, int password,
													  unsigned int * hddb,
													  unsigned int * hpal, short (* pf)(int),
													  short errormode);

extern _C int _JPGCLASS _pascal writebmpfile(const char * filename, int resolution,
														int password, unsigned int hddb,
														unsigned int hpal, short (* pf)(int),
														short errormode);

extern _C int _JPGCLASS _pascal readpngfile(const char * filename,
													  int resolution, int dither,
													  int password, unsigned int * hddb,
													  unsigned int * hpal, short (* pf)(int),
													  short errormode);

extern _C int _JPGCLASS _pascal readpngstream(void * inbuffer, long size,
													  int resolution, int dither,
													  int password, unsigned int * hddb,
													  unsigned int * hpal, short (* pf)(int),
													  short errormode);

extern _C int _JPGCLASS _pascal writepngfile(const char *filename, int resolution,
												 int interlaced, int password,
												 unsigned int hddb, unsigned int hpal,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal writepngstream(void *inbuffer, long *size,
												 int resolution, int interlaced, int password,
												 unsigned int hddb, unsigned int hpal,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal writegiffile(const char *filename, int resolution,
												 int password,
												 unsigned int hddb, unsigned int hpal,
												 short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal writegifstream(void * inbuffer, long * size,
										  int resolution, int password,
										  unsigned int hddb, unsigned int hpal,
										  short (* pf)(int), short errormode);

extern _C int _JPGCLASS _pascal writepcxfile(const char * filename, int resolution,
														int password, unsigned int hddb,
														unsigned int hpal, short (* pf)(int),
														short errormode);

extern _C int _JPGCLASS _pascal writepcxstream(void * inbuffer, long * size,
											  int resolution, int password, unsigned int hddb,
											  unsigned int hpal, short (* pf)(int),
											  short errormode);

extern _C int _JPGCLASS _pascal ReduceDib(void * &, int, int, int ,
											short (*)(int));

extern _C int _JPGCLASS _pascal DibtoDdb(void *, unsigned int *, unsigned int *);

extern _C int _JPGCLASS _pascal DdbtoDib(unsigned int, unsigned int, int, int,
				                    void *&, short, short (*)(int));


#endif
