#include <owl\owlpch.h>
#pragma hdrstop
#include <owl\radiobut.h>
#include <owl\checkbox.h>
#include <owl\edit.h>
#include <owl\validate.h>
#include "viewdlg.h"

#include "imagevw.h"

TDecDialog::TDecDialog(TWindow* parent,
 DecTransfer* DecBuffer) : TDialog(parent, IDD_DECOPT)
{
  ResGrp = new TGroupBox(this, IDC_RESGRP);
  new TRadioButton(this, IDC_RES24, ResGrp);
  new TRadioButton(this, IDC_RES8, ResGrp);
  new TRadioButton(this, IDC_RES4, ResGrp);
  QGrp = new TGroupBox(this, IDC_OPTGRP);
  new TRadioButton(this, IDC_RADONE, QGrp);
  new TRadioButton(this, IDC_RADONED, QGrp);
  SclGrp = new TGroupBox(this, IDC_SCLGRP);
  new TRadioButton(this, IDC_RADSCL1, SclGrp);
  new TRadioButton(this, IDC_RADSCL2, SclGrp);
  new TRadioButton(this, IDC_RADSCL4, SclGrp);
  new TRadioButton(this, IDC_RADSCL8, SclGrp);
  SetTransferBuffer(DecBuffer);
}

TDecDialog::~TDecDialog()
{
 Destroy();
 delete SclGrp;
 delete QGrp;
 delete ResGrp;
}

TEncDialog::TEncDialog(TWindow* parent,
 EncTransfer* EncBuffer) : TDialog(parent, IDD_ENCOPT)
{
  ResGrp = new TGroupBox(this, IDC_RESBGRP);
  new TRadioButton(this, IDC_RESB24, ResGrp);
  new TRadioButton(this, IDC_RESB8, ResGrp);
  new TRadioButton(this, IDC_RESB4, ResGrp);
  SetTransferBuffer(EncBuffer);
}

TEncDialog::~TEncDialog()
{
 Destroy();
 delete ResGrp;
}

TComDialog::TComDialog(TWindow* parent,
 ComTransfer* ComBuffer) : TDialog(parent, IDD_COMOPT)
{
  TEdit* e;
  e = new TEdit(this, IDC_QUALITY, 4);
  e->SetValidator(new TRangeValidator(0, 100));
  e = new TEdit(this, IDC_SMOOTH, 4);
  e->SetValidator(new TRangeValidator(0, 100));
  SetTransferBuffer(ComBuffer);
  delete e;
}

TComDialog::~TComDialog()
{
 Destroy();
}

DEFINE_RESPONSE_TABLE1(TGaugeDialog, TDialog)
  EV_COMMAND(IDCANCEL, CmCancel),
END_RESPONSE_TABLE;


TGaugeDialog::TGaugeDialog(TWindow* parent)
				: TDialog(parent, IDD_STATUS)
{
  Gauge = new TGauge(this, "%d%%", IDC_GAUGE, 20, 20, 240, 34,
							TRUE, 2);
}

void TGaugeDialog::SetupWindow()
{
  TDialog::SetupWindow();
  Gauge->SetRange(0,100);
  Gauge->SetValue(0);
  Gauge->SetColor(TColor::LtRed);
  Cancel = 1;
}

TGaugeDialog::~TGaugeDialog()
{
 Destroy();
 delete Gauge;
}

short TGaugeDialog::SetValue(int i)
{
  Gauge->SetValue(i);
  GetApplication()->PumpWaitingMessages();
  return Cancel;
}

void TGaugeDialog::CmCancel()
{
  Cancel = 0;
}

TGauge2Dialog::TGauge2Dialog(TWindow* parent)
				: TDialog(parent, IDD_STATUS2)
{
  Gauge = new TGauge(this, "%d%%", IDC_GAUGE, 20, 20, 240, 34,
							TRUE, 2);
}

void TGauge2Dialog::SetupWindow()
{
  TDialog::SetupWindow();
  Gauge->SetRange(0,100);
  Gauge->SetValue(0);
  Gauge->SetColor(TColor::LtRed);
}

TGauge2Dialog::~TGauge2Dialog()
{
 Destroy();
 delete Gauge;
}

short TGauge2Dialog::SetValue(int i)
{
  Gauge->SetValue(i);
  GetApplication()->PumpWaitingMessages();
  return 1;
}

