{Part of Imagelib VCL/DLL Library.
Written by Jan Dekkers and Kevin Adams (c) 1995. If you are a non
registered client, you may use or alter this demo only for evaluation
purposes.

Uses ImageLib 3.0

Changed callback in version 2.21 to a function with cdecl.
using the C calling convention.

scrolling text images
Cut, Copy and Paste to/from the clipboard
Printing bitmaps}

unit Uscroll;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Spin, TMultiP;

type
  TScrollForm1 = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    SaveDialog1: TSaveDialog;
    BitBtn3: TBitBtn;
    OpenDialog1: TOpenDialog;
    MultiImage1: TPMultiImage;
    BitBtn5: TBitBtn;
    MultiImage2: TPMultiImage;
    BitBtn6: TBitBtn;
    MultiImage3: TPMultiImage;
    ScrollBar1: TScrollBar;
    BitBtn7: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    Procedure Trigger(Sender : TObject; Var Done : Boolean);
  public
    { Public declarations }
  end;

var
  ScrollForm1: TScrollForm1;

implementation

{$R *.DFM}

procedure TScrollForm1.BitBtn1Click(Sender: TObject);
begin
{load an image or message at MultiImage1 (Top one)}
  Opendialog1.Filename:='*.scm';
  if Opendialog1.execute then
    MultiImage1.ImageName:=Opendialog1.Filename;
end;

procedure TScrollForm1.BitBtn2Click(Sender: TObject);
var
  RunAfterCreate : Boolean;
begin
    {Create a new message using the message editor}
    {boolean indicating to run the message after creation}
    RunAfterCreate:=True;
    {CreateMessage takes a pathname as the initial path to save the message
    and a boolean to run it}
    {MultiImage1.CreateMessage('c:\',true);}
    MultiImage1.CreateMessage(ExtractFilePath(Application.Exename),RunAfterCreate);
end;

procedure TScrollForm1.BitBtn3Click(Sender: TObject);
begin
   {create a message on the fly at MultiImage1 (Top one)}
   {set Message text}
    MultiImage1.MsgText:='ImageLib 3.0  A great tool to create a superb application in no time.';
    {set Message font name;  Note you could do this also with a font dialog}
    MultiImage1.MsgFont.Name:='Arial';
   {set Message font size}
    MultiImage1.MsgFont.Size:=-40;
    {set Message font style}
    MultiImage1.MsgFont.Style:=[fsitalic, fsbold];
    {set Message font color}
    MultiImage1.MsgFont.Color:=clWhite;
    {set Message background. Note you could do this also with a color dialog}
    MultiImage1.MsgBkGrnd:=clNavy;
    {set Message speed from 1 is fast to 10 is slow}
    MultiImage1.MsgSpeed:=1;
    {inititiate new message}
    MultiImage1.NewMessage;
end;

procedure TScrollForm1.BitBtn4Click(Sender: TObject);
begin
{Save current message from  MultiImage1 to a file (Top one)}
 if SaveDialog1.Execute then
  MultiImage1.SaveCurrentMessage(SaveDialog1.FileName);
end;

procedure TScrollForm1.BitBtn5Click(Sender: TObject);
begin
  {FreeMsg disposes the picture (message}
  MultiImage1.FreeMsg;
end;

procedure TScrollForm1.FormCreate(Sender: TObject);
begin
   {create a message at creation at MultiImage2 (Bottom one)}
   {set Message text}
     MultiImage2.MsgText:='This form contains 3 TMultiImage Components and can display '+
    'Png, Cms, Scm, Jpeg, Gif, Pcx, Bmp, Wmf or Ico images. Check out the blob version called '+
    'TPDBMultImage or TPDBMultMedia to add all the above and AVI, MOV, MID, RMI and WAV '+
    'to a TBlobfield';
    {set Message font name;  Note you could do this also with a font dialog}
    MultiImage2.MsgFont.Name:='Arial';
   {set Message font size}
    MultiImage2.MsgFont.Size:=-19;
    {set Message font style}
    MultiImage2.MsgFont.Style:=[fsitalic, fsbold];
    {set Message font color}
    MultiImage2.MsgFont.Color:=clYellow;
    {set Message background. Note you could do this also with a color dialog}
    MultiImage2.MsgBkGrnd:=clBlack;
    {set Message speed from 1 is fast to 10 is slow}
    MultiImage2.MsgSpeed:=5;
    {inititiate new message}
    MultiImage2.NewMessage;


    BitBtn7Click(Sender);
    BitBtn3Click(Sender);

    {IMPORTANT}
    {This is the moving engine for all the messages. Since an applcation
    can have only one OnIdle Trigger, this trigger needs to be subdivided
    by all your moving and animated objects. In this particular case the
    function is called TRIGGER but you can name it as you want as long
    you have a procedure named the same.}
    Application.OnIdle:=Trigger;
end;

Procedure TScrollForm1.Trigger(Sender : TObject; Var Done : Boolean);
begin
   {This function is called when your app is idle. Subdivide the
    trigger event to your TMultiImage objects who may need one.
    If no Message is active it will not take up significant time}
    MultiImage3.Trigger;
    MultiImage2.Trigger;
    MultiImage1.Trigger;
end;

procedure TScrollForm1.BitBtn6Click(Sender: TObject);
begin
{load an image or message at MultiImage3 (Middle one)}
  Opendialog1.Filename:='*.cms';
  if Opendialog1.execute then
    MultiImage3.ImageName:=Opendialog1.Filename;
end;

procedure TScrollForm1.ScrollBar1Change(Sender: TObject);
begin
 {change the speed of the bottom message}
 MultiImage2.MsgSpeed:=ScrollBar1.Position;
end;


procedure TScrollForm1.BitBtn7Click(Sender: TObject);
begin
   {Create A credit message on the fly}
    MultiImage3.FreeMsg;
   {Clear Message text if any}
    MultiImage3.CreditBoxList.Clear;
   {Define Message text}
    MultiImage3.CreditBoxList.Add(' ImageLib');
    MultiImage3.CreditBoxList.Add(' Another fine product of');
    MultiImage3.CreditBoxList.Add(' SKYLINE TOOLS');
    MultiImage3.CreditBoxList.Add(' Programming : Kevin Adams');
    MultiImage3.CreditBoxList.Add(' Programming : Jan Dekkers');
    MultiImage3.CreditBoxList.Add(' Artwork & PR: Jillian Pinsker');

    {set Message font name;  Note you could do this also with a font dialog}
    MultiImage3.MsgFont.Name:='Arial';
   {set Message font size}
    MultiImage3.MsgFont.Size:=-18;
    {set Message font style}
    MultiImage3.MsgFont.Style:=[fsitalic, fsbold];
    {set Message font color}
    MultiImage3.MsgFont.Color:=clWhite;
    {set Message background. Note you could do this also with a color dialog}
    MultiImage3.MsgBkGrnd:=clNavy;
    {set Message speed from 1 is fast to 10 is slow}
    MultiImage3.MsgSpeed:=2;

    MultiImage3.NewCreditMessage;
end;

procedure TScrollForm1.FormDestroy(Sender: TObject);
begin
   Application.OnIdle:=Nil;
end;

end.
