unit Mainfrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Ipport, Winsock;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileExitItem: TMenuItem;
    StatusBar: TPanel;
    IPPort1: TIPPort;
    Memo1: TMemo;
    Panel1: TPanel;
    FName: TEdit;
    Btn1: TButton;
    Btn2: TButton;  { E&xit }
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure Btn1Click(Sender: TObject);
    procedure IPPort1DataAvailable(Socket: Word);
    procedure IPPort1SocketClose(Socket: Word);
    procedure IPPort1TimeOut(Socket: Word);
    procedure IPPort1SocketConnect(Socket: Word);
    procedure Btn2Click(Sender: TObject);
    procedure IPPort1DataReady(Socket: Word);
  end;

var
  MainForm: TMainForm;
  TSock, FSock: TSocket;
  Hostname, username:  string;
  DataBack : TMemoryStream;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  DataBack := TMemoryStream.Create;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.Caption := Application.Hint;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  DataBack.Free;
  Close;
end;

procedure TMainForm.Btn1Click(Sender: TObject);
var
    iPos : Integer;
begin
    if FName.Text <> '' Then
    begin
        iPos := Pos('@',FName.Text);
        if iPos > 0 Then
        begin
            Inc(iPos);
            Username := Copy(FName.Text, 1, iPos-2);
            HostName := Copy(FName.Text, iPos, Length(FName.Text));
            IPPort1.RemoteAddress := HostName;
            IPPort1.RemotePort := 'finger';
            FSock := IPPort1.OpenSocket;
            IPPort1.ConnectSocket(FSock);
            StatusBar.Caption := 'Connecting... (' + HostName +')';
            DataBack.Clear;
        end
        else
            MessageDlg('No Local Host names allowed' + #13#10 +
                'Format is name@host ', mtInformation, [mbOK], 0);
    end
    else
            MessageDlg('Please supply a person to finger' + #13#10 +
                'Format is person@host ', mtInformation, [mbOK], 0);
end;


procedure TMainForm.IPPort1DataAvailable(Socket: Word);
var
    Data: TStringList;
    TimeData: LongInt;
    hNetTime : LongInt;
    NetTime: TDateTime;
    DataIn: Integer;
    strDatetime : string;
    timeLow, timeHigh: word;
const
    BASETIME = 693596.0;
    fmtdatetime : string = 'dddddd tt';
    Null : word = $0000;
begin
    Data := TStringList.Create;
    if Socket = FSock then
    begin
        {stream Data to Memory until we disconnect}
        IPPort1.GetData(Socket, Data);
        DataBack.Write(Data.GetText^,StrLen(Data.GetText));
    end
    else
    begin
        {Get Raw Data for Network time}
        DataIn := IPPort1.GetDataRaw(Socket,@TimeData,sizeof(TimeData));
        hNetTime := ntohl(TimeData);
        timeHigh := HIWORD(hNetTime);
        timeLow := LOWORD(hNetTime);
        NetTime := ((timeHigh * 65536.0 ) + timeLow)/86400.0;
        NetTime := NetTime + BASETIME;
        Memo1.Clear;
        DateTimetoString(strDateTime,fmtdatetime,Now);
        Data.Add('System time is : ' + strDateTime);
        DateTimetoString(strDateTime,fmtdatetime,NetTime);
        Data.Add('The Network time is : ' + StrDateTime);
        DataBack.Clear;
        DataBack.write(Data.GetText^,StrLen(Data.GetText));
    end;
    Data.Free;
end;

procedure TMainForm.IPPort1SocketClose(Socket: Word);
const
    Null : word = $0000;
begin
    DataBack.Write(Null,2);
    Memo1.SetTextBuf(DataBack.Memory);
    StatusBar.Caption := 'Disconnected.';
    IPPort1.ShutSocket(Socket);
end;

procedure TMainForm.IPPort1TimeOut(Socket: Word);
begin
    StatusBar.Caption := 'Failed to Connect to ' + HostName;
    IPPort1.ShutSocket(Socket);
end;

procedure TMainForm.IPPort1SocketConnect(Socket: Word);
begin
    StatusBar.Caption := 'Connected to ' + HostName;
end;

procedure TMainForm.Btn2Click(Sender: TObject);
var
    iPos : Integer;
begin
    if FName.Text <> '' Then
    begin
        iPos := Pos('@',FName.Text);
        if iPos = 0 Then
        begin
            HostName :=  FName.Text;
            IPPort1.RemoteAddress := HostName;
            IPPort1.RemotePort := 'time';
            TSock := IPPort1.OpenSocket;
            IPPort1.ConnectSocket(TSock);
            StatusBar.Caption := 'Connecting... (' + HostName +')';
        end
        else
            MessageDlg('Invalid host name',mtError,[mbOK],0);

    end
    else
        messageDlg('Please supply a network time host',
                    mtInformation,[mbOK],0);

end;

procedure TMainForm.IPPort1DataReady(Socket: Word);
Var
    Data: TStringList;
begin
    if Socket = FSock Then
    begin
        Data := TStringList.Create;
        Data.Add(Username);
        IPPort1.SendData(Socket,Data);
        Data.Free;
    end;
end;

end.
