unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus,
  MDIEdit, clipbrd, printers, about;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    FileCloseItem: TMenuItem;
    FilePrintItem: TMenuItem;
    FilePrintSetupItem: TMenuItem;
    FileExitItem: TMenuItem;

    EditUndoItem: TMenuItem;
    EditCutItem: TMenuItem;
    EditCopyItem: TMenuItem;
    EditPasteItem: TMenuItem;
    EditClearItem: TMenuItem;
    EditSelectalIItem: TMenuItem;

    SearchMenu: TMenuItem;
    SearchFindItem: TMenuItem;
    SearchReplaceItem: TMenuItem;
    SearchSearchagainItem: TMenuItem;

    WindowTileItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowArrangeItem: TMenuItem;

    HelpContentsItem: TMenuItem;
    HelpSearchItem: TMenuItem;
    HelpHowToUseItem: TMenuItem;
    HelpAboutItem: TMenuItem;

    StatusLine: TPanel;
    OpenDialog: TOpenDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;

    SpeedBar: TPanel;
    SpeedButtonNew: TSpeedButton;
    SpeedButtonOpen: TSpeedButton;
    SpeedButtonSave: TSpeedButton;
    SpeedButtonSaveAs: TSpeedButton;
    SpeedButtonClose: TSpeedButton;
    SpeedButtonPrint: TSpeedButton;
    SpeedButtonPrintSetup: TSpeedButton;
    SpeedButtonExit: TSpeedButton;

    SpeedButtonupdo: TSpeedButton;
    SpeedButtonCut: TSpeedButton;
    SpeedButtonCopy: TSpeedButton;
    SpeedButtonPaste: TSpeedButton;

    SpeedButtonTile: TSpeedButton;
    SpeedButtonCascadel: TSpeedButton;
    SpeedButtonArrangel: TSpeedButton;
    SpeedButtonHelpContents: TSpeedButton;
    SpeedButtonTopicSearch: TSpeedButton;
    SpeedButtonHowtouseHelp: TSpeedButton;
    SpeedButtonAbout: TSpeedButton;


    procedure FormCreate(Sender: TObject);

    procedure FileNew(Sender: TObject);
    procedure FileOpen(Sender: TObject);
    procedure FileSave(Sender: TObject);
    procedure FileSaveAs(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FilePrint(Sender: TObject);
    procedure FilePrintSetup(Sender: TObject);
    procedure FileExit(Sender: TObject);

    procedure EditUndo(Sender: TObject);
    procedure EditCut(Sender: TObject);
    procedure EditCopy(Sender: TObject);
    procedure EditPaste(Sender: TObject);
    procedure EditClearItemClick(Sender: TObject);
    procedure EditSelectalIItemClick(Sender: TObject);

    procedure Find(Sender: TObject);
    procedure SearchFindItemClick(Sender: TObject);
    procedure SearchSearchagainItemClick(Sender: TObject);
    procedure Replace(Sender: TObject);
    procedure SearchReplaceItemClick(Sender: TObject);

    procedure WindowTile(Sender: TObject);
    procedure WindowCascade(Sender: TObject);
    procedure WindowArrange(Sender: TObject);

    procedure HelpContents(Sender: TObject);
    procedure HelpSearch(Sender: TObject);
    procedure HelpHowToUse(Sender: TObject);
    procedure HelpAbout(Sender: TObject);


    procedure UpdateMenuItems(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIEditChild(const Name: string);
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.Caption := Application.Hint;
end;

procedure TMainForm.CreateMDIEditChild(const Name: string);
var
  FrmEdit: TFrmEdit;
begin
  { create a new MDI Edit child window }
  FrmEdit := TFrmEdit.Create(Application);
  FrmEdit.Caption := Name;
end;

procedure TMainForm.FileNew(Sender: TObject);
begin
  CreateMDIEditChild('Untitle' + IntToStr(MDIChildCount + 1));
end;

procedure TMainForm.FileOpen(Sender: TObject);
var
   I:integer;
begin
  if OpenDialog.Execute then
     begin
     if ofAllowMultiSelect in OpenDialog.Options then
        begin
        for I:=0 to OpenDialog.Files.count-1 do
            begin
            CreateMDIEditChild(OpenDialog.Files[i]);
            TFrmEdit(ActiveMDIChild).Open(OpenDialog.Files[i]);
            end;
        end
     else
        begin
        CreateMDIEditChild(OpenDialog.FileName);
        TFrmEdit(ActiveMDIChild).Open(OpenDialog.FileName);
        end
    end;
end;

procedure TMainForm.FileSave(Sender: TObject);
begin
   { Add code to save current file under current name }
    TFrmEdit(ActiveMDIChild).Save(Sender);
end;

procedure TMainForm.FileSaveAs(Sender: TObject);
begin
    TFrmEdit(ActiveMDIChild).SaveAs(Sender);
end;

procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
     ActiveMDIChild.Close;
end;

procedure TMainForm.FilePrint(Sender: TObject);
begin
    TFrmEdit(ActiveMDIChild).print(Sender);
end;

procedure TMainForm.FilePrintSetup(Sender: TObject);
begin
  {PrintSetupDialog.Execute;}
  PrinterSetupDialog1.Execute;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.EditUndo(Sender: TObject);
begin
  { Add code to perform Edit Undo }
  MessageDlg('No implement yet',mtInformation,[mbOK],0);
end;

procedure TMainForm.EditCut(Sender: TObject);
begin
    TFrmEdit(ActiveMDIChild).CutToClipboard(Sender);
end;

procedure TMainForm.EditCopy(Sender: TObject);
begin
     TFrmEdit(ActiveMDIChild).CopyToClipboard(Sender);
end;

procedure TMainForm.EditPaste(Sender: TObject);
begin
     TFrmEdit(ActiveMDIChild).PasteFromClipboard(Sender);
end;

procedure TMainForm.EditClearItemClick(Sender: TObject);
begin
     TFrmEdit(ActiveMDIChild).clear(Sender);
end;

procedure TMainForm.EditSelectalIItemClick(Sender: TObject);
begin
     TFrmEdit(ActiveMDIChild).SelectAll(Sender);
end;

procedure TMainForm.Find(Sender: TObject);
begin
   if ActiveMDIChild is TFrmEdit then
       TFrmEdit(ActiveMDIChild).Find(Sender);
end;

procedure TMainForm.SearchFindItemClick(Sender: TObject);
begin
    FindDialog1.Execute;
end;

procedure TMainForm.SearchSearchagainItemClick(Sender: TObject);
begin
   if ActiveMDIChild is TFrmEdit then
     TFrmEdit(ActiveMDIChild).Find(FindDialog1);
end;

procedure TMainForm.Replace(Sender: TObject);
begin
   if ActiveMDIChild is TFrmEdit then
       TFrmEdit(ActiveMDIChild).replace(ReplaceDialog1);
end;

procedure TMainForm.SearchReplaceItemClick(Sender: TObject);
begin
     ReplaceDialog1.Execute;
end;

procedure TMainForm.WindowTile(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowCascade(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowArrange(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.HelpContents(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.HelpSearch(Sender: TObject);
const
  EmptyString: PChar = '';
begin
  Application.HelpCommand(HELP_PARTIALKEY, Longint(EmptyString));
end;

procedure TMainForm.HelpHowToUse(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TMainForm.HelpAbout(Sender: TObject);
begin
  { Add code to show program's About Box }
  AboutBox.showmodal;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
var
   bEditChildWindow:boolean;
   bOther:boolean;
   HasSelection: Boolean;
   EnableSave: boolean;
begin
   bEditChildWindow:=  (MDIChildCount > 0 ) AND (ActiveMDIChild Is TFrmEdit);

   if bEditChildWindow then
      bOther:= TFrmEdit(ActiveMDIChild).MemoText.modified;
   FileSaveItem.Enabled := bEditChildWindow AND bOther;
   FileSaveAsItem.Enabled := bEditChildWindow;
   FileCloseItem.Enabled := MDIChildCount > 0;

   FilePrintItem.Enabled := MDIChildCount > 0;
   {
   try
      FilePrintSetupItem.Enabled := Printer.handle<>0;
   except
      FilePrintSetupItem.Enabled := false;
   end;
   }
   if bEditChildWindow then
      HasSelection := TFrmEdit(ActiveMDIChild).MemoText.SelLength <> 0;
   EditUndoItem.Enabled := bEditChildWindow ; {AND can undo}
   EditCutItem.Enabled := bEditChildWindow AND HasSelection;
   EditCopyItem.Enabled := bEditChildWindow AND HasSelection;
   EditPasteItem.Enabled := bEditChildWindow AND Clipboard.HasFormat(CF_TEXT);
   EditClearItem.Enabled := bEditChildWindow AND HasSelection;
   EditSelectalIItem.Enabled := bEditChildWindow ;

   SearchFindItem.Enabled := bEditChildWindow ;
   SearchReplaceItem.Enabled := bEditChildWindow ;
   SearchSearchagainItem.Enabled := bEditChildWindow ;

   WindowCascadeItem.Enabled := MDIChildCount > 0;
   WindowTileItem.Enabled := MDIChildCount > 0;
   WindowArrangeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
     HelpAbout(Sender);
end;

end.
