unit MDIEdit;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Printers,
  Dialogs, Menus, Clipbrd, StdCtrls, Search, Magmaed;

type
  TFrmEdit = class(TForm)
    FontDialog1: TFontDialog;
    SaveDialog1: TSaveDialog;
    PrintDialog1: TPrintDialog;
    PopupMenu1: TPopupMenu;
    EditCutItem: TMenuItem;
    EditCopyItem: TMenuItem;
    EditPasteItem: TMenuItem;
    EditClearItem: TMenuItem;
    MemoText: TMagmaEdit;
    N1: TMenuItem;
    ChangeFont1: TMenuItem;

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);

    procedure CutToClipboard(Sender: TObject);
    procedure CopyToClipboard(Sender: TObject);
    procedure PasteFromClipboard(Sender: TObject);
    procedure Clear(Sender: TObject);
    procedure SelectAll(Sender: TObject);

    procedure Open(const AFilename: string);
    procedure Print(Sender: TObject);
    procedure Save(Sender: TObject);
    procedure SaveAs(Sender: TObject);

    procedure Find(Sender: TObject);
    procedure Replace(Sender: TObject);
    procedure EditCutItemClick(Sender: TObject);
    procedure EditCopyItemClick(Sender: TObject);
    procedure EditPasteItemClick(Sender: TObject);
    procedure EditClearItemClick(Sender: TObject);

    procedure SetPopUpItems(Sender: TObject);
    procedure ChangeFont1Click(Sender: TObject);
    procedure MemoTextDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState; var Handled: Longint;
      itemData: Longint; lpText: PChar; lineNumber: Longint; colLeft,
      idxLeft: Word; pixLeft: Integer);

  private
    Filename: string;
 public
    function GetFileName:string;
    procedure SaveToFile(FileName:string);
    function SaveFile:boolean;
    function SaveFileAs:boolean;
  end;

implementation

{$R *.DFM}
uses  SysUtils, Messages;

const
  BackupExt = '.BAK';
  SWarningText = 'Save Changes to ''%s''?';
  DefaultCaption = 'Untitled';

procedure TFrmEdit.CutToClipboard(Sender: TObject);
begin
  MemoText.CutToClipboard;
end;

procedure TFrmEdit.CopyToClipboard(Sender: TObject);
begin
  MemoText.CopyToClipboard;
end;

procedure TFrmEdit.PasteFromClipboard(Sender: TObject);
begin
  MemoText.PasteFromClipboard;
end;

procedure TFrmEdit.Clear(Sender: TObject);
begin
  MemoText.ClearSelection;
end;

procedure TFrmEdit.SelectAll(Sender: TObject);
begin
  MemoText.SelectAll;
end;

procedure TFrmEdit.Open(const AFilename: string);
{$ifdef OWNREAD}
Var
   File_Handle: TextFile;
   buf:String;
{$endif}
begin
  Filename := AFilename;
  if FileExists(Filename) then
     begin
          MemoText.LoadFromFile(FileName);
       MemoText.SelStart := 0;
     end;
  Caption := ExtractFileName(FileName);
  MemoText.Modified := False;
end;

{ the printing performed in this example either prints the entire buffer,   }
{ or...if a section of text is selected, will print the selected text;      }
{ in addition, the first line of selected text will be printed left         }
{ justified; no attempt is made to make the lines appear as they do on the  }
{ monitor.  WYSIWYG printing is beyond the scope of this demo program.      }
{ The following features of printing are not demonstrated:                  }
{     Multiple Copies                                                       }
{     Collating Multiple Copies                                             }
{     Page Ranges                                                           }
{     Multiple Fonts, Word Wrapping, etc.                                   }

procedure TFrmEdit.Print(Sender: TObject);
var
  Line: Integer;
  PrintText: System.Text;
begin
  if PrintDialog1.Execute then
  begin
    AssignPrn(PrintText);
    Rewrite(PrintText);
    Printer.Canvas.Font := MemoText.Font;
    for Line := 0 to MemoText.Lines.Count - 1 do
      Writeln(PrintText, MemoText.Lines[Line]);
    System.Close(PrintText);
  end;
end;

function TFrmEdit.SaveFile:boolean;
   procedure CreateBackup(const Filename: string);
    var
       BackupFilename: string;
  begin
    BackupFilename := ChangeFileExt(Filename, BackupExt);
    DeleteFile(BackupFilename);
    RenameFile(Filename, BackupFilename);
  end;

  function IsReadOnly(const Filename: string): Boolean;
  begin
    Result := Boolean(FileGetAttr(Filename) and faReadOnly);
    if Result then MessageDlg(Format('%s is read only.',
      [ExtractFilename(Filename)]), mtWarning, [mbOK], 0);
  end;

begin
  if (Filename = '') or IsReadOnly(Filename) then
    result:=SaveFileAs
  else
    begin
    result:=true;
    CreateBackup(Filename);
    MemoText.Lines.SaveToFile(Filename);
    MemoText.Modified := False;
    end;
end;


function TFrmEdit.SaveFileAs:boolean;
begin
  result:=false;
  SaveDialog1.Filename := Filename;
  if SaveDialog1.Execute then
  begin
    Filename := SaveDialog1.Filename;
    Caption := ExtractFileName(Filename);
    SaveFile;
    result:=true;
  end;
end;

procedure TFrmEdit.Save(Sender: TObject);
begin
     SaveFile;
end;

procedure TFrmEdit.SaveAs(Sender: TObject);
begin
     SaveFileAs;
end;

procedure TFrmEdit.Find(Sender: TObject);
begin
  with Sender as TFindDialog do
    if not SearchMemo(MemoText, FindText, Options) then
      ShowMessage('Cannot find "' + FindText + '".');
end;


{ Replace and ReplaceAll call this routine. }
procedure TFrmEdit.Replace(Sender: TObject);
var
  Found: Boolean;
begin
  with Sender as TReplaceDialog do
  begin
    if AnsiCompareText(MemoText.SelText, FindText) = 0 then
      MemoText.SelText := ReplaceText;
    Found := SearchMemo(MemoText, FindText, Options);
    while Found and (frReplaceAll in Options) do
    begin
      MemoText.SelText := ReplaceText;
      Found := SearchMemo(MemoText, FindText, Options);
    end;
    if (not Found) and (frReplace in Options) then
      ShowMessage('Cannot find "' + FindText + '".');
  end;
end;


procedure TFrmEdit.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  DialogValue: Integer;
  FName: string;
begin
  CanClose:=true;
  if MemoText.Modified then
  begin
    FName := Caption;
    DialogValue := MessageDlg(Format(SWarningText, [FName]), mtConfirmation,
      [mbYes, mbNo, mbCancel], 0);
    case DialogValue of
      id_Yes: CanClose:=SaveFile;
      id_Cancel: CanClose := False;
    end;
  end;
end;


procedure TFrmEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmEdit.SetPopUpItems(Sender: TObject);
var
  HasSelection: Boolean;
begin
  EditPasteItem.Enabled := Clipboard.HasFormat(CF_TEXT);
  HasSelection := MemoText.SelLength <> 0;
  EditCutItem.Enabled := HasSelection;
  EditCopyItem.Enabled := HasSelection;
  EditClearItem.Enabled := HasSelection;
end;

procedure TFrmEdit.EditCutItemClick(Sender: TObject);
begin
    CutToClipboard(Sender);
end;

procedure TFrmEdit.EditCopyItemClick(Sender: TObject);
begin
    CopyToClipboard(Sender);

end;

procedure TFrmEdit.EditPasteItemClick(Sender: TObject);
begin
    PasteFromClipboard(Sender);
end;

procedure TFrmEdit.EditClearItemClick(Sender: TObject);
begin
    Clear(Sender);
end;

function TFrmEdit.GetFileName:string;
begin
    result:=Filename;
end;

procedure TFrmEdit.SaveToFile(FileName:string);
begin
    MemoText.Lines.SaveToFile(Filename);
end;

procedure TFrmEdit.ChangeFont1Click(Sender: TObject);
begin
    with MemoText do
         begin
        FontDialog1:=TFontDialog.create(self);
        if lines.objects[LineIndex+1]<>nil then
           FontDialog1.Font :=TFont(lines.Objects[LineIndex+1]);
        if FontDialog1.Execute then
           begin
           lines.objects[LineIndex+1]:=FontDialog1.Font;
           invalidate;
           end;
        end;

end;

procedure TFrmEdit.MemoTextDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState; var Handled: Longint;
  itemData: Longint; lpText: PChar; lineNumber: Longint; colLeft,
  idxLeft: Word; pixLeft: Integer);
begin
     with MemoText do
          begin
          if lines.objects[lineNumber]<>nil then
             begin
             Canvas.Font:=   TFont(lines.Objects[lineNumber]);
                 Canvas.TextOut(Rect.Left, Rect.Top, strpas(lpText));
                 handled:=1;
            end;
          end;
end;

end.


