{
   This is a very basic component to demonstrate how you can
   quickly create "live-at-design time" components in Delphi 
   with a very small code.

   I've wrote this component purely for educational purposes.
   That's why it may not be the best implementation, but I beleive
   it might be usefull for those who are new to Delphi's "Component
   Heaven".

   Please, feel free to copy/distribute/modify this code as you like.
   But, don't blame me if it cause the third world war.

   I'll be more than happy to hear from you for your comments,
   improvements, a real-life use of this component.

   Due to enermous mail traffic I have, please send your comments
   to Ali@CCLRU.UNSW.EDU.AU with subject field starting with
   the word 'Component Paradise'.

   Example:
      To      : Ali@CCLRU.UNSW.EDU.AU
      Subject : Component Paradise .. New properties on MovingBall
                ^^^^^^^^^^^^^^^^^^^
                This help me to filter your comments.

   All the best...

   Ali H. GOKTOGAN

   --------------------------------------------------------------
   "Bilgi paylasildiginda degerlidir.."
   "Knowledge has a value when you share it with others."
                                            A Turkish proverb

   "You never lose when you give...
    You never lose when you share..."
                        A Turkish proverb
   --------------------------------------------------------------
}

unit Mvball;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TMovingBall = class(TGraphicControl)
  private
    { Private declarations }
    fTimer     : TTimer;
    fHorStep,
    fVerStep   : integer;
    fContinuous: boolean;
  protected
    { Protected declarations }
    procedure SetContinuous(Value : boolean);
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; Override;
    procedure   MoveBall(Sender: TObject);
  published
    { Published declarations }
    property Continuous : boolean read fContinuous write SetContinuous default True;
  end;

procedure Register;

implementation

constructor TMovingBall.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Left   := 100; { Initial location and size }
  Top    := 100;
  Height := 20;
  Width  := 20;
  fHorStep := 1+random(10);
  fVerStep := 1+random(10);
  fContinuous  := False;
  SetContinuous(True);
  {...}
end;

destructor TMovingBall.Destroy;
begin
  {...}
  if fContinuous then fTimer.Free;
  inherited Destroy;
end;

procedure TMovingBall.MoveBall(Sender: TObject);
begin
  {================ Horizontal movement ==============}
   if fHorStep < 0 then
      if (Left-fHorStep > 0) then
         SetBounds(Left+fHorStep, Top, Width, Height)
      else fHorStep := (1+random(10))
   else
      if (Left+Width+fHorStep <= Parent.ClientWidth) then
         SetBounds(Left+fHorStep, Top, Width, Height)
      else fHorStep   := -(1+random(10));

  {================ Vertical movement ==============}
   if fVerStep < 0 then
      if (Top-fVerStep > 0) then
         SetBounds(Left, Top+fVerStep, Width, Height)
      else fVerStep := (1+random(10))
   else
      if (Top+Height+fVerStep <= Parent.ClientHeight) then
         SetBounds(Left, Top+fVerStep, Width, Height)
      else fVerStep   := -(1+random(10));
end;

procedure TMovingBall.SetContinuous(Value : boolean);
begin
  if fContinuous=Value then exit;
  fContinuous := Value;
  if fContinuous then begin
     fTimer := TTimer.Create(Self);
     fTimer.Interval := 10;
     fTimer.OnTimer  := MoveBall;
     fTimer.Enabled  := True;
  end else
     fTimer.Free;
end;{}

procedure TMovingBall.Paint;
begin
  with Canvas do begin
    Pen.Color   := clRed;
    Brush.Style := bsClear;
    Ellipse(0,0,Width,Height);
  end;
end;{}

procedure Register;
begin
  RegisterComponents('Ali', [TMovingBall]);
end;

end.
