unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Dbnetcon, StdCtrls, DB, DBTables, Grids, DBGrids, Buttons,
  Spin, ExtCtrls;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    DBGrid1: TDBGrid;
    Table1NAME: TStringField;
    Table1AREA: TStringField;
    DataSource2: TDataSource;
    Table2: TTable;
    DBGrid2: TDBGrid;
    Table2Category: TStringField;
    Table2Common_Name: TStringField;
    DataSource3: TDataSource;
    Table3: TTable;
    DBGrid3: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    DBNetConnectChild1: TDBNetConnectChild;
    DBNetConnectChild2: TDBNetConnectChild;
    DBNetConnectChild3: TDBNetConnectChild;
    DBNetConnect1: TDBNetConnect;
    SpeedButton1: TSpeedButton;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Image1: TImage;
    GroupBox2: TGroupBox;
    Label9: TLabel;
    SpinEdit1: TSpinEdit;
    Label10: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label11: TLabel;
    Table3EmpNo: TIntegerField;
    Table3LastName: TStringField;
    Table3FirstName: TStringField;
    Table3PhoneExt: TStringField;
    Table3HireDate: TDateTimeField;
    Table3Salary: TFloatField;
    procedure SpeedButton1Click(Sender: TObject);
    procedure DBNetConnectChild3Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure DBNetConnectChild1Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure DBNetConnectChild2Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure DBNetConnect1ScanTimer(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure Table1AfterPost(DataSet: TDataset);
    procedure Table2AfterPost(DataSet: TDataset);
    procedure Table3AfterPost(DataSet: TDataset);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  {Activate the Main-Component}
  DBNetConnect1.Active := TSpeedButton(sender).Down;
end;

procedure TForm1.DBNetConnectChild1Update(Sender: TObject;
  Channel: Longint; Stamp: TDateTime);
begin
  {If the Main Component Request an Updatesignal
   then it's send a Broadcast to his Child's.
   The Child Filter the Channel-Number and call the Update Property-Event}
  Table1.Refresh;
  Label6.Caption := Format('%s %s',['Channel 1:',DateTimeToStr(Stamp)]);
end;

procedure TForm1.DBNetConnectChild2Update(Sender: TObject;
  Channel: Longint; Stamp: TDateTime);
begin
  Table2.Refresh;
  Label7.Caption := Format('%s %s',['Channel 2:',DateTimeToStr(Stamp)]);
end;

procedure TForm1.DBNetConnectChild3Update(Sender: TObject;
  Channel: Longint; Stamp: TDateTime);
begin
  Table3.Refresh;
  Label8.Caption := Format('%s %s',['Channel 3:',DateTimeToStr(Stamp)]);
end;

procedure TForm1.DBNetConnect1ScanTimer(Sender: TObject);
begin
  {if the MainComponent Active then it calls these Event for
   evtl. Synchronise with the Application}
  Label5.Caption := IntToStr(StrToInt(Label5.Caption) + 1);
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  {Setting the ScanInterval. Disabling ist not needed}
  DBNetConnect1.ScanInterval := Spinedit1.Value * 1000;
end;

procedure TForm1.Table1AfterPost(DataSet: TDataset);
begin
  {Call all Netuser's a Table has changed}
  DBNetConnectChild1.SendChange;
end;

procedure TForm1.Table2AfterPost(DataSet: TDataset);
begin
  DBNetConnectChild2.SendChange;
end;

procedure TForm1.Table3AfterPost(DataSet: TDataset);
begin
  DBNetConnectChild3.SendChange;
end;



end.
