unit Novtest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Novtli, About;

type
  TForm1 = class(TForm)
    NovTLI1: TNovTLI;
    Connect: TButton;
    SendData: TButton;
    Listen: TButton;
    Close: TButton;
    Disconnect: TButton;
    CancelListen: TButton;
    AddrOptions: TGroupBox;
    UseServerName: TRadioButton;
    UsePhysicalAddr: TRadioButton;
    Port: TEdit;
    Label2: TLabel;
    Edit1: TEdit;
    Memo1: TMemo;
    NetNode: TGroupBox;
    AddrNet: TEdit;
    AddrNode: TEdit;
    LabelNet: TLabel;
    LabelNode: TLabel;
    Label5: TLabel;
    GroupBox1: TGroupBox;
    ServerName: TEdit;
    LabelServerName: TLabel;
    HelpButton: TButton;
    procedure ConnectClick(Sender: TObject);
    procedure NovTLI1SessionConnected(Sender: TObject; Socket: Integer);
    procedure NovTLI1DataAvailable(Sender: TObject; Socket: Integer);
    procedure FormCreate(Sender: TObject);
    procedure SendDataClick(Sender: TObject);
    procedure ListenClick(Sender: TObject);
    procedure CloseClick(Sender: TObject);
    procedure DisconnectClick(Sender: TObject);
    procedure CancelListenClick(Sender: TObject);
    procedure NovTLI1SessionAvailable(Sender: TObject; Socket: Integer);
    procedure NovTLI1SessionClosed(Sender: TObject; Socket: Integer);
    procedure UseServerNameClick(Sender: TObject);
    procedure UsePhysicalAddrClick(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  clientserver: integer;

implementation

{$R *.DFM}

procedure TForm1.ConnectClick(Sender: TObject);
var
  szMsg: array[0..255] of char;
begin
  Listen.Enabled := False;
  If UseServerName.Checked = True Then
    NovTLI1.ServerName := ServerName.Text
  else
  begin
    if AddrNode.Text = '0080C72E12D4' then
    begin
      StrPCopy(szMsg,'This is the MAC address of the authors'#13#10);
      StrCat(szMsg,' ethernet adapter. You should obtain you''re physical'#13#10);
      StrCat(szMsg,' address with the userlist /a netware command, or'#13#10);
      StrCat(szMsg,'from the display when the driver is loaded at boot time');
      if Application.MessageBox(szMsg,'ERROR',MB_OKCANCEL) = IDCANCEL then
        exit;
    end;
    NovTLI1.Addr := AddrNet.Text + '/' + AddrNode.Text;
    NovTLI1.Port := StrToInt(Port.Text);
  end;
  NovTLI1.Connect;
  clientserver := 1;
  Connect.Enabled := False;
end;

procedure TForm1.NovTLI1SessionConnected(Sender: TObject; Socket: Integer);
begin
  Connect.Enabled := False;
  SendData.Enabled := True;
  Listen.Enabled := False;
  Close.Enabled := True;
  Disconnect.Enabled := True;
  CancelListen.Enabled := False;
end;

procedure TForm1.NovTLI1DataAvailable(Sender: TObject; Socket: Integer);
var
  Buf: string;
begin
  Memo1.Lines.Add('Data recevied from socket(' + IntToStr(Socket) + ')');
  buf := NovTLI1.Text;
  Memo1.Lines.Add('-->' + buf + '<--');
  If clientserver = 2 Then
  begin
    NovTLI1.Text := buf;
    Memo1.Lines.Add('...Buffer echoed back to client');
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Port.Hint := 'Client: Enter the port number to connect to'#13#10'Server: Enter the  port number to listen on';
Port.Text := IntToStr(NovTLI1.Port);
ServerName.Hint := 'Client: Server name to connect to'#13#10 +
  'Server: Name of the listening server'#13#10'(Used only when ''Use ServerName'' is checked)'#13#10 +
  'You must be connected to a Netware network that supports'#13#10 +
  'the Service Advertising Protocol (SAP) to use this feature';
UseServerName.Hint := 'Use the ServerName instead of the physical addressing mechanisms'#13#10 +
  '(You must be connected to a NetWare network that supports'#13#10 +
  ' The Service Advertising Protocol (SAP) to use this option';
AddrNode.Hint := 'Enter the 12 digit hexadecimal node number (MAC Address)'#13#10 +
  'of you''re network card';
AddrNet.Hint := 'Enter the 8 digit hexadecimal network number'#13#10 +
  'You can obtain the Net and Node numbers by issuing the'#13#10 +
  'Netware command ''userlist /a''';
If NovTLI1.Port = 0 Then
  Port.Text := '31';
If NovTLI1.Addr = '' Then
begin
  AddrNet.Text := '00000000';
  AddrNode.Text := '0080C72E12D4';
end;
Connect.Enabled := True;
SendData.Enabled := False;
Listen.Enabled := True;
Close.Enabled := False;
Disconnect.Enabled := False;
CancelListen.Enabled := False;
clientserver := 0;
UseServerName.Checked := True;
ServerName.Text := 'MYServer';
end;

procedure TForm1.SendDataClick(Sender: TObject);
begin
  NovTLI1.Text := Edit1.Text;
end;

procedure TForm1.ListenClick(Sender: TObject);
begin
  Edit1.Text := '';
  Edit1.Enabled := False;
  Connect.Enabled := False;
  SendData.Enabled := False;
  If UseServerName.Checked = True Then
    NovTLI1.ServerName := ServerName.Text;
  NovTLI1.Port := StrToInt(Port.Text);
  NovTLI1.Listen;
  Listen.Enabled := False;
  CancelListen.Enabled := True;
  Disconnect.Enabled := False;
  clientserver := 2;
end;

procedure TForm1.CloseClick(Sender: TObject);
begin
  NovTLI1.Close;
  Connect.Enabled := True;
  SendData.Enabled := False;
  Listen.Enabled := True;
  Close.Enabled := False;
  Disconnect.Enabled := False;
  CancelListen.Enabled := False;
  clientserver := 0;
end;

procedure TForm1.DisconnectClick(Sender: TObject);
begin
  NovTLI1.Disconnect;
  Disconnect.Enabled := False;
end;

procedure TForm1.CancelListenClick(Sender: TObject);
begin
  If NovTLI1.SocketNumber <> -1 Then
    NovTLI1.Close;
  If NovTLI1.ListenSocketNumber <> -1 Then
  begin
    NovTLI1.SocketNumber := NovTLI1.ListenSocketNumber;
    NovTLI1.Close;
  End;
  Connect.Enabled := True;
  SendData.Enabled := False;
  Listen.Enabled := True;
  Close.Enabled := False;
  Disconnect.Enabled := False;
  CancelListen.Enabled := False;
end;

procedure TForm1.NovTLI1SessionAvailable(Sender: TObject; Socket: Integer);
begin
  NovTLI1.Accept;
  Memo1.Lines.Add('Client session accepted on socket(' + IntToStr(Socket) + ')');
  Listen.Enabled := False;
  Close.Enabled := True;
end;

procedure TForm1.NovTLI1SessionClosed(Sender: TObject; Socket: Integer);
begin
  Memo1.Lines.Add('Session on socket(' + IntToStr(Socket) + ') is closed');
  Close.Enabled := False;
end;

procedure TForm1.UseServerNameClick(Sender: TObject);
begin
  NetNode.Enabled := False;
  AddrNet.Enabled := False;
  AddrNode.Enabled := False;
  ServerName.Enabled := True;
end;

procedure TForm1.UsePhysicalAddrClick(Sender: TObject);
begin
  NetNode.Enabled := True;
  AddrNet.Enabled := True;
  AddrNode.Enabled := True;
  ServerName.Enabled := False;
end;

procedure TForm1.HelpButtonClick(Sender: TObject);
begin
  AboutBox.Show;
end;

end.
