unit Nwsap;
interface
uses
  nxtw;
const
  SAP_SOCKET          =   $452;
  SAP_PACKET_TYPE     =   2;
  ONE_MINUTE          =   (60 * 18);
  IPX_EVENT_CANCELED  =   $FC;
  NOT_SUPPORTED       =   1;
  INVALID_QUERY_TYPE  =   2;
  PERIODIC_ID_PACKET  =   2;
  SUCCESSFUL          =   $00;
  FAILURE             =   (-1);
  RESPONSE_ID_PACKET  =     4;
  MAX_NUM_APPS        =    10;


  OPEN_SAP_SOCKET_ERROR        =  $60;
  TOO_MANY_SERVERS_ON_NODE     =  $61;
  SAP_MEMORY_ALLOC_ERROR       =  $62;
  SERVER_ALREADY_ADVERTISING   =  $63;
  MULTIPLE_INSTANCES_ON_SOCKET =  $64;
  SAP_MEMORY_FREE_ERROR        =  $65;
  SAP_MEMORY_UNLOCK_ERROR      =  $66;
  SAP_ECB_NOT_CANCELLED        =  $67;
  SAP_SERVER_NOT_ADVERTISING   =  $68;

type
   SAPHeader = record
      checksum: word;            (* high-low 1's complement *)
      length: word;              (* high-low unsigned int *)
      transportControl: byte;
      packetType: byte;
      destination: IPXAddress;
      source: IPXAddress;
      SAPPacketType: word;       (* 2 or 4 *)
      serverType: word;          (* assigned by Novell *)
      serverName: array[0..47] of byte;      (* VAP name *)
      serverAddress: IPXAddress; (* server internet address *)
      interveningNetworks: WORD; (* # of networks packet must traverse *)
   end;


   SAPQueryPacket = record
      checksum: WORD;            (* high-low 1's complement *)
      length: WORD;              (* high-low unsigned int *)
      transportControl: BYTE;
      packetType: BYTE;
      destination: IPXAddress;
      source: IPXAddress;
      queryType: WORD;           (* high-low, 1 or 3 *)
      serverType: WORD;          (* high-low, assigned by Novell *)
    end;


   (* SAP packet *)
   SAP_BUFFER = record
      theECB: ECB;
      packet: SAPHeader;
   end;


   SAP = record
      Header: IPXHeader;
      ResponseType: WORD;        (* HI - LO   *)
      ServerType: WORD;          (* HI - LO   *)
      ServerName: array[0..47] of char;
      Network: array[0..3] of char;          (* hi - lo   *)
      Node: array[0..5] of char;             (* hi - lo   *)
      Socket: array[0..1] of char;           (* hi - lo   *)
      InterveningNetworks: WORD  (* hi - lo   *)
   end;


   SEND_PACKET = record
      theECB: ECB;
      SAPq: SAPQueryPacket;
   end;


   RECEIVE_PACKET = record
      theECB: ECB;
      SB: SAP;
   end;


procedure Advertiser(var usedECB: ECB);
function AdvertiseService(x:WORD; y: PChar; var z: integer): integer;
function InitializeSAP: integer;
function QueryServices(queryType: word; serverType: word; returnSize: word; var serviceBuffer: SAP ): integer;
procedure RespondToLocalQuery(var usedRespondECB: ECB);
function ShutdownSAP(servername: PChar): integer;

implementation
procedure Advertiser; external 'nwipxspx';
function AdvertiseService; external 'nwipxspx';
function InitializeSAP; external 'nwipxspx';
function QueryServices; external 'nwipxspx';
procedure RespondToLocalQuery; external 'nwipxspx';
function ShutdownSAP; external 'nwipxspx';

end.
