unit Nxtw;

interface
const
      SUCCESSFUL                    =  $00;
      SPX_NOT_INSTALLED             =  $00;
      SPX_INSTALLED                 =  $FF;
      SPX_CONNECTION_OK             =  $00;
      SPX_CONNECTION_STARTED        =  $00;
      SPX_CONNECTION_ESTABLISHED    =  $00;
      SPX_PACKET_SUCCESSFUL         =  $00;
      SPX_SOCKET_NOT_OPENED         =  $FF;
      SPX_MALFORMED_PACKET          =  $FD;
      SPX_PACKET_OVERFLOW           =  $FD;
      SPX_LISTEN_CANCELED           =  $FC;
      SPX_CONNECTION_TABLE_FULL     =  $EF;
      SPX_INVALID_CONNECTION        =  $EE;
      SPX_NO_ANSWER_FROM_TARGET     =  $ED;
      SPX_CONNECTION_FAILED         =  $ED;
      SPX_CONNECTION_TERMINATED     =  $ED;
      SPX_TERMINATED_POORLY         =  $EC;

      NO_MGMT_MEMORY                =  $F0;
      IPXSPX_NOT_INIT               =  $F1;
      IPX_NOT_INIT                  =  $F1;
      NO_DOS_MEMORY                 =  $F2;
      NO_FREE_ECB                   =  $F3;
      WINLOCK_FAILED                =  $F4;
      OVER_MAX_LIMIT                =  $F5;    (* The packet size specified in init is too large. *)
      IPXSPX_PREV_INIT              =  $F6;

      CANCEL_FAILURE                =  $F9;
      NO_PATH_TO_DESTINATION_FOUND  =  $FA;
      ECB_CANCELLED                 =  $FC;
      PACKET_OVERFLOW               =  $FD;
      PACKET_UNDELIVERABLE          =  $FE;
      SOCKET_NOT_OPEN               =  $FF;
      TRANSMIT_FAILURE              =  $FF;
      ECB_NOT_IN_USE                =  $FF;
      SOCKET_ALREADY_OPEN           =  $FF;
      IMMEDIATE_ADDRESS_COMPLETE    =  $7777;


type

  IPXAddress = record
    network: array[0..3] of byte;              (* high-low *)
    node: array[0..5] of byte;                  (* high-low *)
    socket: array[0..1] of byte;              (* high-low *)
  end;

  IPXHeader = record
    checkSum: word;               (* high-low *)
    length: word;                 (* high-low *)
    transportControl: byte;
    packetType: byte;
    destination: IPXAddress;
    source: IPXAddress;
  end;

  SPXHeader = record
    checksum: word;               (* high-low 1's complement *)
    length: word;                 (* high-low unsigned int *)
    transportControl: byte;
    packetType: byte;
    destination: IPXAddress;
    source: IPXAddress;
    connectionControl: byte;      (* bit flags *)
    dataStreamType: byte;
    sourceConnectionID: word;     (* high-low unsigned *)
    destConnectionID: word;       (* high-low unsigned *)
    sequenceNumber: word;         (* high-low unsigned *)
    acknowledgeNumber: word;      (* high-low unsigned *)
    allocationNumber: word;       (* high-low unsigned *)
  end;

  CONNECTION_INFO = record
    connectionState: byte;
    connectionFlags: byte;
    sourceConnectionID: word;               (* hi-lo *)
    destinationConnectionID: word;          (* hi-lo *)
    sequenceNumber: word;                   (* hi-lo *)
    acknowledgeNumber: word;                (* hi-lo *)
    allocationNumber: word;                 (* hi-lo *)
    remoteAcknowledgeNumber: word;          (* hi-lo *)
    remoteAllocationNumber: word;           (* hi-lo *)
    connectionSocket: word;                 (* hi-lo *)
    immediateAddress: array[0..5] of byte;
    destination: IPXAddress;
    retransmissionCount: word;              (* hi-lo *)
    estimatedRoundTripDelay: word;          (* hi-lo *)
    retransmittedPackets: word;             (* hi-lo *)
    suppressedPackets: word;                (* hi-lo *)
  end;


  ECBFragment = record
    address: Pointer;
    size: word;                (* low-high *)
  end;

  ECB = record
    linkAddress: pointer;
    ESRAddress: pointer;
    inUseFlag: byte;
    completionCode: byte;
    socketNumber: word;               (* high-low *)
    IPXWorkspace: array[0..3] of byte;            (* N/A *)
    driverWorkspace: array[0..11] of byte;        (* N/A *)
    immediateAddress: array[0..5] of byte;        (* high-low *)
    fragmentCount: word;              (* low-high *)
    fragmentDescriptor: array[0..4] of ECBFragment;
  end;

  AGLT = record
    ecb: ECB;
    taskID: longint;
    retry: word;
    hWnd: integer;
  end;

  procedure CloseIPXWindow;
  function IPXCancelEvent(IPXTaskID: longint; var eventControlBlock: ECB): integer;
  procedure IPXCloseSocket(IPXTaskID: longint; socket: word);
  procedure IPXDisconnectFromTarget(IPXTaskID: longint; var internetAddress: byte);
  procedure IPXGetInternetworkAddress(IPXTaskID: longint; var internetAddress: byte);
  function IPXGetIntervalMarker(IPXTaskID: longint): word;
  function IPXGetLocalTarget(IPXTaskID: longint; var destination: byte;
    var immediateAddress: byte;var transportTime: integer): integer;
  function IPXGetLocalTargetAsync(var listenAGLT: AGLT;var sendAGLT: AGLT; var destAddr: byte): word;
  function IPXGetMaxPacketSize: word;
  function IPXGetRetryCount: word;
  function IPXInitialize(var IPXTaskID: longint; maxECBs: word; maxPacketSize: word): word;
  function IPXSPXDeinit(IPXTaskID:longint): integer;
  procedure IPXListenForPacket(IPXTaskID: longint;var eventControlBlock: ECB);
  function IPXOpenSocket(IPXTaskID: longint;var socket: word;socketType: byte): integer;
  procedure IPXRelinquishControl;
  procedure IPXScheduleIPXEvent(IPXTaskID: longint;timeDelay: word;var eventControlBlock: ECB);
  procedure IPXSendPacket(IPXTaskID: longint;var eventControlBlock: ECB);
  procedure IPXYield;
  function SetUpIPXWindow: boolean;
  procedure SPXAbortConnection(SPXConnID: word);
  function SPXEstablishConnection(IPXTaskID: longint;retryCount: byte;watchDog: byte;
    var SPXConnID: word;var eventControlBlock: ECB): word;
  function SPXGetConnectionStatus(IPXTaskID: longint;SPXConnID: word;
    var connectionInfo: CONNECTION_INFO): integer;
  function SPXInitialize(var IPXTaskID: longint;maxECBs: word;maxPacketSize: word;
    var majorRevisionNumber: byte;var minorRevisionNumber: byte;
    var maxConnections: word;var availableConnections: word): integer;
  procedure SPXListenForConnection(IPXTaskID: longint;retryCount: byte;watchDog: byte;var eventControlBlock: byte);
  procedure SPXListenForSequencedPacket(IPXTaskID: longint;var eventControlBlock: ECB);
  procedure SPXSendSequencedPacket(IPXTaskID: longint;SPXConnID: word;var eventControlBlock: ECB);
  procedure SPXTerminateConnection(IPXTaskID: longint;SPXConnID: word;var eventControlBlock: ECB);

implementation
  procedure CloseIPXWindow; external 'nwipxspx';
  function IPXCancelEvent; external 'nwipxspx';
  procedure IPXCloseSocket; external 'nwipxspx';
  procedure IPXDisconnectFromTarget; external 'nwipxspx';
  procedure IPXGetInternetworkAddress; external 'nwipxspx';
  function IPXGetIntervalMarker; external 'nwipxspx';
  function IPXGetLocalTarget; external 'nwipxspx';
  function IPXGetLocalTargetAsync; external 'nwipxspx';
  function IPXGetMaxPacketSize; external 'nwipxspx';
  function IPXGetRetryCount; external 'nwipxspx';
  function IPXInitialize; external 'nwipxspx';
  function IPXSPXDeinit; external 'nwipxspx';
  procedure IPXListenForPacket; external 'nwipxspx';
  function IPXOpenSocket; external 'nwipxspx';
  procedure IPXRelinquishControl; external 'nwipxspx';
  procedure IPXScheduleIPXEvent; external 'nwipxspx';
  procedure IPXSendPacket; external 'nwipxspx';
  procedure IPXYield; external 'nwipxspx';
  function SetUpIPXWindow; external 'nwipxspx';
  procedure SPXAbortConnection; external 'nwipxspx';
  function SPXEstablishConnection; external 'nwipxspx';
  function SPXGetConnectionStatus; external 'nwipxspx';
  function SPXInitialize; external 'nwipxspx';
  procedure SPXListenForConnection; external 'nwipxspx';
  procedure SPXListenForSequencedPacket; external 'nwipxspx';
  procedure SPXSendSequencedPacket; external 'nwipxspx';
  procedure SPXTerminateConnection; external 'nwipxspx';

end.
