unit Tispxipx;

interface

const
  { Option version history }

  OPTIONS_VERSION =  1;

  OPTIONS_SIZE   = (13 * sizeof (longint));
  { SPX and SPX II Option Management values }

  SPX_WATCHDOG_OFF   =   0;
  SPX_WATCHDOG_ON    =   not SPX_WATCHDOG_OFF;
  SPX_WATCHDOG_DEFAULT = SPX_WATCHDOG_ON;

  { SPX options only above here }

  SPX_RETRY_MIN      =   3;
  SPX_RETRY_MAX      =   50;
  SPX_RETRY_DEFAULT  =   10;

  { SPX II options only below here }

  SPX_WATCHDOG_TIMEOUT_MIN     =  3000;     { msec == 3 seconds }
  SPX_WATCHDOG_TIMEOUT_MAX     =  300000;   { msec == 5 minutes }
  SPX_WATCHDOG_TIMEOUT_DEFAULT =  60000;    { msec == 1 minute }

  SPX_MIN_RETRY_DELAY_MIN     =   1;          { msec  }
  SPX_MIN_RETRY_DELAY_MAX     =   60000;      { msec == 1 minute	}
  SPX_MIN_RETRY_DELAY_DEFAULT =   0;          { Protocol provider decides }
  SPX_MAX_RETRY_DELTA_MIN     =   1000;       { msec == 1 second	}
  SPX_MAX_RETRY_DELTA_MAX     =   60000;      { msec == 1 minute	}
  SPX_MAX_RETRY_DELTA_DEFAULT =   5000;       { msec == 5 seconds	}

  SPX_OPTION_NEGOTIATE_OFF     =  0;
  SPX_OPTION_NEGOTIATE_ON      =  not SPX_OPTION_NEGOTIATE_OFF;
  SPX_OPTION_NEGOTIATE_DEFAULT =  SPX_OPTION_NEGOTIATE_ON;

  SPX_CONNECT_TIMEOUT_MIN      =  1000;     { msec == 1 second  }
  SPX_CONNECT_TIMEOUT_MAX      =  120000;   { msec == 2 minutes	}
  SPX_CONNECT_TIMEOUT_DEFAULT  =  0;        { Protocol provider decides }

  SPX_LOCAL_WINDOW_SIZE_MIN     =  1;
  SPX_LOCAL_WINDOW_SIZE_MAX     =  8;
  SPX_LOCAL_WINDOW_SIZE_DEFAULT =  0;        { Protocol provider decides }

  SPX2_SF_NONE                =   $00;     { Session flags, None       }
  SPX2_SF_IPX_CHECKSUM        =   $01;     { Session flags, IPX Xsum   }
  SPX2_SF_SPX2_SESSION        =   $02;




  { T_DISCONNECT reason codes for SPX }

  TLI_SPX_CONNECTION_FAILED      = $ed;
  TLI_SPX_CONNECTION_TERMINATED  = $ec;    { T_DISCONNECT from remote }
  TLI_SPX_MALFORMED_PACKET       = $fe;
  TLI_SPX_PACKET_OVERFLOW        = $fd;    { This is the preferred one }
  TLI_SPX_UNREACHABLE_DEST       = $70;    { route not found }

  { t_rcvuderr uderr.error codes for IPX }

  TLI_IPX_MALFORMED_ADDRESS     =  $fe;
  TLI_IPX_PACKET_OVERFLOW       =  $fd;


type

IPX_ADDR = record
  ipxa_net: array[0..3] of char;
  ipxa_node: array[0..5] of char;
  ipxa_socket: array[0..1] of char;
end;

IPX_OPTS = record
  ipx_type: char;        { type field for ipx header  }
  ipx_pad1: array[0..2] of char;     { pad structure to 4 bytes, set to 0's }
  ipx_hops: char;        { Transport Control (hop count) }
  ipx_pad2: array[0..2] of char;    { pad structure to 8 bytes, set to 0's }
end;

{*
 *   SPX Options structure (Previous to 4.0 )
 *
 *   SPX II option structure, used if t_open("nspx",...) as oppossed to nspx2.
 *}

SPX_OPTS = record
  spx_connectionID: array[0..1] of char;
  spx_allocationNumber: array[0..1] of char;
  spx_pad1: array[0..3] of char;    { pad structure to 8 bytes, set to 0's }
end;

SPX_OPTMGMT = record
  spxo_retry_count: char;
  spxo_watchdog_flag: char;
  spxo_min_retry_delay: longint;
  spxo_pad2: array[0..1] of char;    { pad structure to 8 bytes, set to 0's }
end;

{*
 *   SPX Options structure (New to 4.0 and later)
 *
 *   SPX II option structure, used if t_open("nspx2",...) as oppossed to nspx.
 *   This stucture is used for all option managment settings and inquiries.
 *   Not all members are set/returned in every option management call.
 *   Option managment calls which use this common structure are:
 *
 *   t_getinfo    - returns size of SPX2_OPTIONS (changes as versions change)
 *   t_optmgmt    - sends/returns SPX2_OPTIONS to/from protocol provider
 *   t_accept     - sends SPX2_OPTIONS structure to protocol provider
 *   t_connect    - sends and, if not O_NDELAY,  returns SPX2_OPTIONS
 *	  t_rcvconnect - returns SPX2_OPTIONS from the provider
 *   t_listen     - returns SPX2_OPTIONS from the provider
 *}



SPX2_OPTIONS = record
   versionNumber: longint;           { must be set to OPTIONS_VERSION }
   spxIIOptionNegotiate: longint;
   spxIIRetryCount: longint;
   spxIIMinimumRetryDelay: longint;
   spxIIMaximumRetryDelta: longint;
   spxIIWatchdogTimeout: longint;
   spxIIConnectTimeout: longint;
   spxIILocalWindowSize: longint;
   spxIIRemoteWindowSize: longint;
   spxIIConnectionID: longint;
   spxIIInboundPacketSize: longint;
   spxIIOutboundPacketSize: longint;
   spxIISessionFlags: longint;       { version 1 ends }
end;






implementation

end.
