unit Tiuser;

interface

uses
  tispxipx;

const
  O_NDELAY   =   $4000;
  O_NONBLOCK =   O_NDELAY;
  O_RDWR = $02;
  EAGAIN     =   -1;

  { Error values }

  TBADADDR     =   1;
  TBADOPT      =   2;
  TACCES       =   3;
  TBADF        =   4;
  TNOADDR      =   5;
  TOUTSTATE    =   6;
  TBADSEQ      =   7;
  TSYSERR      =   8;
  TLOOK        =   9;
  TBADDATA     =  10;
  TBUFOVFLW    =  11;
  TFLOW        =  12;
  TNODATA      =  13;
  TNODIS       =  14;
  TNOUDERR     =  15;
  TBADFLAG     =  16;
  TNOREL       =  17;
  TNOTSUPPORT  =  18;
  TSTATECHNG   =  19;
  TNOSTRUCTYPE =  20;
  TBADNAME     =  21;
  TBADQLEN     =  22;
  TADDRBUSY    =  23;

  { t_look events }

  C_T_LISTEN     = $0001;
  C_T_CONNECT    = $0002;
  C_T_DATA       = $0004;
  C_T_EXDATA     = $0008;
  C_T_DISCONNECT = $0010;
  C_T_UDERR      = $0040;
  C_T_ORDREL     = $0080;
  C_T_GODATA     = $0100;
  C_T_GOEXDATA   = $0200;
  C_T_EVENTS     = $0400;
  C_T_ERROR      = $0500;   { Netware.tli specific t_look event }

  { Flag definitions }

  T_MORE        = $01;
  T_EXPEDITED   = $02;
  T_NEGOTIATE   = $04;
  T_CHECK       = $08;
  T_DEFAULT     = $10;
  T_SUCCESS     = $20;
  T_FAILURE     = $40;

  {   T_event flag values }

  T_DISABLE     = 0;
  T_ENABLE      = 1;
  T_SAME        = 2;


{ Service types }

  T_COTS       = 01;    { Connection-mode service }
  T_COTS_ORD   = 02;    { Connection service with orderly release }
  T_CLTS       = 03;    { Connectionless-mode service }

{ t_alloc structure types }

  T_BIND_STR     =  1;
  T_OPTMGMT_STR  =  2;
  T_CALL_STR     =  3;
  T_DIS_STR      =  4;
  T_UNITDATA_STR =  5;
  T_UDERROR_STR  =  6;
  T_INFO_STR     =  7;

  { t_alloc field identifiers }

  T_ADDR  = $01;
  T_OPT   = $02;
  T_UDATA = $04;

  T_ALL   = $08;  { modified to suit netware.tli }

  { redefine t_alloc types to suit AT&T specs }

  C_T_BIND     = T_BIND_STR;
  C_T_CALL     = T_CALL_STR;
  C_T_OPTMGMT  = T_OPTMGMT_STR;
  C_T_DIS      = T_DIS_STR;
  C_T_UNITDATA = T_UNITDATA_STR;
  C_T_UDERROR  = T_UDERROR_STR;
  C_T_INFO     = T_INFO_STR;


  { State values }

  C_T_UNINIT   =  0;    {* added to match xti state tables *}
  C_T_UNBND    =  1;    {* unbound *}
  C_T_IDLE     =  2;    {* idle *}
  C_T_OUTCON   =  3;    {* outgoing connection pending *}
  C_T_INCON    =  4;    {* incoming connection pending *}
  C_T_DATAXFER =  5;    {* data transfer *}
  C_T_OUTREL   =  6;    {* outgoing orderly release *}
  C_T_INREL    =  7;    {* incoming orderly release *}

  { general purpose defines }
  T_YES     =  1;
  T_NO      =  0;
  T_UNUSED  = -1;
  T_NULL    =  0;
  T_ABSREQ  =  $8000;

  { ------------------------OSI specific Options-------------------------}

  { ISO definitions }

  T_CLASS0  =  0;
  T_CLASS1  =  1;
  T_CLASS2  =  2;
  T_CLASS3  =  3;
  T_CLASS4  =  4;

  { priorities }

  T_PRITOP  = 0;
  T_PRIHIGH = 1;
  T_PRIMID  = 2;
  T_PRILOW  = 3;
  T_PRIDFLT = 4;

  { protection levels }

  T_NOPROTECT      = 1;
  T_PASSIVEPROTECT = 2;
  T_ACTIVEPROTECT  = 4;

  { default value for the length of TPDU's }

  T_LTPDUDFLT   = 128;


  {---------------------TCP specific Options--------------------------}

  { TCP Precedence Levels }

  T_ROUTINE       = 0;
  T_PRIORITY      = 1;
  T_IMMEDIATE     = 2;
  T_FLASH         = 3;
  T_OVERRIDEFLASH = 4;
  T_CRITIC_ECP    = 5;
  T_INETCONTROL   = 6;
  T_NETCONTROL    = 7;



type

  t_infoREC = record
    addr: longint;
    options: longint;
    tsdu: longint;
    etsdu: longint;
    connect: longint;
    discon: longint;
    servtype: longint;
  end;
  Pt_infoREC = ^t_infoREC;

  netbufREC = record
    maxlen: word;
    len: word;
    buf: PChar;
  end;
  PnetbufREC = ^netbufREC;

  t_bindREC = record
    addr: netbufREC;
    qlen: word;
  end;
  Pt_bindREC = ^t_bindREC;

  t_optmgmtREC = record
    opt: netbufREC;
    flags: longint;
  end;
  Pt_optmgmtREC = ^t_optmgmtREC;

  t_disconREC = record
    udata: netbufREC;
    reason: integer;
    sequence: integer;
  end;
  Pt_disconREC = ^t_disconREC;

  t_callREC  = record
    addr: netbufREC;
    opt: netbufREC;
    udata: netbufREC;
    sequence: integer;
  end;
  Pt_callREC = ^t_callREC;

  t_unitdataREC = record
    addr: netbufREC;
    opt: netbufREC;
    udata: netbufREC;
  end;
  Pt_unitdataREC = ^t_unitdataREC;

  t_uderrREC = record
    addr: netbufREC;
    opt: netbufREC;
    error: integer;
  end;
  Pt_uderrREC = ^t_uderrREC;

  { rate structure }

  rateREC = record
    targetvalue: longint;
    minacceptvalue: longint;
  end;
  PrateREC = ^rateREC;

  { reqvalue structure }

  reqvalueREC = record
    called: rateREC;
    calling: rateREC;
  end;
  PreqvalueREC = ^reqvalueREC;

  { throughput structure }

  thrptREC  = record
    maxthrpt: reqvalueREC;
    avgthrpt: reqvalueREC;
  end;
  PthrptREC = ^thrptREC;

  { management structure }

  managementREC  = record
    dflt: shortint;     { T_YES to use default values or T_NO to use values in structure }
    ltpdu: integer;     { maximum length of TPDU }
    reastime: shortint; { reassignment time (in seconds) }
    prefclass: char;    {* preferred class *}
    altclass: char;     { alternative class }
    extform: char;      { extended format: T_YES or T_NO }
    flowctrl: char;     { flow control: T_YES or T_NO }
    checksum: char;
    netexp: char;       { network expedited data }
    netrecptcf: char;   { receipt confirmation }
  end;
  PmanagementREC = ^managementREC;

  { ISO connection-oriented options }

  isoco_optionsREC = record
    throughput: thrptREC;
    transdel: reqvalueREC;       {* transit delay *}
    reserrorrate: rateREC;       { residual error rate }
    transffailprob: rateREC;     { transfer failure problem }
    estfailprob: rateREC;        { connection establishment failure problem }
    relfailprob: rateREC;        { connection release failure problem }
    estdelay: rateREC;           { connection establishment delay }
    reldelay: rateREC;           { connection release delay }
    connresil: netbufREC;        { connection resilience }
    protection: shortint;
    priority: shortint;
    mngmt: managementREC;        { management parameters }
    expd: char;               { expedited data: T_YES or T_NO }
  end;
  Pisoco_optionsREC = ^isoco_optionsREC;

  { ISO connectionless options }

  isocl_optionsREC = record
    transdel: rateREC;     { transit delay }
    reserrorrate: rateREC; { residual error rate }
    protection: shortint;
    priority: shortint;
  end;
  Pisocl_optionsREC = ^isocl_optionsREC;

  { TCP security options structure }

  secoptionsREC  = record
    security: shortint;
    compartment: shortint;
    handling: shortint;    { handling restrictions }
    tcc: longint;          { transmission control code }
  end;
  PsecoptionsREC = ^secoptionsREC;

  { TCP options }

  tcp_optionsREC = record
    precedence: shortint;
    timeout: longint;       { abort timeout }
    max_seg_size: longint;
    secopt: secoptionsREC;     { security options }
  end;
  Ptcp_optionsREC = ^tcp_optionsREC;

  Pint = ^integer;    { for t_errno }

function t_accept(fd: integer; resfd: integer; call: Pt_callREC ) : integer;
function t_alloc(fd: integer; struct_type: integer; fields: integer) : PChar;
function t_bind(fd: integer; req: Pt_bindREC; ret: Pt_bindREC ) : integer;
function t_blocking(fd: integer) : integer;
function t_close(fd: integer) : integer;
function t_connect(fd: integer; sndcall: Pt_callREC; rcvcall: Pt_callREC) : integer;
function t_errno: Pint;
procedure t_error (errmsg: PChar);
function t_free(ptr: PChar; struct_type: integer) : integer;
function t_getinfo(fd: integer; info: Pt_infoREC) : integer;
function t_getstate(fd: integer) : integer;
function t_listen(fd: integer; call: Pt_callREC) : integer;
function t_look (fd: integer) : integer;
function t_nonblocking(fd: integer) : integer;
function  t_open(path: PChar; oflag: integer; info: Pt_infoREC) : integer;
function t_optmgmt(fd: integer; req: Pt_optmgmtREC; ret: Pt_optmgmtREC) : integer;
function t_rcv (fd: integer; buf: PChar; nbytes: Word; var flags: integer) : integer;
function t_rcvconnect(fd: integer; call: Pt_callREC) : integer;
function t_rcvdis(fd: integer; discon: Pt_disconREC) : integer;
function t_rcvrel(fd: integer) : integer;
function t_rcvudata(fd: integer; unitdata: Pt_unitdataREC; var flags: integer ) : integer;
function t_rcvuderr(fd: integer; uderr: Pt_uderrREC) : integer;
function t_snd(fd: integer; buf: PChar; nbytes: word; flags: integer) : integer;
function t_snddis(fd: integer; call: Pt_callREC) : integer;
function t_sndrel(fd: integer) : integer;
function t_sndudata(fd: integer; unitdata: Pt_unitdataREC) : integer;
function t_sync(fd: integer) : integer;
function t_unbind(fd: integer) : integer;

implementation

function t_accept; external 'tli_win';
function t_alloc; external 'tli_win';
function t_bind; external 'tli_win';
function t_blocking; external 'tli_win';
function t_close; external 'tli_win';
function t_connect; external 'tli_win';
function t_errno; external 'tli_win' name 'terrno_func';
procedure t_error; external 'tli_win';
function t_free; external 'tli_win';
function t_getinfo; external 'tli_win';
function t_getstate; external 'tli_win';
function t_listen; external 'tli_win';
function t_look; external 'tli_win';
function t_nonblocking; external 'tli_win';
function  t_open; external 'tli_win';
function t_optmgmt; external 'tli_win';
function t_rcv; external 'tli_win';
function t_rcvconnect; external 'tli_win';
function t_rcvdis; external 'tli_win';
function t_rcvrel; external 'tli_win';
function t_rcvudata; external 'tli_win';
function t_rcvuderr; external 'tli_win';
function t_snd; external 'tli_win';
function t_snddis; external 'tli_win';
function t_sndrel; external 'tli_win';
function t_sndudata; external 'tli_win';
function t_sync; external 'tli_win';
function t_unbind; external 'tli_win';

end.
