unit AEUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, OvcBase, OvcData, OvcAe, OvcMisc, StdCtrls, CalUnit,
  Buttons;

type
  TAEForm = class(TForm)
    OvcSimpleArrayEditor1: TOvcSimpleArrayEditor;
    Label1: TLabel;
    OvcPictureArrayEditor1: TOvcPictureArrayEditor;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    OvcController1: TOvcController;
    procedure OvcSimpleArrayEditor1GetItem(Sender : TObject; Index: Longint;
      var Value: Pointer);
    procedure btnExitClick(Sender: TObject);
    procedure OvcSimpleArrayEditor1GetItemColor(Sender: TObject;
      Index: Longint; var FG, BG: TColor);
    procedure FormCreate(Sender: TObject);
    procedure OvcSimpleArrayEditor1DblClick(Sender: TObject);
    procedure OvcPictureArrayEditor1GetItem(Sender : TObject; Index: Longint;
      var Value: Pointer);
    procedure OvcPictureArrayEditor1DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AEForm: TAEForm;

implementation

{$R *.DFM}

const
  MaxItems = 50;

var
  {Data for the array. Data type must match the array data type}
  Data : array[0..MaxItems-1] of LongInt;
  Colors : array[0..MaxItems-1] of TColor;
  Dates : array[0..MaxItems-1] of TOvcDate;

procedure TAEForm.OvcSimpleArrayEditor1GetItem(Sender : TObject; Index: Longint;
  var Value: Pointer);
begin
  if (Index > -1) and (Index < MaxItems) then
    Value := @Data[Index]
  else
    raise Exception.Create('Invalid index value');
end;

procedure TAEForm.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TAEForm.OvcSimpleArrayEditor1GetItemColor(Sender: TObject;
  Index: Longint; var FG, BG: TColor);
begin
  if (Index > -1) and (Index < MaxItems) then
    {just the text color--set BG for the background color}
    FG := Colors[Index]
  else
    raise Exception.Create('Invalid index value');
end;

procedure TAEForm.FormCreate(Sender: TObject);
var
  I : Integer;
begin
  for I := 0 to MaxItems-1 do begin
    Data[I] := I;
    Colors[I] := clBlack;

    Dates[I] := CurrentDate + I;
  end;
end;

procedure TAEForm.OvcSimpleArrayEditor1DblClick(Sender: TObject);
var
  I : LongInt;
begin
  {requires one click to make the cell active before a}
  {double click is registered}
  I := OvcSimpleArrayEditor1.ItemIndex;
  Label1.Caption := Format('Index: %d', [I]);
end;

procedure TAEForm.OvcPictureArrayEditor1GetItem(Sender : TObject; Index: Longint;
  var Value: Pointer);
begin
  if (Index > -1) and (Index < MaxItems) then
    Value := @Dates[Index]
  else
    raise Exception.Create('Invalid index value');
end;

procedure TAEForm.OvcPictureArrayEditor1DblClick(Sender: TObject);
begin
  CalForm := TCalForm.Create(Application);
  try
    CalForm.OvcCalendar1.CalendarDate := Dates[OvcPictureArrayEditor1.ItemIndex];
    CalForm.ShowModal;
    if CalForm.ModalResult = idOK then begin
      Dates[OvcPictureArrayEditor1.ItemIndex] := CalForm.OvcCalendar1.CalendarDate;
      OvcPictureArrayEditor1.Refresh;
    end;
  finally
    CalForm.Free;
  end;
end;

end.
