unit CalUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, OvcCal, StdCtrls, Buttons, OvcSc, OvcMisc, OvcBase;

type
  TCalForm = class(TForm)
    OvcCalendar1: TOvcCalendar;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    OvcSpinner1: TOvcSpinner;
    ScrollBar1: TScrollBar;
    OvcController1: TOvcController;
    procedure OvcCalendar1Change(Sender: TObject);
    procedure OvcSpinner1Click(Sender: TObject; State: TSpinState;
      Delta: Longint; Wrap: Boolean);
    procedure ScrollBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CalForm: TCalForm;

implementation

{$R *.DFM}

procedure TCalForm.OvcCalendar1Change(Sender: TObject);
begin
  with OvcCalendar1 do begin
    Label1.Caption := MonthString + Format(' %d', [Year]);
    ScrollBar1.Position := Month;
  end;
end;

procedure TCalForm.OvcSpinner1Click(Sender: TObject; State: TSpinState;
  Delta: Longint; Wrap: Boolean);
begin
  with OvcCalendar1 do begin
    if State = ssUpBtn then
      Year := Year + 1
    else
      Year := Year - 1;
  end;
end;

procedure TCalForm.ScrollBar1Change(Sender: TObject);
var
  P : Integer;
begin
  P := ScrollBar1.Position;
  with OvcCalendar1 do begin
    if not ValidDate(Day, P, Year) then
      Day := 1;
    Month := P;
  end;
end;

end.
