(*!!
  Not done.
*)

unit Edunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Printers,
  OvcBase, OvcConst, OvcEdit, OvcData;

type
  TfmEditor = class(TForm)
    Ed: TOvcTextFileEditor;
    dlgFind: TFindDialog;
    dlgReplace: TReplaceDialog;
    dlgFont: TFontDialog;
    dlgSaveAs: TSaveDialog;
    dlgOpen: TOpenDialog;
    mnuMain: TMainMenu;
    miFile: TMenuItem;
    miOpen: TMenuItem;
    miSave: TMenuItem;
    miSaveAs: TMenuItem;
    miExit: TMenuItem;
    hdrStatus: THeader;
    dlgPrint: TPrintDialog;
    dlgPrintSetup: TPrinterSetupDialog;
    miCloseFile: TMenuItem;
    miNewFile: TMenuItem;
    OvcController1: TOvcController;
    procedure EdShowStatus(Sender: TObject; ColNum: Word; LineNum: Longint);
    procedure miOpenClick(Sender: TObject);
    procedure miSaveClick(Sender: TObject);
    procedure miSaveAsClick(Sender: TObject);
    procedure miExitClick(Sender: TObject);
    procedure miCloseFileClick(Sender: TObject);
    procedure miNewFileClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmEditor: TfmEditor;

implementation

{$R *.DFM}

procedure TfmEditor.EdShowStatus(Sender: TObject; ColNum: Word;
  LineNum: Longint);
begin
  with hdrStatus do begin
    if Ed.Modified then
      Sections[0] := '*'
    else
      Sections[0] := ' ';
    SectionWidth[0] := Canvas.TextWidth('W');

    Sections[1] := Format('%d:%d', [LineNum, ColNum]);
    SectionWidth[1] := Canvas.TextWidth('0000:0000');

    Sections[2] := Format('Bytes: %d', [Ed.TextLength]);
    SectionWidth[2] := Canvas.TextWidth('Bytes: 6553500');

    Sections[3] := Format('Paras: %d', [Ed.ParaCount]);
    SectionWidth[3] := Canvas.TextWidth('Paras: 6553500');
  end;
end;

procedure TfmEditor.miOpenClick(Sender: TObject);
begin
  dlgOpen.FileName := Ed.FileName;
  if dlgOpen.Execute then begin
    if FileExists(dlgOpen.FileName) then
      {open the file for editing}
      Ed.LoadFromFile(dlgOpen.FileName)
    else
      {create a new file and open it}
      Ed.NewFile(dlgOpen.FileName);

    {set editor read only status}
    Ed.ReadOnly := ofReadOnly in dlgOpen.Options;
  end;
end;

procedure TfmEditor.miSaveClick(Sender: TObject);
begin
  Ed.SaveToFile(Ed.FileName);
end;

procedure TfmEditor.miSaveAsClick(Sender: TObject);
begin
  dlgSaveAs.FileName := Ed.FileName;
  if dlgSaveAs.Execute then
    Ed.SaveToFile(dlgSaveAs.FileName);
end;

procedure TfmEditor.miExitClick(Sender: TObject);
begin
  if Ed.Modified then begin
    case MessageDlg('File has been modified. Save before exiting?', mtWarning, mbYesNoCancel, 0) of
      mrYes    : begin
                   if Ed.FileName > '' then
                     miSaveClick(Sender)
                   else
                     miSaveAsClick(Sender);
                   Close;
                 end;
      mrNo     : Close;
      mrCancel : ;
    end;
  end else
    Close;
end;

procedure TfmEditor.miCloseFileClick(Sender: TObject);
begin
  Ed.DeleteAll(True);
end;

procedure TfmEditor.miNewFileClick(Sender: TObject);
begin
  Ed.DeleteAll(True);
  Ed.FileName := '';
end;

end.
