unit Efunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, OvcNf, OvcPb, OvcPf, OvcBase, OvcEf, OvcSf,
  OvcMisc, OvcSc, OvcIntl, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    OvcNumericField1: TOvcNumericField;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Bevel1: TBevel;
    Label2: TLabel;
    OvcFourWaySpinner1: TOvcFourWaySpinner;
    Label7: TLabel;
    OvcPictureField1: TOvcPictureField;
    OvcSpinner1: TOvcSpinner;
    BitBtn1: TBitBtn;
    OvcController1: TOvcController;
    OvcSimpleField1: TOvcSimpleField;
    procedure FormActivate(Sender: TObject);
    procedure OvcSimpleField1Change(Sender: TObject);
    procedure OvcPictureField1Change(Sender: TObject);
    procedure OvcNumericField1Change(Sender: TObject);
    procedure OvcController1Error(Sender: TObject; ErrCode: Word;
      ErrMsg: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
var
  Buf : array[0..255] of Char;
begin
  OvcSimpleField1.AsString := 'Orpheus';
  {set picture mask to correspond with the control panel settings}
  OvcPictureField1.PictureMask :=
    StrPas(OvcIntlSup.InternationalDateP(Buf, True));
  OvcPictureField1.AsOvcDate := CurrentDate;
  OvcNumericField1.AsInteger := 13;

  Label2.Caption := OvcSimpleField1.AsString;
  Label4.Caption := OvcPictureField1.AsString;
  Label6.Caption := OvcNumericField1.AsString;

  with OvcNumericField1 do begin
    OvcSpinner1.Top := Top;
    OvcSpinner1.Left := Left+Width;
    OvcSpinner1.Height := Height;
  end;
end;

procedure TForm1.OvcSimpleField1Change(Sender: TObject);
begin
  Label2.Caption := OvcSimpleField1.AsString;
end;

procedure TForm1.OvcPictureField1Change(Sender: TObject);
begin
  Label4.Caption := OvcPictureField1.AsString;
end;

procedure TForm1.OvcNumericField1Change(Sender: TObject);
begin
  Label6.Caption := OvcNumericField1.AsString;
end;

procedure TForm1.OvcController1Error(Sender: TObject; ErrCode: Word;
  ErrMsg: String);
begin
    MessageDlg(ErrMsg, mtError, [mbOK], 0);
end;

end.
