{$B-} {Complete Boolean Evaluation}
{$G+} {286 Instructions}
{$I+} {Input/Output-Checking}
{$N+} {Numeric Coprocessor}
{$P+} {Open Parameters}
{$T-} {Typed @ Operator}
{$W-} {Windows Stack Frame}
{$X+} {Extended Syntax}

{$C MOVEABLE,DEMANDLOAD,DISCARDABLE}

{*********************************************************}
{*                   OVCREG.PAS 1.00                     *}
{*         Copyright (c) TurboPower Software 1995        *}
{*                 All rights reserved.                  *}
{*********************************************************}

{$R OVCREG.RES}

unit OvcReg;

interface

uses
  WinTypes, DsgnIntf, Classes;

type
  {property editor for the virtual listbox header string property}
  THeaderProperty = class(TCaptionProperty);

type
  {property editor for the timer pool}
  TOvcTimerPoolEditor = class(TDefaultEditor)
  private
  protected
    procedure EditProperty(PropertyEditor : TPropertyEditor;
              var Continue, FreeEditor : Boolean);
      override;
  public
  end;

type
  {component editor for the transfer component}
  TOvcTransferEditor = class(TDefaultEditor)
  private
  protected
  public
    procedure ExecuteVerb(Index : Integer);
      override;
    function GetVerb(Index : Integer): string;
      override;
    function GetVerbCount : Integer;
      override;
  end;



procedure Register;

implementation

uses
  WinProcs, SysUtils, Dialogs, Forms, Graphics,
  OvcEf,     {base entry field class--needed for sf, pf, nf, and ae}
  OvcSf,     {simple field component}
  OvcSfPE,   {simple mask property editor form}
  OvcPf,     {picture field component}
  OvcPfPE,   {picture mask property editor form}
  OvcNf,     {numeric entry field component}
  OvcNfPE,   {numeric mask property editor}
  OvcAe,     {array editors}
  OvcVlb,    {virtual list box component}
  OvcNbk,    {notebook component}
  OvcNbkP0,  {property editor for the notebook pages}
  OvcCal,    {calendar component}
  OvcViewr,  {viewer and text file viewer components}
  OvcMeter,  {meter component}
  OvcSc,     {spin components}
  OvcTimer,  {timer pool}
  OvcRLbl,   {rotated label component}
  OvcEdit,   {editor and text editor components}
  {!!OvcXfer,}   {form data transfer component}
  OvcFxFnt,  {fixed font class}
  OvcFxFPE,  {fixed font property editor}
  {!!OvcDbSf,}
  OvcVer, OvcBase, OvcCmd, OvcCmdP0;  {all required}


{*** TOvcTimerPoolEditor ***}

procedure TOvcTimerPoolEditor.EditProperty(PropertyEditor : TPropertyEditor;
          var Continue, FreeEditor : Boolean);
var
  PropName : string;
begin
  PropName := PropertyEditor.GetName;
  if CompareText(PropName, 'ONALLTRIGGERS') = 0 then begin
    PropertyEditor.Edit;
    Continue := False;
  end;
end;


{*** TOvcTransferEditor ***}

procedure TOvcTransferEditor.ExecuteVerb(Index: Integer);
begin
  {!!}
end;

function TOvcTransferEditor.GetVerb(Index: Integer): string;
begin
  Result := 'Generate Transfer Buffer';
end;

function TOvcTransferEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;


{*** component registration ***}

procedure Register;
begin
  {register property editor for the controller}
  RegisterPropertyEditor(
    TypeInfo(TCommandProcessor), nil, '', TOvcCommandProcessorProperty);

  {register property editor for the simple field's mask property}
  RegisterPropertyEditor(
    TypeInfo(Char), TOvcSimpleField, 'PictureMask', TSimpleMaskProperty);

  {register property editor for the picture field's mask property}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureField, 'PictureMask', TPictureMaskProperty);

  {register property editor for the numeric field's mask property}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericField, 'PictureMask', TNumericMaskProperty);

  {register property editor for the header of the virtual list box}
  RegisterPropertyEditor(
    TypeInfo(string), nil, 'Header', THeaderProperty);

  {register property editors and component editor for the notebook component}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNotebook, 'ActivePageName', TOvcTabPageNameProperty);
  RegisterPropertyEditor(
    TypeInfo(TStrings), TOvcNotebook, 'Pages', TOvcTabPageListProperty);

  {register component editor for the notebook component}
  RegisterComponentEditor(TOvcNotebook, TOvcNotebookEditor);

  {register component editor for the timer pool component}
  RegisterComponentEditor(TOvcTimerPool, TOvcTimerPoolEditor);

  {register property editors for the array editors}
  RegisterPropertyEditor(
    TypeInfo(Char), TOvcSimpleArrayEditor, 'PictureMask', TSimpleMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureArrayEditor, 'PictureMask', TPictureMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericArrayEditor, 'PictureMask', TNumericMaskProperty);

(*!!
  {register property editors for the data aware entry fields}
  RegisterPropertyEditor(
    TypeInfo(Char), TOvcDbSimpleField, 'PictureMask', TSimpleMaskProperty);
*)

  {register property editors for the fixed font class}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcFixedFont, 'Name', TOvcFixFontNameProperty);
  RegisterPropertyEditor(
    TypeInfo(TOvcFixedFont), nil, '', TOvcFixFontProperty);

(*!!
  {register component editor for the transfer component}
  RegisterComponentEditor(TOvcTransfer, TOvcTransferEditor);
*)

  {provide compatibility with eariler label class name}
  RegisterClassAlias(TOvcRotatedLabel, 'TOvcRLabel');

  {register our components}
  RegisterComponents(ProductName,
    [TOvcSimpleField,
     TOvcPictureField,
     TOvcNumericField,
     TOvcSimpleArrayEditor,
     TOvcPictureArrayEditor,
     TOvcNumericArrayEditor,
     TOvcVirtualListbox,
     TOvcEditor,
     TOvcTextFileEditor,
     TOvcFileViewer,
     TOvcTextFileViewer,
     TOvcNotebook,
     TOvcTimerPool,
     TOvcRotatedLabel,
     TOvcCalendar,
     TOvcMeter,
     TOvcSpinner,
     TOvcFourWaySpinner,
     TOvcStarSpinner,
     {!!TOvcDbSimpleField,}
     {!!TOvcTransfer,}
     TOvcController
    ]);
end;

end.
