unit VWunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, OvcViewr, OvcBase, OvcEf, OvcSf, ExtCtrls,
  Buttons;

type
  TForm1 = class(TForm)
    OvcFileViewer1: TOvcFileViewer;
    OvcTextFileViewer1: TOvcTextFileViewer;
    Panel1: TPanel;
    OvcSimpleField1: TOvcSimpleField;
    btnOpen: TButton;
    Label1: TLabel;
    Label2: TLabel;
    btnCopy: TButton;
    BitBtn1: TBitBtn;
    OvcController1: TOvcController;
    procedure btnOpenClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnCopyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnOpenClick(Sender: TObject);
const
  TP0 : TOvcTextPos = (Line:1; Col:0);
  TP1 : TOvcTextPos = (Line:3; Col:0);
begin
  {open and read with the text file viewer first so that the}
  {file viewer doesn't cause a sharing violation}
  {the text file viewer reads the complete file and then closes it}
  OvcTextFileViewer1.Filename := OvcSimpleField1.AsString;
  OvcTextFileViewer1.IsOpen := True;

  {the file viewer keeps the file open and pages through it}
  {using file mode $20 -- read only, deny write}
  OvcFileViewer1.Filename := OvcSimpleField1.AsString;
  OvcFileViewer1.IsOpen := True;

  {set markers}
  OvcFileViewer1.Marker[0] := TP0;
  OvcFileViewer1.Marker[1] := TP1;
  OvcTextFileViewer1.Marker[0] := TP0;
  OvcTextFileViewer1.Marker[1] := TP1;

  btnOpen.Enabled := False;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  OvcSimpleField1.AsString := 'VWUNIT.PAS';
end;

procedure TForm1.btnCopyClick(Sender: TObject);
begin
  OvcTextFileViewer1.CopyToClipboard;
end;

end.
