unit Pbstatus;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Win95gau;
type
  TpbCustomStatusBar = class(TCustomPanel)
  private

  protected
    { Protected declarations }

  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;

  published
  end;

type
  TpbUtilStatusBar = class(TpbCustomStatusBar)
    PnlLeft: TPanel;
    PnlCenter: TPanel;
    Gauge: TWin95Gauge;
  private
    { Private declarations }
    FCenterHint: String;
    FCenterMessage: String;
    FGaugeBoxColor: TColor;
    FGaugeHint: String;
    FGaugeMax: LongInt;
    FGaugeMin: LongInt;
    FGaugeProgress: LongInt;
    FLeftHint: String;
    FLeftMessage: String;
    procedure SetCenterHint(Value: String);
    procedure SetCenterMessage(Value: String);
    procedure SetGaugeBoxColor(Value: TColor);
    procedure SetGaugeHint(Value: String);
    procedure SetGaugeMax(Value: LongInt);
    procedure SetGaugeMin(Value: LongInt);
    procedure SetGaugeProgress(Value: LongInt);
    procedure SetLeftHint(Value: String);
    procedure SetLeftMessage(Value: String);
  protected
    { Protected declarations }

  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;

  published
    { Published declarations }
    property CenterHint: String read FCenterHint write SetCenterHint;
    property CenterMessage: String read FCenterMessage write SetCenterMessage;
    property Color;
    property Enabled;
    property Font;
    property GaugeBoxColor: TColor read FGaugeBoxColor write SetGaugeBoxColor;
    property GaugeHint: String read FGaugeHint write SetGaugeHint;
    property GaugeMax: LongInt read FGaugeMax write SetGaugeMax;
    property GaugeMin: LongInt read FGaugeMin write SetGaugeMin;
    property GaugeProgress: LongInt read FGaugeProgress write SetGaugeProgress;
    property Height;
    property LeftHint: String read FLeftHint write SetLeftHint;
    property LeftMessage: String read FLeftMessage write SetLeftMessage;
    property Name;
    property ParentColor;
    property ParentShowHint;
    property Tag;
    property Visible;
  end;

procedure Register;

implementation

constructor TpbCustomStatusBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Align := alBottom;
  BevelInner := bvNone;
  BevelOuter := bvNone;
  BevelWidth := 1;
  BorderStyle := bsSingle;
  BorderWidth := 1;
  Caption := '';
  Font.Color := clBlack;
  Font.Height := -11;
  Font.Name := 'MS Sans Serif';
  Font.Style := [];
  Height := 19;
end;

constructor TpbUtilStatusBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  Gauge := TWin95Gauge.Create(Self);
  with Gauge do
  begin
    Align := alRight;
    Parent := Self;
    ParentColor := True;
    Width := 100;
  end;

  PnlCenter := TPanel.Create(Self);
  with PnlCenter do
  begin
    Align := alRight;
    Alignment := taLeftJustify;
    BevelOuter := bvLowered;
    Parent := Self;
    ParentColor := True;
    Width := 100;
  end;

  PnlLeft := TPanel.Create(Self);
  with PnlLeft do
  begin
    Align := alClient;
    Alignment := taLeftJustify;
    BevelOuter := bvLowered;
    Parent := Self;
    ParentColor := True;
  end;

  FGaugeBoxColor := clNavy;
  FGaugeMax := 100;
  FGaugeMin := 1;
  FGaugeProgress := 0;
end;

procedure TpbUtilStatusBar.SetCenterHint(Value: String);
begin
  if Value <> FCenterHint then
    begin
      FCenterHint := Value;
      PnlCenter.Hint := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetCenterMessage(Value: String);
begin
  if Value <> FCenterMessage then
    begin
      FCenterMessage := Value;
      PnlCenter.Caption := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetGaugeBoxColor(Value: TColor);
begin
  if Value <> FGaugeBoxColor then
    begin
      FGaugeBoxColor := Value;
      Gauge.BoxColor := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetGaugeHint(Value: String);
begin
  if Value <> FGaugeHint then
    begin
      FGaugeHint := Value;
      Gauge.Hint := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetGaugeMax(Value: LongInt);
begin
  if Value <> FGaugeMax then
    begin
      FGaugeMax := Value;
      Gauge.MaxValue := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetGaugeMin(Value: LongInt);
begin
  if Value <> FGaugeMin then
    begin
      FGaugeMin := Value;
      Gauge.MinValue := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetGaugeProgress(Value: LongInt);
begin
  if Value <> FGaugeProgress then
    begin
      FGaugeProgress := Value;
      Gauge.Progress := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetLeftHint(Value: String);
begin
  if Value <> FLeftHint then
    begin
      FLeftHint := Value;
      PnlLeft.Hint := Value;
      Refresh;
    end;
end;

procedure TpbUtilStatusBar.SetLeftMessage(Value: String);
begin
  if Value <> FLeftMessage then
    begin
      FLeftMessage := Value;
      PnlLeft.Caption := Value;
      Refresh;
    end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TpbUtilStatusBar]);
end;

end.
