unit Win95gau;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TWin95Gauge = class(TGraphicControl)
  private
    FMinValue: Longint;
    FMaxValue: Longint;
    FCurValue: Longint;
    FBoxes: Word;
    FLead: Byte;
    FEnd: Byte;
    FBoxH: Word;
    FBoxW: Word;
    FBoxColor: TColor;
    procedure SetMinValue(Value: Longint);
    procedure SetMaxValue(Value: Longint);
    procedure SetProgress(Value: Longint);
    procedure SetBoxColor(Value: TColor);
    function  GetPercentDone: Longint;
    procedure CheckBounds;
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure AddProgress(Value: Longint);
    property PercentDone: Longint read GetPercentDone;
  published
    property Align;
    property BoxColor: TColor read FBoxColor write SetBoxColor default clNavy;
    property Color;
    property Enabled;
    property Hint;
    property Height;
    property MinValue: Longint read FMinValue write SetMinValue default 0;
    property MaxValue: Longint read FMaxValue write SetMaxValue default 100;
    property ParentColor;
    property ParentShowHint;
    property Progress: Longint read FCurValue write SetProgress;
    property ShowHint;
    property Tag;
    property Visible;
    property Width;
  end;

procedure Register;

implementation
{ short-circut Boolean-expression evaluation }
{$B-}

{ This function solves for x in the equation "x is y% of z". }
function SolveForX(Y:Byte; Z: Longint): LongInt;
begin
  Result := (Z * Y) div 100;
end;

{ This function solves for y in the equation "x is y% of z". }
function SolveForY(X, Z: Longint): Byte;
begin
  if Z = 0 then Result := 0
  else Result := (X * 100) div Z;
end;

constructor TWin95Gauge.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];
  FMinValue := 0;
  FMaxValue := 100;
  FCurValue := 0;
  FBoxColor := clNavy;
  Width := 104;
  Height := 23;
end;

function TWin95Gauge.GetPercentDone: Longint;
begin
	GetPercentDone := SolveForY(FCurValue - FMinValue, FMaxValue - FMinValue);
end;

procedure TWin95Gauge.CheckBounds;
begin
  if Height < 6 then Height := 6;
  FBoxH := Height - 3;
  FBoxW := FBoxH div 2;
  FBoxes := (Width - 4) div FBoxW;
  if FBoxes < 3 then FBoxes := 3;
  FEnd := ((Width - 4) - (FBoxes * FBoxW)) div 2;
  FLead := Width - ((FBoxes * FBoxW) + 4 + FEnd);
  SetBounds(Left,Top,Width,Height);
end;

procedure TWin95Gauge.Paint;
var FillSize,k: byte;
    tr: TRect;
    TheRect: TRect;
    bitmap: TBitmap;
    W,H: integer;
begin
 	CheckBounds;
  with Canvas do
  begin
    TheRect := ClipRect;
    Frame3D(Canvas,TheRect,clBtnShadow,clBtnHighlight,1);
    bitmap := TBitmap.Create;
    W := TheRect.Right - TheRect.Left + 1;
    H := TheRect.Bottom - TheRect.Top + 1;
    bitmap.Width := W;
    bitmap.Height := H;
    bitmap.canvas.Brush.Color := Color;
    bitmap.Canvas.Brush.Style := bsSolid;
    bitmap.canvas.FillRect(Rect(0,0,W,H));
    if Enabled then bitmap.canvas.Brush.Color := FBoxColor
    else bitmap.canvas.Brush.Color := Color;
    FillSize := SolveForX(PercentDone, FBoxes);
    if FillSize > FBoxes then FillSize := FBoxes;
    tr := Rect(TheRect.Left,TheRect.Top,FBoxW,FBoxH);
    if FLead > 0 then OffsetRect(tr,FLead,0);
    for k := 1 to FillSize do
    begin
      bitmap.canvas.FillRect(tr);
      OffsetRect(tr,FBoxW,0);
    end;
    Canvas.CopyRect(TheRect,bitmap.Canvas,Bounds(0,0,W,H));
    bitmap.Free;
  end;
end;

procedure TWin95Gauge.SetMinValue(Value: Longint);
begin
  if Value <> FMinValue then
  begin
    if Value > FMaxValue then FMaxValue := Value;
    FMinValue := Value;
    Refresh;
  end;
end;

procedure TWin95Gauge.SetMaxValue(Value: Longint);
begin
  if Value <> FMaxValue then
  begin
    if Value < FMinValue then FMinValue := Value;
    FMaxValue := Value;
    Refresh;
  end;
end;

procedure TWin95Gauge.SetBoxColor(Value: TColor);
begin
  if Value <> FBoxColor then
  begin
    FBoxColor := Value;
    Refresh;
  end;
end;

procedure TWin95Gauge.SetProgress(Value: Longint);
begin
	if (FCurValue <> Value) and (Value >= FMinValue) and (Value <= FMaxValue) then
  	begin
    	FCurValue := Value;
    	Refresh;
  	end;
end;

procedure TWin95Gauge.AddProgress(Value: Longint);
begin
	Progress := FCurValue + Value;
  Refresh;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TWin95Gauge]);
end;

end.
