{ ****************************************************************** }
{                                                                    }
{   Delphi component TPERCENT                                        }
{                                                                    }
{   A percent bar control                                            }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file E:\DELPHI\COMPCREA\3DPCT.CD           }
{   on 16 June 1995 at 13:04                                         }
{                                                                    }
{   Copyright 1995 Zane Rathwick                                     }
{                                                                    }
{ ****************************************************************** }


unit Percent;

interface

{$IFDEF WIN32}
uses Messages, Windows, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ELSE}
uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ENDIF}

     { Unit-wide declarations }
     { type }
     { . . . }
     { var }
     { . . . }

type
  TPERCENT = class(TGraphicControl)
    private
      { Private fields of TPERCENT }
        { Storage for property PercentShaded }
        FPercentShaded : Integer;
        { Storage for property IsHorizontal }
        FIsHorizontal : Boolean;
        { Storage for property PercentColor }
        FPercentColor : TColor;
        { Storage for property Font }
        FFont : TFont;
        { Storage for property ShowPercent }
        FShowPercent : Boolean;
        { Storage for property Caption }
        FCaption : String;

      { Private methods of TPERCENT }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        { Write method for property PercentShaded }
        procedure SetPercentShaded(Value : Integer);
        { Write method for property PercentColor }
        procedure SetPercentColor(Value : TColor);
        { Write method for property Font }
        procedure SetFont(Value : TFont);
        { Write method for property ShowPercent }
        procedure SetShowPercent(Value : Boolean);
        { Write method for property Caption }
        procedure SetCaption(Value : String);

    protected
      { Protected fields of TPERCENT }

      { Protected methods of TPERCENT }
        procedure Paint; override;

    public
      { Public fields of TPERCENT }

      { Public methods of TPERCENT }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of the component }
        property OnClick;
        property OnDblClick;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        { Percentage of the progress bar shaded }
        property PercentShaded : Integer
             read FPercentShaded write SetPercentShaded
             default 0;
        { Orientation of the progress bar (read-only) }
        property IsHorizontal : Boolean read FIsHorizontal;
        property Width default 90;
        property Height default 20;
        { Color of percent bar }
        property PercentColor : TColor
             read FPercentColor write SetPercentColor
             default clred;
        property Font : TFont read FFont write SetFont;
        { Toggles whether the percent is visible or not }
        property ShowPercent : Boolean
             read FShowPercent write SetShowPercent
             default True;
        { Text to appear in place of the percent }
        property Caption : String read FCaption write SetCaption;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TPERCENT with Samples as its
       default page on the Delphi component palette }
     RegisterComponents('Samples', [TPERCENT]);

     { Custom property editors, if any, can be registered here with
       calls to RegisterPropertyEditor }

end;

{ Method to set variable and property values and create objects }
procedure TPERCENT.AutoInitialize;
begin
     FPercentShaded := 0;
     Width := 90;
     Height := 20;
     FPercentColor := clred;
     FFont := TFont.Create;
     FShowPercent := True;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TPERCENT.AutoDestroy;
begin
     FFont.Free;
end; { of AutoDestroy }

{ Write method for property PercentShaded }
procedure TPERCENT.SetPercentShaded(Value : Integer);
begin
     FPercentShaded := Value;
     if FPercentShaded < 0 then
          FPercentShaded := 0
     else
          if FPercentShaded > 100 then
               FPercentShaded := 100;
     { Update the display of the component }
     Paint
end;

{ Write method for property PercentColor }
procedure TPERCENT.SetPercentColor(Value : TColor);
begin
     FPercentColor := Value;

     { If changing this property affects the appearance of
       the component, call Paint here so the image will be
       updated. }
      Paint;
end;

{ Write method for property Font }
procedure TPERCENT.SetFont(Value : TFont);
begin
     { Use Assign method because TFont is an object type }
     FFont.Assign(Value);

     { If changing this property affects the appearance of
       the component, call Paint here so the image will be
       updated. }
      Paint;
end;

{ Write method for property ShowPercent }
procedure TPERCENT.SetShowPercent(Value : Boolean);
begin
     FShowPercent := Value;

     { If changing this property affects the appearance of
       the component, call Paint here so the image will be
       updated. }
      Paint;
end;

{ Write method for property Caption }
procedure TPERCENT.SetCaption(Value : String);
begin
     FCaption := Value;

     { If changing this property affects the appearance of
       the component, call Paint here so the image will be
       updated. }
      Paint; 
end;

constructor TPERCENT.Create(AOwner: TComponent);
begin
     { Call the Create method of the parent class }
     inherited Create(AOwner);

     { Set the initial values of variables and properties using }
     { AutoInitialize procedure, generated by Component Create  }
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TPERCENT.Destroy;
begin
     { AutoDestroy, which is generated by Component Create, frees any   }
     { objects created by AutoInitialize.                               }
     AutoDestroy;

     { Here, free any other dynamic objects that the component methods  }
     { created but have not yet freed.  Also perform any other clean-up }
     { operations needed before the component is destroyed.             }

     { Last, free the component by calling the Destroy method of the    }
     { parent class.                                                    }
     inherited Destroy;
end;

procedure TPERCENT.Paint;
var
pctstr:string;
begin
     { Determine orientation; store it so it will
       be available in the IsHorizontal property }
     FIsHorizontal := (Width >= Height);

     { Draw the framing rectangle }
     canvas.pen.color:=clgray;
     canvas.moveto(0,height);
     canvas.lineto(0,0);
     canvas.lineto(width-1,0);
     canvas.pen.color:=clwhite;
     canvas.lineto(width-1,height-1);
     canvas.lineto(0,height-1);
     canvas.pen.color:=clblack;
     Canvas.Brush.Color := clWhite;
     Canvas.Pen.Width := 0;
     Canvas.Rectangle(1, 1, Width-1, Height-1);


     { Draw the progress bar within }
     Canvas.Brush.Color := fpercentcolor;
     Canvas.Pen.Width := 0;
     canvas.pen.color:=fpercentcolor;
     if FIsHorizontal then
          Canvas.Rectangle(2, 2, 2+Round((Width-4) * (FPercentShaded/100)), Height-2)
     else
          Canvas.Rectangle(2, height-2, Width-2, 2+Round((Height-4) * ((100-FPercentShaded)/100)));
     if showpercent=true then
     begin
          canvas.font:=font;
          str(FPercentShaded,pctstr);
          pctstr:=pctstr+'%';
          canvas.brush.style:=bsclear;
          canvas.textout((width-canvas.textwidth(pctstr))div 2,
               (height-canvas.textheight(pctstr)) div 2,pctstr);
     end else
     begin
          canvas.brush.style:=bsclear;
          canvas.textout((width-canvas.textwidth(caption))div 2,
               (height-canvas.textheight(caption)) div 2,caption);
     end;
end;



end.
