unit Example1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, ExtCtrls, Mainclss, Popupbox,
  Buttons, Spin;

type
  TForm1 = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    Label1: TLabel;
    Image1: TImage;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    PopupBox1: TPopupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Bevel1: TBevel;
    Label9: TLabel;
    GroupBox1: TGroupBox;
    Label10: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    PopupBox2: TPopupBox;
    Label11: TLabel;
    PopupBox3: TPopupBox;
    Label12: TLabel;
    PopupBox6: TPopupBox;
    Label15: TLabel;
    PopupBox7: TPopupBox;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    Label23: TLabel;
    Label24: TLabel;
    BitBtn1: TBitBtn;
    Label14: TLabel;
    PopupBox5: TPopupBox;
    PopupBox4: TPopupBox;
    Label13: TLabel;
    Bevel2: TBevel;
    Button1: TButton;
    CheckBox3: TCheckBox;
    Bevel3: TBevel;
    CheckBox4: TCheckBox;
    SpinEdit1: TSpinEdit;
    Label25: TLabel;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Label26: TLabel;
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PopupBox7DrawListItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure PopupBox2Popup(Sender: TObject);
    procedure PopupBox3Popup(Sender: TObject);
    procedure PopupBox7Popup(Sender: TObject);
    procedure PopupBox7Shutup(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  Example2;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then begin
    Key:= #0;
    PostMessage(Handle, WM_NextDlgCtl, 0, 0);
  end;
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then begin
    Key:= #0;
    Edit1.SetFocus;
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  PopupBox1.GoAwayOnCLick:= CheckBox1.Checked;
  PopupBox1.PopItUp;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  PopupBox1.GoAwayOnReturn:= CheckBox2.Checked;
  PopupBox1.PopItUp;
end;

procedure TForm1.FormShow(Sender: TObject);
VAR
  i: Integer;
begin
  PopupBox7.Text:= DateToStr(Date);
  { PopupBox-field gets a textcolor:
     -> working day = black
     -> saturday = dark red
     -> sunday = dark blue }
  Case DayOfWeek(Date) Of
    1: PopupBox7.Font.Color:= clMaroon;
    2..6: PopupBox7.Font.Color:= clBlack;
    7: PopupBox7.Font.Color:= clNavy;
  End;

  PopupBox7.ListItems.Clear;
  for i:= -14 to 14 do begin
    PopupBox7.ListItems.Add(DateToStr(Date + i));
  end;
end;

procedure TForm1.PopupBox7DrawListItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
VAR
  CurrDate: TDateTime;
begin
  CurrDate:= StrToDate(PopupBox7.ListItems[Index]);
  with (Control as TPopupBoxListBox).Canvas do begin
    Case DayOfWeek(CurrDate) Of
      1 : begin  {Sunday}
        Font.Color:= clRed;
        Font.Style:= Font.Style + [fsBold];
      end;

      7 : begin  {Saturday}
        Font.Color:= clNavy;
        Font.Style:= Font.Style + [fsBold];
      end;
    End;
    TextRect(Rect, Rect.Left, Rect.Top, PopupBox7.ListItems[Index] + ', ' +
                     FormatDateTime('dddd', CurrDate));
  end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
VAR
  TempBuf: Array[0..300] of Char;
begin
  strPCopy(TempBuf, 'write.exe '+
           ExtractFilePath(Application.ExeName)+'readme.wri');
  WinExec(TempBuf, SW_SHOW);
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2:= TForm2.Create(Form1);
  Form2.ShowModal;
  Form2.Free;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  PopupBox1.ListShutupOnEscape:= CheckBox3.Checked;
  PopupBox1.PopItUp;
end;

procedure TForm1.PopupBox2Popup(Sender: TObject);
begin
  Popupbox2.ListItemIndex:= DayOfWeek(Date)-1;
end;

procedure TForm1.PopupBox3Popup(Sender: TObject);
begin
  Popupbox3.ListItemIndex:= 4;
  Popupbox3.ListTopIndex:= 2;
end;

procedure TForm1.PopupBox7Popup(Sender: TObject);
VAR
  CurrDate: TDateTime;
  i: Integer;
begin
  {we have to select ourself the correct date in the list;
   notify that ListAutoPos is set to False}
  try
    CurrDate:= StrToDate(PopupBox7.Text);
  except
    on EConvertError do CurrDate:= Date;
  end;

  for i:= 0 to PopupBox7.ListItems.Count-1 do
    if StrToDate(PopupBox7.ListItems[i]) = CurrDate then begin
      PopupBox7.ListItemIndex:= i;
      if i >= 3 then Popupbox7.ListTopIndex:= i - 3;
      exit; {we found the correct date and stop}
    end;
end;

procedure TForm1.PopupBox7Shutup(Sender: TObject);
begin
  {PopupBox-field also gets the color}
  Case DayOfWeek(StrToDate(PopupBox7.Text)) Of
    1: PopupBox7.Font.Color:= clMaroon;
    2..6: PopupBox7.Font.Color:= clBlack;
    7: PopupBox7.Font.Color:= clNavy;
  End;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  PopupBox1.PopupBtn:= CheckBox4.Checked;
  Label25.Visible:= CheckBox4.Checked;
  SpinEdit1.Visible:= CheckBox4.Checked;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  PopupBox1.PopupBtnWidth:= SpinEdit1.Value;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
  if CheckBox5.Checked then begin

    if CheckBox6.Checked then
      PopupBox1.PopupOn:= tsGetFocusF4
    else
      PopupBox1.PopupOn:= tsGetFocus;

  end else begin

    if CheckBox6.Checked then
      PopupBox1.PopupOn:= tsF4
    else
      PopupBox1.PopupOn:= tsAlt_Down;

  end;
  PopupBox1.SetFocus;
end;

end.
