unit Printcan;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type
  TfPrintingQuery = class(TForm)
    Label1: TLabel;
    lProgress: TLabel;
    Label3: TLabel;
    lMax: TLabel;
    CancelBtn: TBitBtn;
    procedure CancelBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
  public
    FOnCancel : TNotifyEvent;
    procedure SetMax( max : longint );
    procedure SetProgress( prog : longint );
  end;

implementation

{$R *.DFM}

procedure TfPrintingQuery.SetMax( max : longint );
begin
     lMax.Caption := inttostr(max);
end;

procedure TfPrintingQuery.SetProgress( prog : longint );
begin
     lProgress.Caption := inttostr(prog);
     Application.ProcessMessages;
end;

procedure TfPrintingQuery.CancelBtnClick(Sender: TObject);
begin
     if Assigned(FOnCancel) then
        FOnCancel(Sender);
end;

procedure TfPrintingQuery.FormShow(Sender: TObject);
var
   i : integer;
begin
     (*
     ** We don't want to be modal (as therefore we have control)
     ** but we don't want the user to do anything else! So we need
     ** to disable the rest of the application's forms. I think I heard
     ** of this technique from the Internet from someone else...
     *)
     for i := 0 to (Application.ComponentCount-1) do
        begin
        if (Application.Components[i].InheritsFrom(TForm)) and
           (TForm(Application.Components[i]) <> Self) then
           tForm(Application.Components[i]).Enabled := False;
        end;
end;

procedure TfPrintingQuery.FormHide(Sender: TObject);
var
   i : integer;
begin
     (*
     ** The reverse of Show
     *)
     for i := 0 to (Application.ComponentCount-1) do
        begin
        if Application.Components[i].InheritsFrom(TForm) then
           tForm(Application.Components[i]).Enabled := True;
        end;
end;

end.
