unit Prtmain;

(*
** This is a demo program that uses the print preview component...
*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, printp, StdCtrls;

type
  TForm1 = class(TForm)
    bPreview: TButton;
    Preview1: TPreview;
    procedure Preview1Paint(Canvas: TPreviewCanvas; PageNumber : LongInt);
    procedure bPreviewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Preview1Paint(Canvas: TPreviewCanvas; PageNumber : LongInt);
var
   Font : TFont;
   rect : TRect;
   val  : string;
begin
     if PageNumber = 1 then
        begin
        (* should have used With Canvas Do here *)
        Font := Canvas.GetFont;
        Font.Size := 22;
        Canvas.SetFont( Font );

        rect.top := 0;
        rect.left := Canvas.TextWidth('The');
        rect.bottom := Canvas.TextHeight( 'COMPACT DISC SHOP' ) + 200;
        rect.right := rect.left + Canvas.TextWidth( 'COMPACT DISC SHOP' ) + 200;
        Canvas.Brush.Color := clBlack;
        Canvas.FillRect( rect );

        Canvas.Font.Color := clWhite;
        Canvas.Textout( rect.left + 100, 100, 'COMPACT DISC SHOP' );

        (* restore normal *)
        Canvas.Brush.Color := clWhite;
        Canvas.Font.Color := clBlack;
        Canvas.Font.Size := 12;

        rect.left := Canvas.TwipMaxX - Canvas.TextWidth('Newsletter Number')
           - Canvas.TextWidth( '***00/00/00' ) - 100;

        Canvas.TextOut( rect.left, 100, 'Newsletter Number' );

        rect.top := 200+Canvas.textheight('N');
        val := '1';
        Canvas.TextOut( Canvas.TwipMaxX - 100 - Canvas.TextWidth(val), 100,
                        val );

        val := FormatDateTime( 'dd/mm/yy', Now );
        Canvas.TextOut( rect.left, rect.top, 'Newsletter Date' );
        Canvas.TextOut( Canvas.TwipMaxX - 100 - Canvas.TextWidth(val),
                        rect.top, val );

        Canvas.Font.Size := 16;
        Canvas.Font.Style := [fsBold];
        rect.left := (Canvas.TwipMaxX - Canvas.TextWidth('New Release Information Sheet')) div 2;
        Canvas.TextOut( rect.left, rect.bottom + 100, 'New Release Information Sheet' );
        Canvas.Font.Style := [fsItalic];

        rect.top := rect.bottom + 600;
        Canvas.Font.Size := 12;
        val := 'This week''s new releases... 20% OFF TO CARD HOLDERS for the first month of release';
        rect.left := (Canvas.TwipMaxX - Canvas.TextWidth(val)) div 2;
        Canvas.TextOut( rect.left, rect.top, val );
        Canvas.Font.Style := [];

        (* now for the block around it! *)
        rect.bottom := rect.top + Canvas.TextHeight( 'W' ) + 100;
        rect.top := 20;
        rect.left := 20;
        rect.right := Canvas.TwipMaxX - 20;
        Canvas.Brush.Color := clBlack;
        Canvas.FrameRect( rect );
        Canvas.Brush.Color := clWhite;
        end
     else
        begin
        Canvas.Font.Size := 36;
        Canvas.Textout( 1440, 1440, 'This is a test' );
        Canvas.Font.Size := 36;
        Canvas.TextOut( 4*1440, 20, 'Page Number :'+inttostr( PageNumber ) );
        end;
end;

procedure TForm1.bPreviewClick(Sender: TObject);
begin
     Preview1.PreviewMode  := True;
     Preview1.PageCount    := 2;
     Preview1.BeginDoc;
     Preview1.Print;
     Preview1.EndDoc;
end;

end.
