unit Printcha; {AddPrintChart Version 4.2 Copyright  W. Murto 1995}
               {Use with PrintPage Version 4.2 or higher}
interface

uses
  SysUtils, WinTypes, WinProcs, Classes,
  Printpag, Chart2FX, ChartFx;

type
  TAddPrintChart = class(TComponent)
  private
    { Private declarations }
    fPPC : TPrintPage;
    fPrintOther : TNotifyEvent;
    procedure PrintChart(Sender: TObject);
  protected
    { Protected declarations }
    procedure Loaded; override;
  public
    { Public declarations }
  published
    { Published declarations }
    property PrintPageComponent: TPrintPage read fPPC write fPPC;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TAddPrintChart]);
end;

procedure TAddPrintChart.Loaded;
begin
  inherited Loaded;
  if Assigned(fPPC) then
  begin
    fPrintOther := fPPC.OnExternalPrint;
    fPPC.OnExternalPrint := PrintChart;
  end;
end;

procedure TAddPrintChart.PrintChart(Sender: TObject);
var R : TRect;
    AChart : TChartFX;
begin
  if Sender is TChartFX then
  begin
    AChart := TChartFX(Sender);
    R := fPPC.ScaleToPrinter(AChart.BoundsRect);
    if fPPC.Previewing or (AChart.BorderStyle > 0) then
      fPPC.Dest.Rectangle(R.Left,R.Top,R.Right,R.Bottom);
    if fPPC.Previewing then
    begin
      fPPC.Dest.Font.Size := 7;
      fPPC.Dest.TextRect(R, R.Left, R.Top, ' Chart');
    end
    else ChartFX.chart_Paint
      (AChart.Handle, fPPC.Dest.Handle, R.Left, R.Top, R.Right, R.Bottom, 1, 0);
  end;
  if Assigned(fPrintOther) then fPrintOther(Sender);
end; {PrintChart}

end.
