unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Gauges, StdCtrls, ExtCtrls, Printers, Printpag, Printcha;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Gauge1: TGauge;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    ScrollBar1: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    PrintPage1: TPrintPage;
    AddPrintChart1: TAddPrintChart;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure PrintPage1UpdatePrintStatus(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses Unit2;

{$R *.DFM}

procedure TForm1.PrintPage1UpdatePrintStatus(Sender: TObject);
begin
  Gauge1.Progress := Gauge1.Progress + 1;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.Show;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
    PrintPage1.Source := Form2;
    PrintPage1.PreviewMenu := CheckBox1.Checked;
    PrintPage1.PreviewRulers := CheckBox2.Checked;
       { need uses Printers to access Orientation }
    if CheckBox3.Checked then Printer.Orientation := poLandscape
      else Printer.Orientation := poPortrait;
    PrintPage1.PreviewScale := 4.0 - (ScrollBar1.Position / 10);
    if PrintPage1.Preview = mrPrint then
    begin
     Gauge1.Progress := 0;
     Gauge1.MaxValue := 23; 
     Gauge1.Visible := true;
     PrintPage1.Print;
     Gauge1.Visible := false;
    end;
end;

end.
 