unit Resfix;
{*
 * The TResolutionFix component is copyright 1995 by Sean R. Malloy.
 * This component may be redistributed freely under the following
 * conditions:
 *
 *    1. This copyright notice remains unaltered.
 *    2. No 'compilation copyright' is claimed over any collection
 *       containing this component or any of its associated files.
 *    3. No fee is charged for this component, except to cover the
 *       cost of the disk by which the component is transferred.
 *       This prohibition includes all WWW sites and BBSes that
 *       require payment for download privileges.
 *}

interface

uses
  {SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Dialogs}
  Classes, Controls, Forms;

type
  TResolutionFix = class(TComponent)
  private
    { Private declarations }
    FScaled : boolean;
    FDesignRes : integer;
    procedure SetDesignRes(Resolution : integer);
  protected
    { Protected declarations }
  public
    { Public declarations }
  constructor Create(AOwner : TComponent); override;
  procedure FixResolution(Sender : TObject);
  published
    { Published declarations }
    property DesignRes: integer read FDesignRes write SetDesignRes default 120;
  end;

procedure Register;

implementation

constructor TResolutionFix.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FScaled:= FALSE;
  FDesignRes:= 120;
end;

procedure TResolutionFix.SetDesignRes(Resolution : integer);
begin
  FDesignRes:= Resolution;
end;


procedure TResolutionFix.FixResolution(Sender : TObject);
var
  i,j : integer;
  ThisRes, TmpVal : LongInt;
begin
{ if we've already scaled the form, do nothing }
  if (FScaled = TRUE) then exit;
  FScaled:= TRUE;
  ThisRes:= Screen.PixelsPerInch;
  with (Owner as TForm) do
  begin
    PixelsPerInch:= ThisRes;
    if (PixelsPerInch <> FDesignRes) then
    begin
      for i:= 0 to ComponentCount-1 do
      begin
        if (Components[i] is TControl) then
        begin
          for j:= 1 to 4 do
          begin
            case j of
              1: TmpVal:= TControl(Components[i]).Top;
              2: TmpVal:= TControl(Components[i]).Left;
              3: TmpVal:= TControl(Components[i]).Height;
              4: TmpVal:= TControl(Components[i]).Width;
            end;
            TmpVal:= LongInt(TmpVal*FDesignRes) div ThisRes;
            case j of
              1: TControl(Components[i]).Top:= TmpVal;
              2: TControl(Components[i]).Left:= TmpVal;
              3: TControl(Components[i]).Height:= TmpVal;
              4: TControl(Components[i]).Width:= TmpVal;
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TResolutionFix]);
end;

end.
 