unit Preview;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, RPBase, RPCanvas, RPFPrint,
  RPreview;

type
  TPreviewForm = class(TForm)
    Panel2: TPanel;
    SBZoomIn: TSpeedButton;
    SBZoomOut: TSpeedButton;
    Label1: TLabel;
    SBPrevPage: TSpeedButton;
    SBNextPage: TSpeedButton;
    Label2: TLabel;
    FilePreview1: TFilePreview;
    FilePrinter1: TFilePrinter;
    SBDone: TSpeedButton;
    SBPrint: TSpeedButton;
    ScrollBox1: TScrollBox;
    ZoomEdit: TEdit;
    SBZoomPageWidth: TSpeedButton;
    SBZoomPage: TSpeedButton;
    PageEdit: TEdit;
    PageLabel: TLabel;
    procedure SBZoomInClick(Sender: TObject);
    procedure SBZoomOutClick(Sender: TObject);
    procedure SBPrevPageClick(Sender: TObject);
    procedure SBNextPageClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SBPrintClick(Sender: TObject);
    procedure SBDoneClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SBZoomPageWidthClick(Sender: TObject);
    procedure SBZoomPageClick(Sender: TObject);
    procedure FilePreview1PageChange(Sender: TObject);
    procedure FilePreview1ZoomChange(Sender: TObject);
    procedure ZoomEditExit(Sender: TObject);
    procedure PageEditExit(Sender: TObject);
    procedure ZoomEditKeyPress(Sender: TObject; var Key: Char);
    procedure PageEditKeyPress(Sender: TObject; var Key: Char);
  end;

var
  PreviewForm: TPreviewForm;

implementation

{$R *.DFM}

procedure TPreviewForm.SBZoomInClick(Sender: TObject);
begin
  FilePreview1.ZoomIn;
end;

procedure TPreviewForm.SBZoomOutClick(Sender: TObject);
begin
  FilePreview1.ZoomOut;
end;

procedure TPreviewForm.SBPrevPageClick(Sender: TObject);
begin
  FilePreview1.PrevPage;
end;

procedure TPreviewForm.SBNextPageClick(Sender: TObject);
begin
  FilePreview1.NextPage;
end;

procedure TPreviewForm.FormActivate(Sender: TObject);
begin
  FilePreview1.Start;
end;

procedure TPreviewForm.SBPrintClick(Sender: TObject);
begin
  FilePrinter1.Execute;
end;

procedure TPreviewForm.SBDoneClick(Sender: TObject);
begin
  Close;
end;

procedure TPreviewForm.FormClose(    Sender: TObject;
                                 var Action: TCloseAction);
begin
  FilePreview1.Finish;
end;

procedure TPreviewForm.SBZoomPageWidthClick(Sender: TObject);
begin
  With FilePreview1 do begin
    ZoomFactor := ZoomPageWidthFactor;
  end; { with }
end;

procedure TPreviewForm.SBZoomPageClick(Sender: TObject);
begin
  With FilePreview1 do begin
    ZoomFactor := ZoomPageFactor;
  end; { with }
end;

procedure TPreviewForm.FilePreview1PageChange(Sender: TObject);

begin
  With FilePreview1 do begin
    PageEdit.Text := IntToStr(CurrentPage);
    PageLabel.Caption := 'Page ' + IntToStr(CurrentPage - FirstPage + 1) +
     ' of ' + IntToStr(Pages);
  end; { with }
end;

procedure TPreviewForm.FilePreview1ZoomChange(Sender: TObject);

var
  S1: string[10];

begin
  Str(FilePreview1.ZoomFactor:1:1,S1);
  ZoomEdit.Text := S1;
  FilePreview1.RedrawPage;
end;

procedure TPreviewForm.ZoomEditExit(Sender: TObject);

var
  F1: double;
  ErrCode: integer;

begin
  Val(ZoomEdit.Text,F1,ErrCode);
  If (ErrCode = 0) and (FilePreview1.ZoomFactor <> F1) then begin
    FilePreview1.ZoomFactor := F1;
  end; { if }
end;

procedure TPreviewForm.PageEditExit(Sender: TObject);

var
  I1: integer;
  ErrCode: integer;

begin
  Val(PageEdit.Text,I1,ErrCode);
  If (ErrCode = 0) and (FilePreview1.CurrentPage <> I1) then begin
    FilePreview1.PrintPage(I1);
  end; { if }
end;

procedure TPreviewForm.ZoomEditKeyPress(Sender: TObject; var Key: Char);
begin
  If Key = #13 then begin
    ZoomEditExit(Sender);
  end; { if }
end;

procedure TPreviewForm.PageEditKeyPress(Sender: TObject; var Key: Char);
begin
  If Key = #13 then begin
    PageEditExit(Sender);
  end; { if }
end;

end.


