unit Scombo;

{Search Combo Box}
{Version 1.02 by Andy Cooper - eMail 100622.1041@COMPUSERVE.COM}

interface

uses
  SysUtils, Classes, Controls, StdCtrls;

type
  TSearchCombo = class(TCustomComboBox)
  private
    FFullItems : TStringList; {Holds the full list of items}
    FAutoSelect : Boolean; {Holds whether or not to automatically select item if only 1}
    FCompareCase : Boolean; {Is case important when matching entries}
    FKeyString : string; {Search string keyed in so far}
    FKeyLabel : TLabel; {Pointer to label to display search string}
    procedure UpdateLabel; {Updates caption in KeyLabel to show search string}
    procedure CopyMatching; {Copies appropriate strings across}
  protected
    procedure DropDown; override;
    procedure DoExit; override;
    procedure KeyPress(Var Key : Char); override;
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    property FullItems : TStringList read FFullItems;
    property SearchString : string read FKeyString write FKeyString;
  published
    property AutoSelect : Boolean read FAutoSelect write FAutoSelect default True;
    property CompareCase : Boolean read FCompareCase write FCompareCase default False;
    property KeyLabel : TLabel read FKeyLabel write FKeyLabel;
    {publish properties that already exist}
    property DropDownCount;
    property ItemHeight;
    property Items;
    property ShowHint;
    property Sorted;
    property Style;
    property Text;
    property OnChange;
    property OnClick;
    property OnDropDown;
    property OnEnter;
    property OnExit;
    property OnKeyPress;
    property OnKeyDown;
    property OnKeyUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TSearchCombo]);
end;

constructor TSearchCombo.Create(AOwner : TComponent);
var
  intItem : integer;
begin
  inherited Create(AOwner);
  FFullItems := TStringList.Create;
  FAutoSelect := True;
  FCompareCase := False;
  FKeyLabel := nil;
  FKeyString := '';
  Style := csDropDownList;
end;

destructor TSearchCombo.Destroy;
begin
  FFullItems.Free;
  inherited Destroy;
end;

procedure TSearchCombo.DropDown;
var
  strOldText : string;
begin
  strOldText := Text;
  Items.Assign(FFullItems);
  ItemIndex := Items.IndexOf(strOldText);
  FKeyString := '';
  UpdateLabel;
  inherited DropDown;
end;

procedure TSearchCombo.DoExit;
begin
  inherited DoExit;
  FKeyString := '';
  UpdateLabel;
end;

procedure TSearchCombo.KeyPress(Var Key : Char);
begin
  inherited KeyPress(Key);
  if Key = #13 then
    Click
  else
  begin
    if not DroppedDown then
      DroppedDown := True;
    case Key of
      #8  : FKeyString := Copy(FKeyString, 1, Length(FKeyString) - 1);
    else
      FKeyString := FKeyString + Key;
    end; {case}
    UpdateLabel;
    CopyMatching;
    ItemIndex := 0;
    if FAutoSelect and (Items.Count = 1) then
    begin
      DroppedDown := False;
      Click;
    end;
  end;
end;

procedure TSearchCombo.UpdateLabel;
{Updates associated label to show what has been keyed in so far}
begin
  if FKeyLabel <> nil then
    FKeyLabel.Caption := FKeyString;
end;

procedure TSearchCombo.CopyMatching;

  function CompareConv(strText : string) : string;
  begin
    if FCompareCase then
      Result := strText
    else
      Result := UpperCase(strText);
  end; {sub function}

var
  intLoop : Integer;
  EmptyList : TStringList;
begin
  EmptyList := TStringList.Create;
  Items.Assign(EmptyList);
  EmptyList.Free;
  if FKeyString = '' then
    Items.Assign(FFullItems)
  else
    for intLoop := 0 to FullItems.Count - 1 do
      if Pos(CompareConv(FKeyString), CompareConv(FullItems[intLoop])) > 0 then
        Items.Add(FullItems[intLoop]);
end;

end.
