unit Fmailfwd;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mapi, ExtCtrls;

Const INTERVAL = 30;

type
  TForm1 = class(TForm)
    Mapi1: TMapi;
    txtRecipient: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Timer1: TTimer;
    Button2: TButton;
    pnlStatusInfo: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    TimerTicks: Integer;
    procedure FindAndForward;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FindAndForward;
begin

  pnlStatusInfo.Caption := 'Establishing mail session ...';
  Application.ProcessMessages;
  MAPI1.AutoDownload := True;
  MAPI1.Open;
  MAPI1.NewMessagesOnly := True;
  MAPI1.KeepConnection := True;
{  MAPI1.MarkRead := True; }


  Application.ProcessMessages;
  MAPI1.FirstMessage;
  while not MAPI1.EOF do begin
    pnlStatusInfo.Caption := 'Scanning new messages ...';
    Mapi1.GetMessage(MAPI1.MessageID);
    Mapi1.RecipientList.Clear;
    Mapi1.Subject := 'Orig.: ' + Mapi1.Originator + ' - ' + Mapi1.Subject;
    Mapi1.RecipientList.Add(txtRecipient.Text);
    Mapi1.Text.Insert(0,'Forwarded by MAPI component demo'+
                  chr(13) +chr(10) +
                  '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
    pnlStatusInfo.Caption := 'Forwarding message ...';
    Application.ProcessMessages;
    Mapi1.Send;
    MAPI1.NextMessage;
  end;
  pnlStatusInfo.Caption := 'Shutting down mail session ...';
  Application.ProcessMessages;
  MAPI1.Close;
  MAPI1.AutoDownload := False;
  pnlStatusInfo.Caption := 'Idle';
  Application.ProcessMessages;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if Button1.Caption = '&Start' then begin
    if txtRecipient.Text = '' then begin
      showMessage('Please enter recipient name');
      Exit;
    end
    else begin
      Mapi1.Clear;
      Mapi1.RecipientList.Add(txtRecipient.Text);
      Mapi1.ResolveNames;
    end;

    Button1.Caption := '&Stop';
    TimerTicks := 0;
    Timer1.Enabled := True;
  end
  else begin
    Button1.Caption := '&Start';
    Timer1.Enabled := False;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if TimerTicks < INTERVAL then begin
    Inc(TimerTicks);
    Exit;
  end
  else begin
    TimerTicks := 0;
    Timer1.Enabled := False;
    FindAndForward;
    Timer1.Enabled := True;
  end;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin

  Mapi1.AddressBook;
  if Mapi1.RecipientList.Count > 0 then
    txtRecipient.Text := Mapi1.RecipientList.Strings[0];

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Mapi1.ProfileName := 'MS Exchange Settings';
end;


end.
