unit chkbk;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Grids, spread;

type
  TForm1 = class(TForm)
    Spread1: TSpread;
    BitBtn1: TBitBtn;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Spread1ButtonClick(col, row: Longint; Name, Caption: String);
  private
    { Private declarations }
    procedure SetupSheet;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     If Opendialog1.execute then
     begin
       If not Spread1.loadfromfile(Opendialog1.filename) then
         MessageDlg('Error loading file',mterror,[mbok],0)
       else
         Spread1.recalculate;
     end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     setupsheet;
end;

procedure TForm1.SetupSheet;
var
   c,r : longint;
   Br : TBrush;
   formula : string;
begin
     spread1.colwidths[2] := 120;
     With Spread1 do
     begin
       for c := 0 to colcount - 1 do
       begin
         SetCellAlignment(c,0,taCenter);
         SetCelltype(c,0,cttext);
         case c of
           0 : SetFormula(c,0,'Date');
           1 : SetFormula(c,0,'Ref#');
           2 : SetFormula(c,0,'Payee');
           3 : SetFormula(c,0,'Deposit');
           4 : SetFormula(c,0,'Check');
           5 : SetFormula(c,0,'Balance');
         end;
       end;
       for c := 0 to 4 do
       begin
         case c of
           0 :
           begin
            SetCelltype(c,1,cttext);
            SetFormula(c,1,'Beg Bal');
            LockCell(c,1);
           end;
           5 : SetCelltype(c,1,ctformula);
           else
           begin
            SetCelltype(c,1,ctformula);
            LockCell(c,1);
           end;
         end;
       end;
       for r := 2 to rowcount - 1 do
       begin
         SetCelltype(0,r,ctdate);
         SetCelltype(1,r,cttext);
         SetCelltype(2,r,cttext);
         SetCelltype(3,r,ctformula);
         SetCellAlignment(3,r,TaRightjustify);
         SetCelltype(4,r,ctformula);
         SetCellAlignment(4,r,TaRightjustify);
         SetCelltype(5,r,ctformula);
         SetCellAlignment(5,r,TaRightjustify);
         Lockcell(5,r);
       end;
       Br := TBrush.Create;
       Br.color := clyellow;
       r := 2;
       while r < rowcount do
       begin
         SetRowBrush(r,Br);
         r := r + 2;
       end;
       Br.Free;
(*       for r := 2 to rowcount - 1 do
         Lockcell(5,r);  *)
       SetCellAlignment(5,1,taRightJustify);
       for r := 2 to rowcount - 1 do
       begin
         SetCelltype(5,r,ctformula);
         formula := '=f'+inttostr(r-1)+'+d'+inttostr(r)+'-e'+inttostr(r);
         SetFormula(5,r,formula);
       end;

       MakeButton(colcount-1,rowcount-1,'Save...');
       recalculate;
     end;

end;
procedure TForm1.Spread1ButtonClick(col, row: Longint; Name,
  Caption: String);
begin
     If Caption = 'Clear' then
     begin
        Spread1.MakeNewSheet;
        setupsheet;
     end
     else if Caption = 'Save...' then
     begin
       If savedialog1.execute then
       begin
         if not Spread1.savetofile(savedialog1.filename) then
           Messagedlg('Error saving file',mterror,[mbok],0);
       end;
     end;
end;

end.
