unit Testcgrd;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, dbcgrid, StdCtrls, DB, DBTables, Grids, DBGrids, RzStatus,
  ExtCtrls, Appex, Mask, DBCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Table1: TTable;
    DataSource1: TDataSource;
    Button2: TButton;
    eField: TEdit;
    eMatch: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cbOperator: TComboBox;
    odBitmap: TOpenDialog;
    rgBitmap: TRadioGroup;
    cbCaseSen: TCheckBox;
    cbTitles: TCheckBox;
    cbDataSource: TCheckBox;
    Button3: TButton;
    Table1LAST_NAME: TStringField;
    Table1FIRST_NAME: TStringField;
    Table1ACCT_NBR: TFloatField;
    Table1ADDRESS_1: TStringField;
    Table1CITY: TStringField;
    Table1STATE: TStringField;
    Table1ZIP: TStringField;
    Table1TELEPHONE: TStringField;
    Table1DATE_OPEN: TDateField;
    Table1SS_NUMBER: TFloatField;
    Table1PICTURE: TStringField;
    Table1BIRTH_DATE: TDateField;
    Table1RISK_LEVEL: TStringField;
    Table1OCCUPATION: TStringField;
    Table1OBJECTIVES: TStringField;
    Table1INTERESTS: TStringField;
    Table1IMAGE: TBlobField;
    procedure ChangeTitle;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure eMatchExit(Sender: TObject);
    procedure cbOperatorChange(Sender: TObject);
    procedure rgBitmapClick(Sender: TObject);
    procedure cbCaseSenClick(Sender: TObject);
    procedure cbTitlesClick(Sender: TObject);
    procedure cbDataSourceClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure eFieldExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DBCGrid1 : TDBCGrid;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.ChangeTitle;
var
sOp : string[4];
begin
   if DBCGrid1.Operator = moEqual then
      sOp := ' = '
   else if DBCGrid1.Operator = moNotEqual then
      sOp := ' <> '
   else if DBCGrid1.Operator = moGreaterThan then
      sOp := ' > '
   else if DBCGrid1.Operator = moLessThan then
      sOp := ' < '
   else if DBCGrid1.Operator = moGTorEqual then
      sOp := ' >= '
   else if DBCGrid1.Operator = moLTorEqual then
      sOp := ' <= '
   else if DBCGrid1.Operator = moNull then
      begin
      sOp := ' ';
      eMatch.Text := ' is Null';
      end
   else if DBCGrid1.Operator = moNotNull then
      begin
      sOp := ' ';
      eMatch.Text := ' is Not Null';
      end;
Form1.Caption := eField.Text + sOp + eMatch.Text;
end;
procedure TForm1.Button1Click(Sender: TObject);
begin
   if DBCGrid1 <> nil then
      begin
      MessageBeep(0);
      Exit;
      end;
   {DBCGrid1.CheckCol := eField.Text;}
   DBCGrid1 := TDBCGrid.Create( Self );
   DBCGrid1.Parent := Self;
   { test grid size OK for 800 x 600 }
   DBCGrid1.Left := 5;
   DBCGrid1.Top := 110;
   DBCGrid1.Height := 145;
   DBCGrid1.Width := 485;
  { DBCGrid1.DataSource := DataSource1; }
  { DBCGrid1.CheckCol := eField.Text; }
   DBCGrid1.CheckCriteria := eMatch.Text;
 (*  DBCGrid1.Options := [dgEditing, dgColLines, dgRowLines];  *)
 {  DBCGrid1.Operator := moEqual;  }
   cbCaseSen.Checked := DBCGrid1.CaseSensitive;
   cbTitles.Checked := dgTitles in DBCGrid1.Options;
   ChangeTitle;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   if DBCGrid1 <> nil then
      begin
      DBCGrid1.Free;
      DBCGrid1 := nil;
      {eField.Enabled := True;}
      end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   eField.Text := 'RISK_LEVEL';
   eMatch.Text := 'MED';
end;

procedure TForm1.eMatchExit(Sender: TObject);
begin
   if DBCGrid1 <> nil then
      begin
      DBCGrid1.CheckCriteria := eMatch.Text;
      ChangeTitle;
      DBCGrid1.Invalidate;
      end;
end;

procedure TForm1.cbOperatorChange(Sender: TObject);
begin
   DBCGrid1.Operator := TMatchOperators( cbOperator.ItemIndex );
   ChangeTitle;
   DBCGrid1.Invalidate;
end;

procedure TForm1.rgBitmapClick(Sender: TObject);
begin
   if rgBitmap.ItemIndex = 0 then
      begin
      DBCGrid1.Glyph.Handle := LoadBitMap( HInstance, 'CHECK_1' ); { set default }
      DBCGrid1.Invalidate;
      end
   else
      if odBitmap.Execute then
         begin
         DBCGrid1.Glyph.LoadFromFile( odBitmap.Filename );
         DBCGrid1.Invalidate;
         end
      else
         rgBitmap.ItemIndex := 0;
end;

procedure TForm1.cbCaseSenClick(Sender: TObject);
begin
   if DBCGrid1 <> nil then
      begin
      DBCGrid1.CaseSensitive := cbCaseSen.Checked;
      DBCGrid1.Invalidate;
      end;
end;

procedure TForm1.cbTitlesClick(Sender: TObject);
begin
   if DBCGrid1 = nil then
      exit;
   if cbTitles.Checked then
      DBCGrid1.Options := DBCGrid1.Options + [dgTitles]
   else
      DBCGrid1.Options := DBCGrid1.Options - [dgTitles];
end;

procedure TForm1.cbDataSourceClick(Sender: TObject);
begin
   if DBCGrid1 = nil then
      Exit;
   if cbDataSource.Checked then
      DBCGrid1.DataSource := DataSource1
   else
      DBCGrid1.DataSource := nil;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   if DBCGrid1 <> nil then
      begin
      MessageBeep(0);
      Exit;
      end;
   DBCGrid1 := TDBCGrid.Create( Self );
   DBCGrid1.Parent := Self;
   DBCGrid1.Top := 110;
   { test grid size OK for 800 x 600
   DBCGrid1.Left := 5;
   DBCGrid1.Top := 110;
   DBCGrid1.Height := 145;
   DBCGrid1.Width := 485;   }

end;

procedure TForm1.eFieldExit(Sender: TObject);
begin
   if DBCGrid1 <> nil then
      begin
      DBCGrid1.DataField := eField.Text;
      end;
end;

end.
