unit Main;

{Demonstration program to the TiffImg Component -
   CopyRight  1995
by :    Kent Phelps
        CommuniConsultants
        P.O. 440
        Conifer, CO 80433
        (303) 838-2089
        Compuserve 74020,1513}
 {permission is granted to extract relevent portions of this code to
 utilize the component}
 (* First Release 7/1/95  *)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, ImgImp, Spin,
  orderfrm, AboutDlg, ClipBrd, Menus, TIFFIMG, Gauges;
{ imgimp is the import library to use the DLL window in IMGDLL.DLL }


type
  Tmainform = class(TForm)
    OpenDialog1: TOpenDialog;
    btnfileopen: TButton;
    btnClose: TButton;
    ShowDatacheck: TCheckBox;
    SetFitWindow: TCheckBox;
    SetInvert: TCheckBox;
    btnrotate: TButton;
    btnFlipV: TButton;
    btnRotateimage180: TButton;
    btnDllWIndow: TButton;
    btnShowThumb: TButton;
    btnSaveAs: TButton;
    SaveDialog1: TSaveDialog;
    ImgNo1: TEdit;
    Label1: TLabel;
    SpinButton1: TSpinButton;
    Maximg: TEdit;
    Panel1: TPanel;
    btninvert: TSpeedButton;
    btnRotate90: TSpeedButton;
    btnRotate180: TSpeedButton;
    btnFlip: TSpeedButton;
    btnFitWindow: TSpeedButton;
    btnFlipH: TButton;
    btnCW: TButton;
    MainMenu1: TMainMenu;
    Files1: TMenuItem;
    open1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Help1: TMenuItem;
    Help: TMenuItem;
    About2: TMenuItem;
    Order1: TMenuItem;
    Image1: TMenuItem;
    FlipVertical1: TMenuItem;
    FlipHorizontal1: TMenuItem;
    RotateCCW1: TMenuItem;
    RotateCW1: TMenuItem;
    Invert1: TMenuItem;
    Invert2: TMenuItem;
    ShowTags1: TMenuItem;
    FitWindow1: TMenuItem;
    ScrollBox1: TScrollBox;
    Button1: TButton;
    Label2: TLabel;
    SpinScale: TSpinEdit;
    Gauge1: TGauge;
    LoadImage1: TLoadImage;
    LoadImage2: TLoadImage;
    procedure btnfileopenClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure SetFitWindowClick(Sender: TObject);
    procedure btnFlipVClick(Sender: TObject);
    procedure SetInvertClick(Sender: TObject);
    procedure btnrotateClick(Sender: TObject);
    procedure btnRotateimage180Click(Sender: TObject);
    procedure btnDllWIndowClick(Sender: TObject);
    procedure btnShowThumbClick(Sender: TObject);
    procedure LoadImage2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnSaveAsClick(Sender: TObject);
    procedure ShowDatacheckClick(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure btninvertClick(Sender: TObject);
    procedure btnRotate90Click(Sender: TObject);
    procedure btnRotate180Click(Sender: TObject);
    procedure btnFlipClick(Sender: TObject);
    procedure btnFitWindowClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure btnFlipHClick(Sender: TObject);
    procedure btnorderClick(Sender: TObject);
    procedure btnCWClick(Sender: TObject);
    procedure btnclipClick(Sender: TObject);
    procedure btngetclipClick(Sender: TObject);
    procedure open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure FlipVertical1Click(Sender: TObject);
    procedure FlipHorizontal1Click(Sender: TObject);
    procedure RotateCCW1Click(Sender: TObject);
    procedure RotateCW1Click(Sender: TObject);
    procedure Invert1Click(Sender: TObject);
    procedure Invert2Click(Sender: TObject);
    procedure FitWindow1Click(Sender: TObject);
    procedure ShowTags1Click(Sender: TObject);
    procedure About2Click(Sender: TObject);
    procedure Order1Click(Sender: TObject);
    procedure HelpClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpinScaleChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
{    LoadImage1: TLoadImage;
    LoadImage2: TLoadImage;}
  end;

var
  mainform: Tmainform;


implementation

{$R *.DFM}

procedure Tmainform.FormCreate(Sender: TObject);
begin
{ LoadImage1 := TLoadImage.Create(Self);
 Loadimage1.Parent := ScrollBox1;
 LoadImage1.SetScale :=8;
 LoadImage2 := TLoadImage.Create(Self);
 LoadImage2.ImageType:=TlThumb;
 Loadimage2.Parent := mainform;
 LoadImage2.SetScale :=12;
 LoadImage2.Top:=112;
 LoadImage2.Width:=90;
 LoadImage2.Left:=136;
 LoadImage2.Height:=150;
 }
 Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
 SpinScale.Value := LoadImage1.SetScale;
end;


procedure Tmainform.btnfileopenClick(Sender: TObject);
begin
{ first, set scrollbox dimensions in case we want to "Fit Window"}
 LoadImage1.ResetScrollerHeight := ScrollBox1.Height;
 LoadImage1.ResetScrollerWidth  := ScrollBox1.Width;
{ set fitwindow status - default is FALSE, but this makes sure it's set}
  if SetFitWindow.Checked=FALSE then
   LoadImage1.FitWindow:=FALSE
 else
  LoadImage1.FitWindow:=TRUE;
 {set image number - default is First Image}
 LoadImage1.ImageNumber:=StrToInt(ImgNo1.Text);
  if ShowDataCheck.Checked=TRUE then
    LoadImage1.ShowTiffSize:=TRUE
  else
    LoadImage1.ShowTiffSize:=FALSE;
with OpenDialog1 do
 if Execute then
  Begin
   LoadImage1.ImageFileName:=Filename;
  End;
{ get the image count and display }
  MaxImg.text:=IntToStr(LoadImage1.DCXImageCount+
               LoadImage1.GIFImageCount+
               LoadImage1.TIFFImageCount);
 Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
 end;

procedure Tmainform.btnCloseClick(Sender: TObject);
begin
 Close;
end;

procedure Tmainform.SetFitWindowClick(Sender: TObject);
begin
{ FitWindow means use all the vertical space and adjust the width for
  the correct aspect ratio}
 if SetFitWindow.Checked=FALSE then
   LoadImage1.FitWindow:=FALSE
 else
   LoadImage1.FitWindow:=TRUE;
end;

procedure Tmainform.btnFlipVClick(Sender: TObject);
begin
 {this is really a toggle - each time it's called it goes to the other state}
  LoadImage1.FlipV:=TRUE;
  Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;

procedure Tmainform.SetInvertClick(Sender: TObject);
begin
{this is really a toggle - each time it's called it goes to the other state}
   LoadImage1.Invert:=TRUE;
end;

procedure Tmainform.btnrotateClick(Sender: TObject);
begin
{each call to rotate90 rotates ANOTHER 90 degress: it does not set the
 image to a specific 90 degree position}
  LoadImage1.RotateCCW90:=TRUE;
 {we've changed image dimensions, so if a thumbnail is used, reset it}
  LoadImage2.ResetThumbNail:=TRUE;
  Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;

procedure Tmainform.btnRotateimage180Click(Sender: TObject);
begin
  {toggle}
  LoadImage1.Rotate180:=TRUE;
   {we've changed image dimensions, so if a thumbnail is used, reset it}
  LoadImage2.ResetThumbNail:=TRUE;
  Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;



procedure Tmainform.btnDllWindowClick(Sender: TObject);
var
 szFileName : Pchar;
begin
  Getmem(szFileName,63);
  StrPcopy(szFileName,OpenDialog1.Filename);
  {DLL DisplayImage Function needs a PChar}
  DisplayImage(handle,szFileName,'TIFF ImageComponent from CommuniConsultants',
           10,100,600,400);
  Freemem(szFileName,63);
  Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;

procedure Tmainform.btnShowThumbClick(Sender: TObject);
begin
 {load the thumbnail - pass scrollbox dimensions so the thumbnail
  will know how to size itself}
 LoadImage2.ResetScrollerHeight := ScrollBox1.Height;
 LoadImage2.ResetScrollerWidth  := ScrollBox1.Width;
 LoadImage2.SourceBitMap        := LoadImage1.SourceBitmap;
 Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;



procedure Tmainform.LoadImage2MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
{not meaningful if image is already fitted to window, so check}
if LoadImage1.FitWindow=FALSE then
begin
{this drives the pan feature}
 ScrollBox1.HorzScrollBar.Position:=LoadImage2.ImageXpos;
 ScrollBox1.VertScrollBar.Position:=LoadImage2.ImageYpos;
 end;
end;

procedure Tmainform.btnSaveAsClick(Sender: TObject);
begin
 with SaveDialog1 do
 if Execute then
  Begin
  {not enabled except in registered version}
   LoadImage1.SaveFileName:=Filename;
  End;
end;

procedure Tmainform.ShowDatacheckClick(Sender: TObject);
begin
{this function shows TIFF information in a dialog box before the
 image loads}
   if ShowDataCheck.Checked=TRUE then
    LoadImage1.ShowTiffSize:=TRUE
  else
    LoadImage1.ShowTiffSize:=FALSE;
end;

procedure Tmainform.SpinButton1DownClick(Sender: TObject);
var ImageNo : Integer;
begin
 {First Image is Image 0}
 ImageNo:=StrToInt(ImgNo1.text);
 if ImageNo=1 then
  Messagedlg('First Image',mtinformation,[mbok],0)
 else
 begin
 Dec(ImageNo);
 if ImageNo > 0 then
   ImgNo1.Text:=IntToStr(ImageNo)
  else ImgNo1.Text:='1';
  LoadImage1.ImageNumber:=ImageNo;
 {this calls the load routine which brings up the correct image,
  and we already have the correct file name}
 LoadImage1.ImageFileName:=LoadImage1.ImageFileName;
 end;
end;

procedure Tmainform.SpinButton1UpClick(Sender: TObject);
var ImageNo : Integer;
    MaxImgCount : Integer;
begin
 {First Image is Image 0}
 ImageNo:=StrToInt(ImgNo1.text);
 maxImgCount:=StrToInt(MaxImg.text);
 Inc(ImageNo);
 if ImageNo <= MaxImgCount then
 begin
   ImgNo1.Text:=IntToStr(ImageNo);
  LoadImage1.ImageNumber:=ImageNo;
  {this calls the load routine which brings up the correct image,
  and we already have the correct file name}
 LoadImage1.ImageFileName:=LoadImage1.ImageFileName;
 end
 else
  MessageDlg('Last Image',mtinformation,[mbok],0);
end;


procedure Tmainform.btninvertClick(Sender: TObject);
begin
 LoadImage1.Invert:=FALSE; {or TRUE...}
end;

procedure Tmainform.btnRotate90Click(Sender: TObject);
begin
 LoadImage1.RotateCCW90:=TRUE;
 LoadImage2.ResetThumbNail:=TRUE;
end;

procedure Tmainform.btnCWClick(Sender: TObject);
begin
 LoadImage1.RotateCW90:=TRUE;
 LoadImage2.ResetThumbNail:=TRUE;
 Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;

procedure Tmainform.btnRotate180Click(Sender: TObject);
begin
LoadImage1.Rotate180:=TRUE;
  LoadImage2.ResetThumbNail:=TRUE;
end;

procedure Tmainform.btnFlipClick(Sender: TObject);
begin
LoadImage1.FlipV:=TRUE;
end;

procedure Tmainform.btnFitWindowClick(Sender: TObject);
begin
  if LoadImage1.FitWindow=FALSE then
  begin
   LoadImage1.FitWindow:=TRUE;
  end
  else
  begin
   LoadImage1.FitWindow:=FALSE;
  end;
end;


procedure Tmainform.btnAboutClick(Sender: TObject);
begin
 About.Show;
end;

procedure Tmainform.btnFlipHClick(Sender: TObject);
begin
    LoadImage1.FlipH:=TRUE;
    Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;

procedure Tmainform.btnorderClick(Sender: TObject);
begin
 OrderForm.Show;
end;

procedure Tmainform.btnclipClick(Sender: TObject);
begin
  LoadImage1.CopyToClipBoard:=TRUE;
end;

procedure Tmainform.btngetclipClick(Sender: TObject);
begin
 LoadImage1.CopyFromClipBoard:=TRUE;
end;

procedure Tmainform.open1Click(Sender: TObject);
begin
 BtnFileOpenClick(Sender);
end;

procedure Tmainform.Save1Click(Sender: TObject);
begin
  BtnSaveAsClick(sender);
end;

procedure Tmainform.Exit1Click(Sender: TObject);
begin
 Close;
end;

procedure Tmainform.Copy1Click(Sender: TObject);
begin
  LoadImage1.CopyToClipBoard:=TRUE;
end;

procedure Tmainform.Paste1Click(Sender: TObject);
begin
 LoadImage1.CopyFromClipBoard:=TRUE;
end;

procedure Tmainform.FlipVertical1Click(Sender: TObject);
begin
 LoadImage1.FlipV:=TRUE;
end;

procedure Tmainform.FlipHorizontal1Click(Sender: TObject);
begin
  Loadimage1.FlipH:=TRUE;
end;

procedure Tmainform.RotateCCW1Click(Sender: TObject);
begin
 LoadImage1.RotateCCW90:=TRUE;
 LoadImage2.ResetThumbNail:=TRUE;
end;

procedure Tmainform.RotateCW1Click(Sender: TObject);
begin
 LoadImage1.RotateCW90:=TRUE;
 LoadImage2.ResetThumbNail:=TRUE;
end;

procedure Tmainform.Invert1Click(Sender: TObject);
begin
   LoadImage1.Rotate180:=TRUE;
   {we've changed image dimensions, so if a thumbnail is used, reset it}
  LoadImage2.ResetThumbNail:=TRUE;
end;

procedure Tmainform.Invert2Click(Sender: TObject);
begin
 LoadImage1.Invert:=TRUE;
end;

procedure Tmainform.FitWindow1Click(Sender: TObject);
begin
  LoadImage1.FitWindow:=TRUE;
end;

procedure Tmainform.ShowTags1Click(Sender: TObject);
begin
   LoadImage1.ShowTiffSize:=TRUE;
end;

procedure Tmainform.About2Click(Sender: TObject);
begin
  About.ShowModal;
end;

procedure Tmainform.Order1Click(Sender: TObject);
begin
 orderForm.Show;
end;

procedure Tmainform.HelpClick(Sender: TObject);
begin
  WinHelp(Handle,'TIFFIMG.HLP',HELP_INDEX,0);
end;

procedure Tmainform.FormResize(Sender: TObject);
begin
  If MainForm.WindowState <> wsNormal then
  begin
    Scrollbox1.Width:= (Width div 4) * 2;
    SCrollBox1.Height:= (Height div 8) * 7;
  end
  else
    ScrollBox1.Width := (Width div 8) * 3;
    ScrollBox1.Height := (Height div 8) * 5;
end;

procedure Tmainform.Button1Click(Sender: TObject);
begin
 LoadImage1.ImageFileName:='';
 {reset thumbnail also}
 LoadImage2.ResetThumbNail:=FALSE;
 Gauge1.progress := GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
end;

procedure Tmainform.SpinScaleChange(Sender: TObject);
begin
 {set thumbnail scale factor}
 LoadImage2.SetScale:= SpinScale.Value;
end;



end.
