unit Joycaps1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Joystick, MMSystem;

type
  TfrmJoyEx = class(TForm)
    Joystick1: TJoystick;
    lblNumJoysticks: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lblMID: TLabel;
    Label5: TLabel;
    lblProductName: TLabel;
    Label7: TLabel;
    lblNumButtons: TLabel;
    Label1: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Panel1: TPanel;
    lblXMin: TLabel;
    lblXMax: TLabel;
    lblXpos: TLabel;
    lblYmin: TLabel;
    lblYmax: TLabel;
    lblYpos: TLabel;
    lblZmin: TLabel;
    lblZmax: TLabel;
    lblZpos: TLabel;
    lblButton1: TLabel;
    lblButton2: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    lblButton3: TLabel;
    lblButton4: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    buEnable: TButton;
    Label8: TLabel;
    lblMinPeriod: TLabel;
    Label14: TLabel;
    lblMaxPeriod: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure Joystick1Move(Sender: TObject; Joystick, X, Y,
      Buttons: Word);
    procedure Joystick1ButtonPushed(Sender: TObject; Joystick,
      Buttons: Word);
    procedure Joystick1ButtonReleased(Sender: TObject; Joystick,
      Buttons: Word);
    procedure buEnableClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmJoyEx: TfrmJoyEx;

implementation

{$R *.DFM}

procedure TfrmJoyEx.FormActivate(Sender: TObject);
begin
  lblNumButtons.Caption   := IntToStr(Joystick1.NumButtons);
  lblProductName.Caption  := Joystick1.ProductName;
  lblNumJoysticks.Caption := IntToStr(Joystick1.NumJoysticks);
  lblMID.Caption          := IntToStr(JoyStick1.ManufacturerId);
  lblMinPeriod.Caption    := IntToStr(JoyStick1.PeriodMin);
  lblMaxPeriod.Caption    := IntToStr(JoyStick1.PeriodMax);

  lblXmin.Caption := 'Min: ' + IntToStr(Joystick1.Xmin);
  lblXmax.Caption := 'Max: ' + IntToStr(Joystick1.Xmax);
  lblXpos.Caption := 'Pos: ' + IntToStr(Joystick1.Xpos);

  lblYmin.Caption := 'Min: ' + IntToStr(Joystick1.Ymin);
  lblYmax.Caption := 'Max: ' + IntToStr(Joystick1.Ymax);
  lblYpos.Caption := 'Pos: ' + IntToStr(Joystick1.Ypos);

  lblZmin.Caption := 'Min: ' + IntToStr(Joystick1.Zmin);
  lblZmax.Caption := 'Max: ' + IntToStr(Joystick1.Zmax);
  lblZpos.Caption := 'Pos: ' + IntToStr(Joystick1.Zpos);

  lblButton1.Caption := 'False';
  lblButton2.Caption := 'False';
  lblButton3.Caption := 'False';
  lblButton4.Caption := 'False';
end;

procedure TfrmJoyEx.Joystick1Move(Sender: TObject; Joystick, X, Y,
  Buttons: Word);
begin
  If JoyStick1.Button1 then lblButton1.Caption := 'True' else lblButton1.Caption := 'False';
  If JoyStick1.Button2 then lblButton2.Caption := 'True' else lblButton2.Caption := 'False';
  If JoyStick1.Button3 then lblButton3.Caption := 'True' else lblButton3.Caption := 'False';
  If JoyStick1.Button4 then lblButton4.Caption := 'True' else lblButton4.Caption := 'False';
  lblXPos.Caption := 'Pos: ' + IntToStr(X);
  lblYPos.Caption := 'Pos: ' + IntToStr(Y);
end;

procedure TfrmJoyEx.Joystick1ButtonPushed(Sender: TObject; Joystick,
  Buttons: Word);
begin
{Method #1}
{
  If JoyStick1.Button1 then lblButton1.Caption := 'True' else lblButton1.Caption := 'False';
  If JoyStick1.Button2 then lblButton2.Caption := 'True' else lblButton2.Caption := 'False';
  If JoyStick1.Button3 then lblButton3.Caption := 'True' else lblButton3.Caption := 'False';
  If JoyStick1.Button4 then lblButton4.Caption := 'True' else lblButton4.Caption := 'False';
}

{Method #2}
  If Bool(Buttons and JOY_BUTTON1CHG) then lblButton1.Caption := 'True' else lblButton1.Caption := 'False';
  If Bool(Buttons and JOY_BUTTON2CHG) then lblButton2.Caption := 'True' else lblButton2.Caption := 'False';
  If Bool(Buttons and JOY_BUTTON3CHG) then lblButton3.Caption := 'True' else lblButton3.Caption := 'False';
  If Bool(Buttons and JOY_BUTTON4CHG) then lblButton4.Caption := 'True' else lblButton4.Caption := 'False';
end;

procedure TfrmJoyEx.Joystick1ButtonReleased(Sender: TObject; Joystick,
  Buttons: Word);
begin
  If JoyStick1.Button1 then lblButton1.Caption := 'True' else lblButton1.Caption := 'False';
  If JoyStick1.Button2 then lblButton2.Caption := 'True' else lblButton2.Caption := 'False';
  If JoyStick1.Button3 then lblButton3.Caption := 'True' else lblButton3.Caption := 'False';
  If JoyStick1.Button4 then lblButton4.Caption := 'True' else lblButton4.Caption := 'False';
end;

procedure TfrmJoyEx.buEnableClick(Sender: TObject);
begin
  Joystick1.Enabled := not Joystick1.Enabled;
  If Joystick1.Enabled then begin
    buEnable.Caption := 'Disable';
  end else begin                 
    buEnable.Caption := 'Enable';
  end;
end;

end.
