unit Mapisend;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TMAPISend = class(TComponent)
  private
  FFilePaths: String;  {File Paths of actual files to attach}
  FDelimChar: String;  {One Character Delimiter used between filenames}
  FFileNames: String;  {File Names to appear in message}
  { Private declarations }
  protected
    { Protected declarations }
  public
   function Execute: LongInt;
    { Public declarations }
  published
  property FileNames: String read FFileNames write FFileNames;
  property FilePaths: String read FFilePaths write FFilePaths;
  property Delimiter: String read FDelimChar write FDelimChar;
         { Published declarations }
  end;

procedure Register;

implementation

{Function declaration for the MAPISendDocuments routine from MAPI.DLL}

function MAPISendDocuments(UIParam: LongInt; DelimChar: PChar; FilePaths:
PChar; FileNames: PChar; Reserved: LongInt): LongInt; far; external 'MAPI';

procedure Register;
begin
  RegisterComponents('Samples', [TMAPISend]);
end;

function TMAPISend.Execute: LongInt;
var PFP: PChar;  {PChar for FilePaths}
  PDC: PChar;    {PChar for DelimChar}
  PFN: PChar;    {PChar for FileNames}
begin
{Allocate PChars}
PFP := strAlloc(250); PDC := strAlloc(2); PFN := strAlloc(250);
{Convert property string values to PChar}
StrPCopy(PFP,FFilePaths); StrPCopy(PDC,FDelimChar); StrPCopy(PFN,FFileNames);
{Call MAPISendDocuments}
Result := MAPISendDocuments(0,PDC,PFP,PFN,0);
{Dispose of PChars}
StrDispose(PFP); StrDispose(PDC); StrDispose(PFN);
end;

end.
