unit NWERROR;
{$I NWDEFINE.INC}

interface

const

  {USER SPECIFIC ERRORS}

  ALREADY_LOGGED_INTO_SERVER            = $200;   { 512 }


  SUCCESS_CODE                          = $0000;
  SUCCESSFUL                            = $0000;
  {The requester has filled in the reply packet}
  SHELL_ERROR                           = $8800;
  VLM_ERROR                             = $8800;
  ALREADY_ATTACHED                      = $8800;
  {Attach attempted to server with valid existing connection}
  INVALID_CONNECTION                    = $8801;
  {Request attempted with invalid or nonattached connection handle}
  DRIVE_IN_USE                          = $8802;
  {OS/2 only (NOT USED)}
  CANT_ADD_CDS                          = $8803;
  {Map drive attempted but unable to add new current directory structure}
  BAD_DRIVE_BASE                        = $8804;
  {Map drive attempted with invalid path specification}
  NET_READ_ERROR                        = $8805;
  {Attempt to receive from the selected transport failed}
  NET_RECV_ERROR                        = $8805;
  {Attempt to receive from the selected transport failed}
  UNKNOWN_NET_ERROR                     = $8806;
  {Network send attempted with a nonspecific network error}
  SERVER_INVALID_SLOT                   = $8807;
  {Server request attempted with invalid server connection slot}
  BAD_SERVER_SLOT 	                = $8807;
  {Server request attempted with invalid server connection slot}
  NO_SERVER_SLOTS                       = $8808;
  {Attach attempted to server with no connection slots available}
  NET_WRITE_ERROR                       = $8809;
  {Attempt to send on the selected transport failed}
  NET_SEND_ERROR 	                = $8809;
  {Attempt to send on the selected transport failed}
  SERVER_NO_ROUTE 	                = $880A;
  {Attempted to find route to server where no route exists}
  BAD_LOCAL_TARGET 	                = $880B;
  {OS/2 only}
  TOO_MANY_REQ_FRAGS 	                = $880C;
  {Attempted request with too many request fragments specified}
  CONNECT_LIST_OVERFLOW 	        = $880D;
  {Too many connections to fit in the list size specified}
  BUFFER_OVERFLOW 	                = $880E;
  {Attempt to receive more data than the reply buffer had room for}
  NO_CONN_TO_SERVER 	                = $880F;
  {Attempt to get connection for a server not connected}
  NO_CONNECTION_TO_SERVER 	        = $880F;
  {Attempt to get connection for a server not connected}
  NO_ROUTER_FOUND 	                = $8810;
  {OS/2 only}
  BAD_FUNC_ERROR 	                = $8811;
  {Attempted function to non-existent or illegal function}
  INVALID_SHELL_CALL 	                = $8811;
  {Attempted function to non-existent or illegal function}
  NOT_SAME_CONNECTION 	                = $8830;
  {Internal server request attempted accross different server connections}
  PRIMARY_CONNECTION_NOT_SET 	        = $8831;
  {Attempt to retrieve default connection with no primary connection set}
  NO_PRIMARY_SET 	                = $8831;
  {Attempt to retrieve default connection with no primary connection set}
  NO_CAPTURE_SET 	                = $8832;
  {Capture information requested on port with no capture in progress}
  NO_CAPTURE_IN_PROGRESS 	        = $8832;
  {Capture information requested on port with no capture in progress}
  BAD_BUFFER_LENGTH 	                = $8833;
  {len requested on a GetDNC or SetDNC was too large.}
  INVALID_BUFFER_LENGTH 	        = $8833;
  {len requested on a GetDNC or SetDNC was too large.}
  NO_USER_NAME                          = $8834;
  NO_NETWARE_PRINT_SPOOLER 	        = $8835;
  {Capture requested without local print spooler installed.}
  INVALID_PARAMETER 	                = $8836;
  {Attempted function with invalid function parameter specified.}
  CONFIG_FILE_OPEN_FAILED 	        = $8837;
  {OS/2 only.}
  NO_CONFIG_FILE 	                = $8838;
  {OS/2 only.}
  CONFIG_FILE_READ_FAILED 	        = $8839;
  {OS/2 only.}
  CONFIG_LINE_TOO_LONG 	                = $883A;
  {OS/2 only.}
  CONFIG_LINES_IGNORED 	                = $883B;
  {OS/2 only.}
  NOT_MY_RESOURCE 	                = $883C;
  {Attempted request made with a parameter using foreign resource.}
  DAEMON_INSTALLED 	                = $883D;
  {OS/2 only.}
  SPOOLER_INSTALLED 	                = $883E;
  {Attempted load of print spooler with print spooler already installed.}
  CONN_TABLE_FULL 	                = $883F;
  {Tried to alloc a connection handle with no more local connection table entries.}
  CONNECTION_TABLE_FULL 	        = $883F;
  {Tried to alloc a connection handle with no more local connection table entries.}
  CONFIG_SECTION_NOT_FOUND 	        = $8840;
  {OS/2 only.}
  BAD_TRAN_TYPE 	                = $8841;
  {Attempted function on a connection with an invalid transport selected.}
  INVALID_TRANSPORT_TYPE 	        = $8841;
  {Attempted function on a connection with an invalid transport selected.}
  TDS_TAG_IN_USE	                = $8841;
  {OS/2 only.}
  TDS_OUT_OF_MEMORY 	                = $8843;
  {OS/2 only.}
  TDS_INVALID_TAG 	                = $8844;
  {Attempted TDS function with invalid tag.}
  TDS_WRITE_TRUNCATED 	                = $8845;
  {Attempted TDS write with buffer that exceeded buffer.}
  NO_DIRECTORY_SERVICE_CONNECTION       = $8846;
  SERVICE_BUSY 	= $8846;
  {Attempted request to a busy, partially asynchronous function.}
  NO_SERVER_ERROR 	                = $8847;
  {Attempted connect failed to find any servers responding.}
  BAD_VLM_ERROR 	                = $8848;
  {Attempted function to nonexistent or not-loaded overlay.}
  NETWORK_DRIVE_IN_USE 	                = $8849;
  {Attempted map to network drive already mapped.}
  LOCAL_DRIVE_IN_USE 	                = $884A;
  {Attempted map to local drive already in use.}
  NO_DRIVES_AVAILABLE 	                = $884B;
  {Attempted map to next available drive when none available.}
  DEVICE_NOT_REDIRECTED 	        = $884C;
  {The device is not redirected.}
  NO_MORE_SFT_ENTRIES 	                = $884D;
  {Maximum number of files was reached.}
  UNLOAD_ERROR 	                        = $884E;
  {Attempted unload failed.}
  IN_USE_ERROR 	                        = $884F;
  {Attempted re-use of already in use connection entry.}
  TOO_MANY_REP_FRAGS 	                = $8850;
  {Attempted request with too many reply fragments specified.}
  TABLE_FULL 	                        = $8851;
  {Attempted to add a name into the name table after it was full.}
  SOCKET_NOT_OPEN 	                = $8852;
  {Listen was posted on unopened socket.}
  MEM_MGR_ERROR 	                = $8853;
  {Attempted enhanced memory operation failed.}
  SFT3_ERROR 	                        = $8854;
  {An SFT III switch occured mid-transfer.}
  PREFERRED_NOT_FOUND 	                = $8855;
  {Preferred directory server not established, but another directory server was returned.}
  DEVICE_NOT_RECOGNIZED 	        = $8856;
  {Determine if the device is not used by VLM application; pass to next redirector, if any.}
  BAD_NET_TYPE 	                        = $8857;
  {The network type (Bindery or Directory Services) does not match the server version.}
  ERROR_OPENING_FILE 	                = $8858;
  {Generic open failure error, invalid path, access denied, etc.}
  NO_PREFERRED_SPECIFIED 	        = $8859;
  {No preferred name specified.}
  ERROR_OPENING_SOCKET 	                = $885A;
  {Error opening a socket.}
  SHELL_FAILURE 	                = $88FF;
  {Either an unknown error, or the shell is not present.}
  VLM_FAILURE 	                        = $88FF;
  {Either an unknown error, or the VLM is not present.}

 ERR_INSUFFICIENT_SPACE                 = $8901;
 ERR_BUFFER_TOO_SMALL                   = $8977;
 ERR_VOLUME_FLAG_NOT_SET                = $8978;
 {The service requested is not available on the selected volume.}
 ERR_NO_ITEMS_FOUND                     = $8979;
 ERR_CONN_ALREADY_TEMP                  = $8971;
 ERR_CONN_ALREADY_LOGGED_IN             = $897B;
 ERR_CONN_NOT_AUTHENTICATED             = $897C;
 ERR_CONN_NOT_LOGGED_IN                 = $897D;
 NCP_BOUNDARY_CHECK_FAILED              = $897E;
 ERR_LOCK_WAITING                       = $897E;
 ERR_LOCK_FAIL                          = $8980;
 FILE_IN_USE_ERROR                      = $8980;
 {Attempt to open or create a file already open.}
 NO_MORE_FILE_HANDLES                   = $8981;
 {No more file handles available; the network file handle table is full.}
 NO_OPEN_PRIVILEGES                     = $8982;
 {Attempt to open a file without the open privilege.}
 IO_ERROR_NETWORK_DISK                  = $8983;
 {Hard disk input/output error on a NetWare volume; a bad sector has been encountered and could be fatal.}
 NO_CREATE_PRIVILEGES                   = $8984;
 {Attempt to create a file without the create privilege.}
 NO_CREATE_DELETE_PRIVILEGES            = $8985;
 {Attempt to create an already existing file without the create/delete privileges.}
 CREATE_FILE_EXISTS_READ_ONLY           = $8986;
 {Attempt to create a file with the same name as an already existing file with read-only status.}
 WILD_CARDS_IN_CREATE_FILE_NAME         = $8987;
 {Attempt to create a file using an ambiguous filename.}
 INVALID_FILE_HANDLE                    = $8988;
 {Attempt to close or perform I/O on a file with an invalid file handle i.e. trying to read from a file that has been closed}
 NO_SEARCH_PRIVILEGES                   = $8989;
 {Attempt to search a directory without search privileges in that directory.}
 NO_DELETE_PRIVILEGES                   = $898A;
 {Attempt to delete a file without file deletion privileges in that file's directory.}
 NO_RENAME_PRIVILEGES                   = $898B;
 {Attempt to rename a file without renaming privileges in that file's directory.}
 NO_MODIFY_PRIVILEGES                   = $898C;
 {Attempt to modify a file without attribute modification privileges in that file's directory.}
 SOME_FILES_AFFECTED_IN_USE             = $898D;
 {Attempt to delete, rename, or set file attributes using an ambiguous filename
  while some of the files specified by the filename are in use by another workstation.}
 NO_FILES_AFFECTED_IN_USE               = $898E;
 {Attempt to delete, rename, or set file attributes using an ambiguous filename
  while some of the files specified by the filename are in use by another workstation.}
 SOME_FILES_AFFECTED_READ_ONLY          = $898F;
 {Attempt to delete, rename, or set file attributes using a filename when some of
  the files specified have read-only status.}
 NO_FILES_AFFECTED_READ_ONLY            = $8990;
 {Attempt to delete, rename, or set file attributes using a filename when all of
  the files specified have read-only status.}
 SOME_FILES_RENAMED_NAME_EXISTS         = $8991;
 {Attempt to rename files using an ambiguous filename, when one or more files
  matching the new filename specification already exist.}
 NO_FILES_RENAMED_NAME_EXISTS           = $8992;
 {Attempt to rename a file using a filename, when all of the files matching the new filename specification already exist.}
 NO_READ_PRIVILEGES                     = $8993;
 {Attempt to read a file without read privileges to that file.}
 NO_WRITE_PRIVILEGES_OR_READONLY        = $8994;
 {Attempt to write to a file without write privileges to that file, or if the specified file has read-only status.}
 FILE_DETACHED                          = $8995;
 {Attempt to read or write to a detached file.}
 SERVER_OUT_OF_MEMORY                   = $8996;
 {Attempt to write to file server which does not currently have enough free dynamic memory to process this request.}
 ERR_TARGET_NOT_A_SUBDIRECTORY          = $8996;
 NO_DISK_SPACE_FOR_SPOOL_FILE           = $8997;
 {The network operating system has determined that the network disk doesn't have enough space left for spool files.}
 VOLUME_DOES_NOT_EXIST                  = $8998;
 {The network operating system has tried to access a volume but cannot find the volume in the system definition files.}
 DIRECTORY_FULL                         = $8999;
 RENAMING_ACROSS_VOLUMES                = $899A;
 {Attempt to rename across volumes; attempt to rename a file and move the renamed
  file from its current volume into another volume. The rename command may move
  the file between directories on the same volume; however, using rename to move a file between volumes is not allowed.}
 BAD_DIRECTORY_HANDLE                   = $899B;
 {Attempt to use an invalid directory handle. This occurs if the network has been
  brought down and brought back up without rebooting the workstation.}
 INVALID_PATH                           = $899C;
 NO_MORE_TRUSTEES                       = $899C;
 {No more trustees are listed in the directory.}
 NO_MORE_DIRECTORY_HANDLES              = $899D;
 {No more directory handles available; the directory handle table is full. Each user may have up to 255 directory handles.}
 INVALID_FILENAME                       = $899E;
 {Attempt to create a file using invalid characters within the name of the file.}
 DIRECTORY_ACTIVE                       = $899F;
 {Attempt to delete a directory that is being used by another workstation.}
 DIRECTORY_NOT_EMPTY                    = $89A0;
 DIRECTORY_IO_ERROR                     = $89A1;
 {A nonrecoverable I/O error has occurred on the disk in the directory area. This
  error has occurred in both copies of the directory and is fatal.}
 READ_FILE_WITH_RECORD_LOCKED           = $89A2;
 {Attempt to read a file where data is physically locked.}
 ERR_TRANSACTION_RESTARTED              = $89A3;
 ERR_RENAME_DIR_INVALID                 = $89A4;
 ERR_INVALID_OPENCREATE_MODE            = $89A5;
 ERR_ALREADY_IN_USE                     = $89A6;
 ERR_INVALID_RESOURCE_TAG               = $89A7;
 ERR_ACCESS_DENIED                      = $89A8;
 INVALID_DATA_STREAM                    = $89BE;
 INVALID_NAME_SPACE                     = $89BF;
 NO_ACCOUNTING_PRIVILEGES               = $89C0;
 LOGIN_DENIED_NO_ACCOUNT_BALANCE        = $89C1;
 {Attempt to log in by a bindery object without an accounting balance, and accounting is enabled.}
 LOGIN_DENIED_NO_CREDIT                 = $89C2;
 {Attempt to log in to account with no credit available.}
 ERR_TOO_MANY_HOLDS                     = $89C3;
 ACCOUNTING_DISABLED                    = $89C4;
 INTRUDER_DETECTION_LOCK                = $89C5;
 {Attempt to log in after the system had locked the account because of intruder detection.}
 NO_CONSOLE_OPERATOR                    = $89C6;
 {Attempt to use console without operator privileges.}
 NO_CONSOLE_PRIVILEGES                  = $89C6;
 ERR_Q_IO_FAILURE                       = $89D0;
 ERR_NO_QUEUE                           = $89D1;
 ERR_NO_Q_SERVER                        = $89D2;
 ERR_NO_Q_RIGHTS                        = $89D3;
 ERR_Q_FULL                             = $89D4;
 ERR_NO_Q_JOB                           = $89D5;
 ERR_NO_Q_JOB_RIGHTS                    = $89D6;
 ERR_Q_IN_SERVICE                       = $89D7;
 PASSWORD_NOT_UNIQUE                    = $89D7;
 {Attempt to change password to a previously used password when the unique requirement is specified for the account.}
 ERR_Q_NOT_ACTIVE                       = $89D8;
 PASSWORD_TOO_SHORT                     = $89D8;
 {Attempt to change password to a password with fewer characters than the required minimum specified for the account.}
 ERR_Q_STN_NOT_SERVER                   = $89D9;
 LOGIN_DENIED_NO_CONNECTION             = $89D9;
 {Attempt to log in using an account which has limits on the number of concurrent
  connections and that number has been reached.}
 ERR_MAXIMUM_LOGINS_EXCEEDED            = $89D9;
 ERR_Q_HALTED                           = $89DA;
 UNAUTHORIZED_LOGIN_TIME                = $89DA;
 UNAUTHORIZED_LOGIN_STATION             = $89DB;
 {Attempt to log in from an unauthorized station using an account with limits to a specific network and/or station.}
 ERR_Q_MAX_SERVERS                      = $89DB;
 ACCOUNT_DISABLED                       = $89DC;
 {Attempt to log in using an account which has expired or has been disabled by the Supervisor.}
 TALLY_CORRUPT                          = $89DD;
 PASSWORD_HAS_EXPIRED_NO_GRACE          = $89DE;
 {Attempt to log in using an account password which has expired and all grace logins have also expired.}
 PASSWORD_HAS_EXPIRED                   = $89DF;
 {Attempt to log in using an expired account password but the login was allowed because the account had a grace login.}
 E_NO_MORE_USERS                        = $89E7;
 NOT_ITEM_PROPERTY                      = $89E8;
 {Attempt to use an item not associated with this property group or an item which has been deleted from this group.}
 WRITE_PROPERTY_TO_GROUP                = $89E8;
 {Attempt to write a data segment to a group property using the call to write a property value.}
 MEMBER_ALREADY_EXISTS                  = $89E9;
 {Attempt to redundantly add an object to a group property.}
 NO_SUCH_MEMBER                         = $89EA;
 NOT_GROUP_PROPERTY                     = $89EB;
 {Attempt to use a non-group property.}
 NO_SUCH_SEGMENT                        = $89EC;
 {Attempt to use a nonexistent segment. Note that segments must be written
  sequentially when a property is first created, but may be read and written in any order after they already exist.}
 PROPERTY_ALREADY_EXISTS                = $89ED;
 OBJECT_ALREADY_EXISTS                  = $89EE;
 INVALID_NAME                           = $89EF;
 {Request made with an object or property name containing illegal characters.
  Illegal characters in names are control characters, the comma, colon, semicolon,
  slash, backslash, question mark, asterisk, and tilde.}
 WILD_CARD_NOT_ALLOWED                  = $89F0;
 {Attempt to use a wildcard character or wild object type in a call where wildcards are not allowed.}
 INVALID_BINDERY_SECURITY               = $89F1;
 {Attempt to assign a security level of a bindery object or property to be higher
  than the user's security level. This would make the object or property inaccessible to the user.}
 NO_OBJECT_READ_PRIVILEGE               = $89F2;
 {Attempt to access object information or scan the object's properties by a station
  without the necessary security to access this information.}
 NO_OBJECT_RENAME_PRIVILEGE             = $89F3;
 {Attempt to rename an object without the necessary security. Only the Supervisor
  can rename objects. Note that if the station does not have the proper security
  to see that the object exists, then NCP_NO_SUCH_OBJECT is returned.}
 NO_OBJECT_DELETE_PRIVILEGE             = $89F4;
 {Attempt to delete an object by a station without the necessary security to delete
  the object. Only the Supervisor can delete objects. Note that if the station does
  not even have the proper security to see that the object exists, then NCP_NO_SUCH_OBJECT is returned.}
 NO_OBJECT_CREATE_PRIVILEGE             = $89F5;
 {Attempt to create an object by a station without the necessary security to create
  or change an object. Only Supervisors are allowed to create objects.}
 NO_PROPERTY_DELETE_PRIVILEGE           = $89F6;
 {Attempt to delete a property by a station without the necessary security privilege
  to delete a property from the give object. Note that if the station does not
  have the proper security to see that the property exists, then NCP_NO_SUCH_PROPERTY is returned.}
 NOT_SAME_LOCAL_DRIVE                   = $89F6;
 NO_PROPERTY_CREATE_PRIVILEGE           = $89F7;
 {Attempt to create a property by a station without the necessary security to create or change a property for the object.}
 TARGET_DRIVE_NOT_LOCAL                 = $89F7;
 NO_PROPERTY_WRITE_PRIVILEGE            = $89F8;
 {Attempt to write by a station without the necessary write security to change the property data.}
 ALREADY_ATTACHED_TO_SERVER             = $89F8;
 NOT_ATTACHED_TO_SERVER                 = $89F8;
 NO_FREE_CONNECTION_SLOTS               = $89F9;
 NO_PROPERTY_READ_PRIVILEGE             = $89F9;
 {Attempt to read by a station without the necessary read security to access the property data.}
 NO_MORE_SERVER_SLOTS                   = $89FA;
 TEMP_REMAP_ERROR                       = $89FA;
 {Attempt to use an unknown path.}
 INVALID_PARAMETERS                     = $89FB;
 {Attempt to use an invalid parameter (drive number, path, or flag value) during a set drive path call.}
 NO_SUCH_PROPERTY                       = $89FB;
 INTERNET_PACKET_REQT_CANCELED          = $89FC;
 UNKNOWN_FILE_SERVER                    = $89FC;
 {Attempt to attach to a server using an invalid server name.}
 MESSAGE_QUEUE_FULL                     = $89FC;
 NO_SUCH_OBJECT                         = $89FC;
 {Attempt to use an object which doesn't exist, or the calling station doesn't
  have the proper security to access the object. Note that the object name and
  type must both match for the object to be found.}
 LOCK_COLLISION                         = $89FD;
 BAD_STATION_NUMBER                     = $89FD;
 {Attempt to use a bad (undefined, unavailable, etc.) station number.}
 INVALID_PACKET_LENGTH                  = $89FD;
 {The requesting packet did not have a 30 byte packet header as the first fragment,
  or its total length exceeded 576 characters.}
 UNKNOWN_REQUEST                        = $89FD;
 BINDERY_LOCKED                         = $89FE;
 {Attempt to use a bindery which is temporarily locked by the Supervisor.}
 TRUSTEE_NOT_FOUND                      = $89FE;
 DIRECTORY_LOCKED                       = $89FE;
 INVALID_SEMAPHORE_NAME_LENGTH          = $89FE;
 {Attempt to open a semaphore with an invalid semaphore name length. Semaphores
  use strings that are from 1 to 127 bytes long.}
 PACKET_NOT_DELIVERABLE                 = $89FE;
 {Currently unable to deliver packet for any of the following possible reasons:
 (1) The destination node is on another network, and no router could be found with a path to the destination network, or
 (2) the destination node address is on the local network, and hardware detects
     that the destination node address is nonexistent or inactive, or
 (3) the destination node is the same machine as the source node, and there is no pending list}
 SERVER_BINDERY_LOCKED                  = $89FE;
 SOCKET_TABLE_FULL                      = $89FE;
 {Attempt to open a socket when the socket table already has 50 entries marked as open.}
 SPOOL_DIRECTORY_ERROR                  = $89FE;
 SUPERVISOR_HAS_DISABLED_LOGIN          = $89FE;
 {Attempt to log in when the Supervisor has disabled logins from the console or the bindery was locked.}
 TIMEOUT_FAILURE                        = $89FE;
 {Failure caused by the timeout limit  expiring before the request was fulfilled.}
 BAD_PRINTER_ERROR                      = $89FF;
 {Attempt to use a bad (undefined, unavailable, etc.) printer.}
 BAD_RECORD_OFFSET                      = $89FF;
 {Attempt to use an invalid offset value during physical locking calls.}
 CLOSE_FCB_ERROR                        = $89FF;
 {Error closing file.}
 FILE_EXTENSION_ERROR                   = $89FF;
 {Attempt to use file with a bad (undefined, unavailable, etc.) extension.}
 FILE_NAME_ERROR                        = $89FF;
 {Attempt to use file with a bad (undefined, unavailable, etc.) name.}
 HARDWARE_FAILURE                       = $89FF;
 INVALID_DRIVE_NUMBER                   = $89FF;
 DOS_INVALID_DRIVE                      = $89FF;
 {Attempt to use an invalid (undefined, unavailable, etc.) drive.}
 INVALID_INITIAL_SEMAPHORE_VALUE        = $89FF;
 {Attempt to open a semaphore with an invalid semaphore value. The semaphore value
  must be positive, and must be initialized to a value from 0 to 127.}
 INVALID_SEMAPHORE_HANDLE               = $89FF;
 {Attempt to examine, wait, or signal a semaphore with an invalid semaphore handle.
  The semaphore handle is obtained through the open a semaphore call.}
 IO_BOUND_ERROR                         = $89FF;
 {Attempt to write beyond the end of file or disk.}
 NO_FILES_FOUND_ERROR                   = $89FF;
 {No files were found that matched the search specification.}
 NO_RESPONSE_FROM_SERVER                = $89FF;
 NO_SUCH_OBJECT_OR_BAD_PASSWORD         = $89FF;
 {Attempt to use an unfound object, or attempt to use a bad (undefined, unavailable, etc.)
  password. On a login call, this indicates the password was correct,
  but it has expired and all grace logins have been used up. On a change password call,
  it indicates that the old password given was correct, but the account is not allowed
  to change the password (typical of the GUEST account).}
 PATH_NOT_LOCATABLE                     = $89FF;
 {Attempt to find an unknown path during a get full path call.}
 QUEUE_FULL_ERROR                       = $89FF;
 {Attempt to use a queue with 99 entries in it (99 is the maximum number of entries that can be placed in each print queue).}
 REQUEST_NOT_OUTSTANDING                = $89FF;
 SOCKET_ALREADY_OPEN                    = $89FF;
 {Attempt to redundantly open a socket whose specified socket number is already open.}
 LOCK_ERROR                             = $89FF;
 {Attempt to use a locked file.}

implementation

end.