unit nwtypes;
{$I NWDEFINE.INC}

interface

type

  PByte    = ^byte;
  PWord    = ^word;
  PLongint = ^longint;

  TByte3   = array [0 .. 2] of byte;
  TByte4   = array [0 .. 3] of byte;
  PByte6   = ^TByte6;
  TByte6   = array [0 .. 5] of byte;
  PByte7   = ^TByte7;
  TByte7   = array [0 .. 6] of byte;
  TByte8   = array [0 .. 7] of byte;
  TByte9   = array [0 .. 8] of byte;
  TByte12  = array [0 .. 11] of byte;
  PByte14  = ^TByte14;
  TByte14  = array [0 .. 13] of byte;
  PByte16  = ^TByte16;
  TByte16  = array [0 .. 15] of byte;
  TByte28  = array [0 .. 27] of byte;
  TByte36  = array [0 .. 35] of byte;
  TByte42  = array [0 .. 41] of byte;
  TByte44  = array [0 .. 43] of byte;
  TByte48  = array [0 .. 47] of byte;
  TByte64  = array [0 .. 63] of byte;
  TByte127 = array [0 .. 126] of byte;
  TByte152 = array [0 .. 151] of byte;
  PByte512 = ^TByte512;
  TByte512 = array [0 .. 511] of byte;

  PWord25    = ^TWord25;
  TWord25    = array [0 .. 24] of word;
  PWord50    = ^TWord50;
  TWord50    = array [0 .. 49] of word;

  TLongint2   = array [0 .. 1] of longint; 
  PLongint25  = ^TLongint25;
  TLongint25  = array [0 .. 24] of longint;
  TLongint250 = array [0 .. 249] of longint;

  TChar14    = array [0 .. 13] of char;
  TChar16    = array [0 .. 15] of char;
  TChar48    = array [0 .. 47] of char;
  TChar50    = array [0 .. 49] of char;
  TChar80    = array [0 .. 79] of char;
  TChar127   = array [0 .. 126] of char;
  TChar260   = array [0 .. 259] of char;

  TString4   = string [4];
  TString8   = string [8];
  TString10  = string [10];
  TString12  = string [12];
  TString15  = string [15];
  TString16  = string [16];
  TString40  = string [40];
  TString48  = string [48];
  TString58  = string [58];
  TString127 = string [127];
  TString255 = string [255];

  PAcctBalance        = ^TAcctBalance;
  TAcctBalance        = longint;
  PAcctLimit          = ^TAcctLimit;
  TAcctLimit          = longint;
  PBroadcastMode      = ^TBroadcastMode;
  TBroadcastMode      = word;
  TChargeAmount       = longint;
  PConsoleMessage     = ^TConsoleMessage;
  TConsoleMessage     = TString58;
  TDirNum             = word;
  PDriveNum           = ^TDriveNum;
  TDriveNum           = word;
  TFullName           = TString127;
  PHoldAmount         = ^THoldAmount;
  THoldAmount         = longint;
  THoldCancelAmount   = longint;
  TLocalMode          = word;
  PLocalScope         = ^TLocalScope;
  TLocalScope         = word;
  TMessage            = TString255;
  TNetwarePassword    = TString127;
  TNote               = TString255;
  TNoteType           = word;
  PNumBlocks          = ^TNumBlocks;
  TNumBlocks          = longint;
  PNWAccessRights     = ^TNWAccessRights;
  TNWAccessRights     = byte;
  TNWChangeBits       = longint;
  PNWConnNum          = ^TNWConnNum;
  TNWConnNum          = word;
  TNWConnNumLong      = longint;
  PNWDateTime         = ^TNWDateTime;
  TNWDateTime         = longint;
  PNWDirHandle        = ^TNWDirHandle;
  TNWDirHandle        = byte;
  TNWDirVol           = byte;
  PNWDiskSpace        = ^TNWDiskSpace;
  TNWDiskSpace        = longint;
  PNWFileAttr         = ^TNWFileAttr;
  TNWFileAttr         = byte;
  PNWFileHandle       = ^TNWFileHandle;
  TNWFileHandle       = word;
  PNWFlags            = ^TNWFlags;
  TNWFlags            = byte;
  PNWLastRecord       = ^TNWLastRecord;
  TNWLastRecord       = integer; 
  TNWLen              = word;
  TNWLocalFileHandle  = word;
  TNWLogicalRecordName= TString127;
  PNWNum              = ^TNWNum;
  TNWNum              = longint;
  PNWNumber           = ^TNWNumber;
  TNWNumber           = word;
  PNWNumEntries       = ^TNWNumEntries;
  TNWNumEntries       = longint; {TAC}
  PNWObjectID         = ^TNWObjectID;
  TNWObjectID         = longint;
  TNWOffset           = longint;
  TNWSearchAttr       = byte;
  PNWSearchAttributes = ^TNWSearchAttributes;
  TNWSearchAttributes = word;
  PNWSeqNum           = ^TNWSeqNum;
  TNWSeqNum           = longint;
  PNWSequence         = ^TNWSequence;
  TNWSequence         = longint;
  PNWSize             = ^TNWSize;
  TNWSize             = longint;
  PNWStatus           = ^TNWStatus;
  TNWStatus           = longint;
  TNWTicks            = word;
  PNWVolFlags         = ^TNWVolFlags;
  TNWVolFlags         = word;
  PNWVolNum           = ^TNWVolNum;
  TNWVolNum           = word;
  TNWVolNumber        = byte;
  TNWVolumeName       = TString16;
  PConnList           = ^TConnList;
  TConnList           = array [0 .. 124] of TNWConnNumLong;
  TObjectName         = TString48;
  PObjectType         = ^TObjectType;
  TObjectType         = word;
  POpenCount          = ^TOpenCount;
  TOpenCount          = word;
  TPath               = TString255;
  TPathFormat         = (NW_FORMAT_NETWARE, NW_FORMAT_SERVER_VOLUME,
                         NW_FORMAT_DRIVE, NW_FORMAT_UNC);
  TPropertyName       = TString15;
  PRequesterVersion   = ^TRequesterVersion;
  TRequesterVersion   = byte;
  PRightsMask         = ^TRightsMask;
  TRightsMask         = word;
  PSegmentData        = ^TSegmentData;
  TSegmentData        = TByte127;
  PSegmentNum         = ^TSegmentNum;
  TSegmentNum         = byte;
  TSemaphoreName      = TString127;
  PSemHandle          = ^TSemHandle;
  TSemHandle          = longint;
  PSemInt             = ^TSemInt;
  TSemInt             = integer;
  PSequenceNum        = ^TSequenceNum;
  TSequenceNum        = longint;
  PStatusRecord       = ^TStatusRecord;
  TStatusRecord       = TByte64;
  TStructSize         = word;
  PSysTime            = ^TSysTime;
  TSysTime            = longint;
  TTicks              = word;
  PTrusteeSequenceNum = ^TTrusteeSequenceNum;
  TTrusteeSequenceNum = word;
  TVolumeName         = TString16;

const

  _NETX_COM           = $0001;
  _NETX_VLM           = $0002;
  _REDIR_LOADED       = $4000;
  _VLM_LOADED         = $8000;

type
  {** Accounting Services **}
  THoldsInfo   = record
                   ObjectID   : TNWObjectID;
                   Amount     : longint;
                 end;

  PHoldsStatus = ^THoldsStatus;
  THoldsStatus = record
                   HoldsCount : WORD;
                   Holds      : array [0 .. 15] of THoldsInfo;
                 end;

const
  {** Bindery security access byte definitions **}

  BS_AnyRead              = $0000;
  { Readable by anyone }
  BS_LoggedRead           = $0001;
  { Must be logged in to read }
  BS_ObjectRead           = $0002;
  { Readable by the object only }
  BS_SuperRead            = $0003;
  { Readable by Supervisor only }
  BS_BinderyRead          = $0004;
  { Readable by Bindery only }
  BS_AnyWrite             = $0000;
  { Writeable by anyone }
  BS_LoggedWrite          = $0010;
  { Must be logged in to write }
  BS_ObjectWrite          = $0020;
  { Writeable by the object only }
  BS_SuperWrite           = $0030;
  { Writeable by Supervisor only }
  BS_BinderyWrite         = $0040;
  { Writeable by Bindery only }

  {** Access rights definitions for 286-based Netware **}

  TA_None                 = $0000;
  { Trustee has no rights in directory }
  TA_Read                 = $0001;
  { Trustee can read from file that is open }
  TA_Write                = $0002;
  { Trustee can write to a file that is open }
  TA_Open                 = $0004;
  { Trustee can open an existing file }
  TA_Create               = $0008;
  { Trustee can create a new file }
  TA_Delete               = $0010;
  { Trustee can delete files }
  TA_Ownership            = $0020;
  { Trustee can create subdirectories and modify trustee rights }
  TA_Search               = $0040;
  { Trustee can view the names of non-hidden files }
  TA_Modify               = $0080;
  { Trustee can modify the file attributes }
  TA_All                  = $00FF;
  { Trustee has all of the above rights }

  {*** Access rights definitions for 386-based Netware ***}

  TR_None                 = $0000;
  { Trustee has no rights in directory }
  TR_Read                 = $0001;
  { For a directory, the trustee can open and read existing files in this
    directory unless blocked by mask or trustee rights assignments.  For a
    file the trustee can open and read this file }
  TR_Write                = $0002;
  { For a directory, the trustee can open and write existing files in this
    directory unless blocked by mask or trustee rights assignments.  For a
    file the trustee can open and write this file}
  TR_Undefined            = $0004;
  { UNDEFINED }
  TR_Create               = $0008;
  { For a directory, the trustee can create files and subdirectories in this
    directory.  For a file, the trustee can salvage this file if deleted. }
  TR_Erase                = $0010;
  { For a directory, the trustee can delete this directory if the trustee has
    rights to delete everything inside it.  For a file, the trustee can delete
    this file. }
  TR_Access               = $0020;
  { For a directory, the trustee can modify the trustee list and inherited
    rights mask of this directory.  For a file, the trustee can modify the
    trustee list and inherited rights mask of this file. }
  TR_File                 = $0040;
  { For a directory, the trustee can see the names of files in this directory
    when scanning it (unless blocked by mask or trustee rights assignments).
    For a file, the trustee can see the name of this file when scanning the
    directory. }
  TR_Modify               = $0080;
  { For a directory, the trustee can rename this directory and change its
    attributes.  For a file, the trustee can rename this file and change its
    attributes. }
  TR_Normal               = $00FF;
  { This attribute grants all rights except TR_Supervisor }
  TR_Supervisor           = $0100;
  { For a directory, the trustee has all rights to this directory and all
    subdirectories and files.  The trustee can grant supervisor rights to other
    users in this directory and it subdirectories and files.  User's rights
    override all inherited rights masks in subdirectoriesand files.  The trustee
    can assign space limitations to subdirectories.  For a file, the trustee has
    all rights to this file. }
  TR_All                  = $01FF;
  { This attribute is a combination of the preceding two attributes. }

  (* Attributes of objects and properties in the bindery *)

  BF_Static               = $0000;
  { Object/property is permanent }
  BF_Dynamic              = $0001;
  { Object/property is temporary }
  BF_Item                 = $0000;
  { An item property }
  BF_Set                  = $0002;
  { A set property }

  {** Bindery object type definitions **}

  OT_Wild                      = $FFFF;
  { Wildcard }
  OT_Unknown                   = $0000;
  { Unknown }
  OT_User                      = $0001;
  { Object is a user }
  OT_UserGroup                 = $0002;
  { Object is a group }
  OT_PrintQueue                = $0003;
  { Object is a print queue }
  OT_FileServer                = $0004;
  { Object is a file server }
  OT_JobServer                 = $0005;
  OT_Gateway                   = $0006;
  OT_PrintServer               = $0007;
  OT_ArchiveQueue              = $0008;
  OT_ArchiveServer             = $0009;
  { Object is an archive server }
  OT_JobQueue                  = $000A;
  OT_Administration            = $000B;
  OT_NasSnaGateway             = $0021;
  OT_NACS                      = $0023;
  OT_RemoteBridgeServer        = $0024;
  OT_BridgeServer              = $0026;
  OT_TCPIPGateway              = $0027;
  OT_Gateway1                  = $0029;
  OT_TimeSynchronizationServer = $002D;
  OT_ArchiveServerDynamicSap   = $002E;
  OT_AdvertisingPrintServer    = $0047;
  OT_BtrieveVAPNLMv5xx         = $004B;
  OT_SQLVAPNLM                 = $004C;
  OT_XtreeNetworkVersion       = $004D;
  OT_BtrieveVAPNLMv4xx         = $0050;
  OT_AppleTalk                 = $0053;
  OT_X25Gateway                = $0088;
  OT_WanCopy                   = $0072;
  OT_NetwareForVMS             = $007A;
  OT_NetwareAccessServer       = $0098;
  OT_PortableNetware           = $009E;
  OT_CompaqIDAStatusMonitor    = $00AC;
  OT_Netware3xRemoteConsole    = $0107;
  OT_NNSDomain                 = $0133;
  OT_NNSProfile                = $0135;
  OT_NNSQueue                  = $0137;

  {*** THIRD PARTY BINDERY TYPES ***}

  OT_PegasusMail               = $9009;

type

  TAcctModes              = (ReadR, WriteR);
  TAccountRestrictions    = record
                              AccountExpirationDate         : TByte3;
                              AccountDisabledFlag           : BYTE;
                              PasswordExpirationDate        : TByte3;
                              GraceLoginsRemaining          : BYTE;
                              PasswordExpirationInterval    : WORD;
                              GraceLoginResetValue          : BYTE;
                              MinimumPasswordLength         : BYTE;
                              MaximumConcurrentConnections  : WORD;
                              AllowedLoginTimeBitmap        : TByte42;
                              LastLoginDateAndTime          : TByte6;
                              RestrictionFlags              : BYTE;
                              Unused                        : BYTE;
                              MaximumDiskUsageInBlocks      : LONGINT;
                              BadLoginCount                 : WORD;
                              NextResetTime                 : LONGINT;
                              BadLoginAddress               : TByte12;
                           end;

  {*** Connection Services ***}
type

  PConnectInfo    = ^TConnectInfo;
  TConnectInfo    = record
                      ConnectFlags                  : word;
                      SessionID                     : word;
                      ConnNumber                    : TNWConnNum;
                      ServerAddr                    : TByte12;
                      ServerType                    : TObjectType;
                      ServerName                    : TChar48;
                      ClientType                    : TObjectType;
                      ClientName                    : TChar48;
                    end;

  PConnUse        = ^TConnUse;
  TConnUse        = record
                      SystemElapsedTime             : longint;
                      BytesRead                     : TByte6;
                      BytesWritten                  : TByte6;
                      TotalRequestPackets           : longint;
                    end;

  TServerAddress  = record
                       NetworkNumber : longint;
                       NodeAddress   : TByte6;
                       SocketNumber  : word;
                       AddressValue  : TString10;

                     end;

  PINetAddr       = ^TINetAddr;
  TINetAddr       = record
                      NetworkAddr                   : TByte4;
                      NetNodeAddr                   : TByte6;
                      Socket                        : word;
                      ConnType                      : word;
                    end;

  {*** File System Services ***}

const

  {Search Attributes}

  SA_Normal               = $0000;
  SA_Hidden               = $0002;
  SA_System               = $0004;
  SA_Subdir_Only          = $0010;
  SA_Subdir_Files         = $8000;
  SA_All                  = $8006;

  {Change Mask Constants}

  MModifyNameBit          = $0001;
  MFileAttributesBit      = $0002;
  MCreateDateBit          = $0004;
  MCreateTimeBit          = $0008;
  MOwnerIDBit             = $0010;
  MLastArchivedDateBit    = $0020;
  MLastArchivedTimeBit    = $0040;
  MLastArchivedIDBit      = $0080;
  MLastUpdatedDateBit     = $0100;
  MLastUpdatedTimeBit     = $0200;
  MLastUpdatedIDBit       = $0400;
  MLastAccessedDateBit    = $0800;
  MInheritedRightsMaskBit = $1000;
  MMaximumSpaceBit        = $2000;

type

  PTrusteeInfo       = ^TTrusteeInfo;
  TTrusteeInfo       = record
                         ObjectID                   : TNWObjectID;
                         ObjectRights               : word;
                       end;

  PConnUsingFile     = ^TConnUsingFile;
  TConnUsingFile     = record
                         ConnNumber                 : TNWConnNum;
                         TaskNumber                 : word;
                         LockType                   : byte;
                         AccessControl              : byte;
                         LockFlag                   : byte;
                       end;

  PConnsUsingFile    = ^TConnsUsingFile;
  TConnsUsingFile    = record
                         NextRequest                : word;
                         UseCount                   : word;
                         OpenCount                  : word;
                         OpenForReadCount           : word;
                         OpenForWriteCount          : word;
                         DenyReadCount              : word;
                         DenyWriteCount             : word;
                         Locked                     : byte;
                         ForkCount                  : byte;
                         ConnCount                  : word;
                         ConnInfo                   : array [0 .. 69] of TConnUsingFile;
                       end;

  TNWDirInfo         = record
                         LastModifyDateAndTime      : longint;
                         NextTrusteeEntry           : longint;
                         Reserved                   : TByte48;
                         MaximumSpace               : longint;
                         InheritedRightsMask        : word;
                         Reserved2                  : TByte14;
                         VolObjectID                : TNWObjectID;
                         Reserved3                  : TByte8;
                       end;

  PDirSpaceInfo      = ^TDirSpaceInfo;
  TDirSpaceInfo      = record
                         TotalBlocks                : longint;
                         AvailableBlocks            : longint;
                         PurgeableBlocks            : longint;
                         NotYetPurgeableBlocks      : longint;
                         TotalDirEntries            : longint;
                         AvailableDirEntries        : longint;
                         Reserved                   : longint;
                         SectorsPerBlock            : byte;
                         VolName                    : TNWVolumeName;
                       end;

  TNWFileInfo        = record
                         UpdateDateAndTime          : longint;
                         UpdatorID                  : TNWObjectID;
                         FileSize                   : longint;
                         Reserved                   : TByte44;
                         InheritedRightsMask        : word;
                         LastAccessDate             : word;
                         Reserved2                  : TByte28;
                       end;

  PNWEntryInfo       = ^TNWEntryInfo;
  TNWEntryInfo       = record
                         Sequence                   : longint;
                         Parent                     : longint;
                         Attributes                 : longint;
                         UniqueID                   : byte;
                         Flags                      : byte;
                         NameSpace                  : byte;
                         Name                       : TString12;
                         CreationDateAndTime        : longint;
                         OnwerID                    : TNWObjectID;
                         LastArchiveDateAndTime     : longint;
                         LastArchiverID             : TNWObjectID;
                         case byte of

                           1: (FileInfo              : TNWFileInfo);
                           2: (DirInfo               : TNWDirInfo);

                       end;

  PNWEtInfo          = ^TNWEtInfo;
  TNWEtinfo          = record
                         EntryName                  : TChar16;
                         CreationDateAndTime        : longint;
                         OwnerID                    : TNWObjectID;
                         SequenceNumber             : longint;
                         TrusteeList                : array [0 .. 19] of TTrusteeInfo;
                       end;

  PNWExtFileInfo     = ^TNWExtFileInfo;
  TNWExtFileInfo     = record
                         Sequence                   : longint;
                         Parent                     : longint;
                         Attributes                 : longint;
                         UniqueID                   : byte;
                         Flags                      : byte;
                         NameSpace                  : byte;
                         Name                       : TString12;
                         CreationDateAndTime        : longint;
                         OwnerID                    : TNWObjectID;
                         LastArchiveDateAndTime     : longint;
                         LastArchiverID             : TNWObjectID;
                         UpdateDateAndTime          : longint;
                         LastUpdatorID              : TNWObjectID;
                         DataForkSize               : longint;
                         DataForkFirstFAT           : longint;
                         NextTrusteeEntry           : longint;
                         Reserved                   : TByte36;
                         InheritedRightsMask        : word;
                         LastAccessDate             : word;
                         DeletedFileTime            : longint;
                         DeletedDateAndTime         : longint;
                         DeletorID                  : TNWObjectID;
                         Reserved2                  : TByte16;
                         OtherForkSize              : TLongint2;
                       end;

  PNWFileInfo2       = ^TNWFileInfo2;
  TNWFileInfo2       = record
                         FileAttributes             : byte;
                         ExtendedFileAttributes     : byte;
                         FileSize                   : longint;
                         CreationDate               : word;
                         LastAccessDate             : word;
                         LastUpdateDateAndTime      : longint;
                         FileOwnerID                : TNWObjectID;
                         LastArchiveDateAndTime     : longint;
                         FileName                   : TChar260;
                       end;

  POpenFileConn      = ^TOpenFileConn;
  TOpenFileConn      = record
                         TaskNumber                 : word;
                         LockType                   : byte;
                         AccessControl              : byte;
                         LockFlag                   : byte;
                         VOlNumber                  : byte;
                         Parent                     : longint;
                         DirEntry                   : longint;
                         ForkCount                  : byte;
                         NameSpace                  : byte;
                         FileName                   : TString255;
                       end;

  POpenFileConnCtrl  = ^TOpenFileConnCtrl;
  TOpenFileConnCtrl  = record
                         NextRequest                : word;
                         OpenCount                  : word;
                         Buffer                     : TByte512;
                         CurRecord                  : word;
                       end;

  {*** Queue Management Services ***}

type

  TPrintServerClient = record
                         VersionNumber              : byte;
                         TabSize                    : byte;
                         NumberOfCopies             : word;
                         PrintControlFlags          : word;
                         MaxLinesPerPage            : word;
                         MaxCharsPerLine            : word;
                         FormName                   : TChar14;
                         Reserved1                  : TByte9;
                         BannerName                 : TChar14;
                         BannerFileName             : TChar14;
                         HeaderFileName             : TChar14;
                         DirectoryPath              : TChar80;
                       end;

  PNWQueueJobListReply = ^TNWQueueJobListReply;
  TNWQueueJobListReply = record
                           TotalQueueJobs           : longint;
                           ReplyQueueJobNumbers     : longint;
                           JobNumberList            : TLongint250;
                         end;

  PNWQueueJobStruct = ^TNWQueueJobStruct;
  TNWQueueJobStruct = record
                        ClientStation               : longint;
                        ClientTask                  : longint;
                        ClientID                    : TNWObjectID;
                        TargetServerID              : TNWObjectID;
                        TargetExecutionTime         : TByte6;
                        JobEntryTime                : TByte6;
                        JobNumber                   : longint;
                        JobType                     : word;
                        JobPosition                 : longint;
                        JobControlFlags             : longint;
                        JobFileName                 : TChar14;
                        JobFileHandle               : TByte6;
                        ServicingServerStation      : longint;
                        ServicingServerTask         : longint;
                        ServicingServerID           : TNWObjectID;
                        JobDescription              : TChar50;
                        case byte of

                          1: (ClientRecordArea            : TByte152);
                          2: (PrintServerClient           : TPrintServerClient);
                      end;
                        
  {*** Transaction Tracking Services ***}
type

  PTTS_Stats       = ^TTS_Stats;
  TTS_Stats        = record
                        SystemElapsedTime           : longint;
                        TTS_Supported               : byte;
                        TTS_Enabled                 : byte;
                        TTS_VolumeNumber            : word;
                        TTS_MaxOpenTransactions     : word;
                        TTS_MaxTransactionsOpened   : word;
                        TTS_CurrTransactionsOpen    : word;
                        TTS_TotalTransactions       : longint;
                        TTS_TotalWrites             : longint;
                        TTS_TotalBackouts           : longint;
                        TTS_UnfilledBackouts        : word;
                        TTS_DiskBlocksInUse         : word;
                        TTS_FATAllocations          : longint;
                        TTS_FileSizeChanges         : longint;
                        TTS_FilesTruncated          : longint;
                        NumberOfTransactions        : byte;
                        ConnectionNumber            : byte;
                        TaskNumber                  : byte;
                      end;

  {*** Volume Services ***}

type

  PNWVolExtendedInfo = ^TNWVolExtendedInfo;
  TNWVolExtendedInfo = record
                         VolType                      : longint;
                         StatusFlag                   : longint;
                         SectorSize                   : longint;
                         SectorsPerCluster            : longint;
                         VolSizeInClusters            : longint;
                         FreeClusters                 : longint;
                         SubAllocFreeableClusters     : longint;
                         FreeableLimboSectors         : longint;
                         NonFreeableLimboSectors      : longint;
                         AvailSubAllocSectors         : longint;
                         NonUseableSubAllocSectors    : longint;
                         SubAllocClusters             : longint;
                         NumDataStreams               : longint;
                         NumLimboDataStreams          : longint;
                         OldestDelFileAgeInTicks      : longint;
                         NumCompressedDataStreams     : longint;
                         NumCompressedLimboDataStreams: longint;
                         NumNonCompressibleDataStreams: longint;
                         PreCompressedSectors         : longint;
                         CompressedSectors            : longint;
                         NumMigratedDataStreams       : longint;
                         MigratedSectors              : longint;
                         ClustersUsedByFat            : longint;
                         ClustersUsedByDirs           : longint;
                         ClustersUsedByExtDirs        : longint;
                         TotalDirEntries              : longint;
                         UnusedDirEntries             : longint;
                         TotalExtDirExtants           : longint;
                         UnusedExtDirExtants          : longint;
                         ExtAttrsDefined              : longint;
                         ExtAttrExtantsUsed           : longint;
                         DirectoryServicesObjectID    : TNWObjectID;
                         VolLastModifiedDateAndTime   : longint;
                       end;

  PVolStats = ^TVolStats;
  TVolStats          = record
                         SystemElapsedTime            : longint;
                         VolumeNumber                 : byte;
                         LogicalDriveNumber           : byte;
                         SectorsPerBLock              : word;
                         StartBlock                   : word;
                         TotalBlocks                  : word;
                         AvailableBlocks              : word;
                         TotalDirectorySlots          : word;
                         AvailableDirectorySlots      : word;
                         MaxDirectorySlotsUsed        : word;
                         IsHashing                    : byte;
                         IsCaching                    : byte;
                         IsRemovable                  : byte;
                         IsMounted                    : byte;
                         VolumeName                   : TChar16;
                       end;

  TNWDirRestriction  = record
                         ObjectID                     : TNWObjectID;
                         Restriction                  : longint;
                       end;

  PNWVolRestrictions = ^TNWVolRestrictions;
  TNWVolRestrictions = record
                         NumberOfEntries              : byte;
                         Restrictions                 : array [0 .. 15] of TNWDirRestriction;
                       end;
implementation

end.
