unit Ttabldit;
{TableDitto component written by Gabor Naszadi}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,DB, DBTables;

type
  TStoreRec=record
    IsEmpty:Boolean;
    Buff   : Pointer;
  end;

  pStoreRec=^TStoreRec;

  TTableDitto = class(TTable)
  private
    FMemory   :Tlist;
    FDitto    :Boolean;
    FFirstTime:Boolean;
    procedure Allocate;
  protected
   procedure DoAfterPost; override;
   procedure DoOnNewRecord; override;
  public
   constructor Create(AOwner:Tcomponent); override;
   destructor  destroy; override;
  published
   property Ditto:Boolean read Fditto write Fditto;
  end;

procedure Register;

implementation
procedure   TTableDitto.Allocate;
 var i :integer;
     pP:pStoreRec;
 begin
  FMemory:=Tlist.create;
  for i:=0 to Self.fieldcount-1 do
  begin
    New(pP);
    GetMem(pP^.Buff, Self.Fields[i].DataSize);
    FMemory.Add(pP);
  end;
  FDitto:=True;
 end;

constructor  TTableDitto.Create(AOwner:Tcomponent);
 begin
  inherited Create(AOwner);
  FFirstTime:=True;
  FDitto:=True;
 end;

destructor  TTableDitto.Destroy;
 var i :integer;
     pP:pStoreRec;
 begin
 if Not FFirstTime then
 begin
  for i:=0 to Self.fieldcount-1 do
  begin
    FreeMem(TStoreRec(FMemory.list^[i]^).Buff, Self.Fields[i].DataSize);
    Dispose(FMemory.list^[i]);
  end;
  FMemory.Free;
 end;
 inherited Destroy;
 end;

procedure TTableDitto.DoAfterPost;
  var i:byte;
 begin
  If FFirstTime and FDitto
   then
    begin
     Allocate;
     FFirstTime:=False;
    end;
  If FDitto then
  for i:=0 to Self.fieldcount-1 do
  with Self.Fields[i],TStoreRec(fMemory.List^[i]^) do
   if not Isnull
   then
    begin
     GetData(Buff);
     IsEmpty:=False;
    end
   else
     IsEmpty:=True;
  inherited DoAfterPost;
 end;

procedure TTableDitto.DoOnNewRecord;
  var i:byte;
 begin
  If FDitto and Not FFirstTime then
  for i:=0 to Self.fieldcount-1 do
   with Self.Fields[i],TStoreRec(fMemory.List^[i]^) do
    If IsEmpty
     then clear
     else SetData(Buff);
  inherited DoOnNewRecord;
 end;

procedure Register;
begin
  RegisterComponents('Data Access', [TTableDitto]);
end;

end.
